/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.core.internal.buildpath;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.jdt.core.buildpath.ILibraryMaterializationPostProcessor;

class MavenLibraryMaterializationPostProcessor
implements ILibraryMaterializationPostProcessor {
    private static final String MAVEN_NATURE_ID = "org.eclipse.m2e.core.maven2Nature";

    MavenLibraryMaterializationPostProcessor() {
    }

    @Override
    public boolean applies(IJavaProject javaProject, IPath containerPath) throws CoreException {
        boolean applies = javaProject != null && javaProject.getProject().hasNature(MAVEN_NATURE_ID) && "org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER".equals(containerPath.toPortableString());
        return applies;
    }

    @Override
    public void execute(IJavaProject javaProject, IPath containerPath, IProgressMonitor monitor) throws CoreException {
        if (this.applies(javaProject, containerPath)) {
            this.removeExclusionPatterns(javaProject, monitor);
            EclipseUtil.removeNatureFromProject((IProject)javaProject.getProject(), (String)MAVEN_NATURE_ID);
        }
    }

    private void removeExclusionPatterns(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newEntriesList = new ArrayList<IClasspathEntry>(entries.length);
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                IPath[] newExclusionPatterns = this.getExclusionPatterns(entry.getExclusionPatterns());
                IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])newExclusionPatterns, (IPath)entry.getOutputLocation(), (IClasspathAttribute[])entry.getExtraAttributes());
                newEntriesList.add(newEntry);
            } else {
                newEntriesList.add(entry);
            }
            ++n2;
        }
        IClasspathEntry[] newEntries = new IClasspathEntry[newEntriesList.size()];
        newEntriesList.toArray(newEntries);
        javaProject.setRawClasspath(newEntries, monitor);
    }

    private IPath[] getExclusionPatterns(IPath[] existingPatterns) {
        ArrayList<IPath> exclusionPatterns = new ArrayList<IPath>(existingPatterns.length);
        IPath[] iPathArray = existingPatterns;
        int n = existingPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            IPath p = iPathArray[n2];
            if (!"**".equals(p.toPortableString())) {
                exclusionPatterns.add(p);
            }
            ++n2;
        }
        IPath[] newExclusionPatterns = new IPath[exclusionPatterns.size()];
        exclusionPatterns.toArray(newExclusionPatterns);
        return newExclusionPatterns;
    }
}

