/*
 * Decompiled with CFR 0.152.
 */
package tern.utils;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import tern.ITernProject;
import tern.TernException;
import tern.metadata.ModuleDependenciesComparator;
import tern.metadata.TernModuleMetadata;
import tern.server.BasicTernDef;
import tern.server.BasicTernPlugin;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.server.ITernPlugin;
import tern.server.ModuleType;
import tern.server.TernDef;
import tern.server.TernModuleConfigurable;
import tern.server.TernPlugin;
import tern.utils.StringUtils;

public class TernModuleHelper {
    public static List<ITernModule> groupByType(List<ITernModule> modules) {
        ArrayList<ITernModule> groupedModules = new ArrayList<ITernModule>();
        HashMap<String, TernModuleConfigurable> wrappers = null;
        for (ITernModule module : modules) {
            TernModuleConfigurable wrapper;
            if (!TernModuleHelper.isConfigurableModule(module)) {
                groupedModules.add(module);
                continue;
            }
            if (wrappers == null) {
                wrappers = new HashMap<String, TernModuleConfigurable>();
            }
            if ((wrapper = (TernModuleConfigurable)wrappers.get(module.getType())) == null) {
                wrapper = new TernModuleConfigurable(module);
                wrappers.put(module.getType(), wrapper);
                groupedModules.add(wrapper);
                continue;
            }
            wrapper.addModule(module);
        }
        return groupedModules;
    }

    public static boolean isConfigurableModule(ITernModule module) {
        TernModuleMetadata metadata = module.getMetadata();
        return !StringUtils.isEmpty(module.getVersion()) || metadata != null && metadata.getOptions().size() > 0;
    }

    public static void update(List<ITernDef> defs, List<ITernPlugin> plugins, ITernModule module) {
        TernModuleHelper.update(defs, plugins, null, module);
    }

    private static void update(List<ITernDef> defs, List<ITernPlugin> plugins, JsonObject options, ITernModule module) {
        switch (module.getModuleType()) {
            case Def: {
                defs.add((ITernDef)module);
                break;
            }
            case Plugin: {
                plugins.add((ITernPlugin)module);
                break;
            }
            case Configurable: {
                ITernModule wrappedModule = ((ITernModuleConfigurable)module).getWrappedModule();
                JsonObject wrappedOptions = ((ITernModuleConfigurable)module).getOptions();
                TernModuleHelper.update(defs, plugins, wrappedOptions, wrappedModule);
            }
        }
    }

    public static void update(ITernModule module, ITernProject ternProject) {
        TernModuleHelper.update(module, null, ternProject);
    }

    public static void update(ITernModule module, JsonObject options, ITernProject ternProject) {
        switch (module.getModuleType()) {
            case Def: {
                ternProject.addLib((ITernDef)module);
                break;
            }
            case Plugin: {
                ternProject.addPlugin((ITernPlugin)module, options);
                break;
            }
            case Configurable: {
                ITernModule wrappedModule = ((ITernModuleConfigurable)module).getWrappedModule();
                JsonObject wrappedOptions = ((ITernModuleConfigurable)module).getOptions();
                TernModuleHelper.update(wrappedModule, wrappedOptions, ternProject);
            }
        }
    }

    public static ITernModuleConfigurable findConfigurable(ITernModule module, JsonValue options, List<ITernModule> allModules) throws TernException {
        String version = module.getVersion();
        for (ITernModule f : allModules) {
            if (f.getModuleType() != ModuleType.Configurable || f.getType() != module.getType()) continue;
            if (!StringUtils.isEmpty(version)) {
                ((ITernModuleConfigurable)f).setVersion(version);
            }
            if (options instanceof JsonObject) {
                ((ITernModuleConfigurable)f).setOptions(new JsonObject((JsonObject)options));
            }
            return (ITernModuleConfigurable)f;
        }
        return null;
    }

    public static boolean hasOptions(ITernModule module) {
        if (module == null || module.getMetadata() == null) {
            return false;
        }
        return module.getMetadata().getOptions().size() > 0;
    }

    public static ITernModule getModule(String filename) {
        if (filename.startsWith("tern-")) {
            String name = filename.substring("tern-".length(), filename.length());
            return TernModuleHelper.getPlugin(name);
        }
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        String fileExtension = filename.substring(index + 1, filename.length());
        if (fileExtension.equals("json")) {
            String name = filename.substring(0, index);
            return TernModuleHelper.getDef(name);
        }
        if (fileExtension.equals("js")) {
            String name = filename.substring(0, index);
            return TernModuleHelper.getPlugin(name);
        }
        return null;
    }

    private static ITernDef getDef(String name) {
        ITernDef def = TernDef.getTernDef(name);
        if (def != null) {
            return def;
        }
        return new BasicTernDef(name);
    }

    private static ITernPlugin getPlugin(String name) {
        ITernPlugin plugin = TernPlugin.getTernPlugin(name);
        if (plugin != null) {
            return plugin;
        }
        return new BasicTernPlugin(name);
    }

    public static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    public static String getFileName(ITernModule module) {
        switch (module.getModuleType()) {
            case Def: {
                return module.getName() + '.' + "json";
            }
        }
        return module.getName() + '.' + "js";
    }

    public static void sort(List<ITernModule> modules) {
        new ModuleDependenciesComparator(modules);
    }

    public static String getModulesAsString(ITernModule ... modules) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < modules.length) {
            if (i > 0) {
                s.append(",");
            }
            s.append(modules[i].getName());
            ++i;
        }
        return s.toString();
    }
}

