/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import tern.eclipse.ide.tools.internal.ui.TernToolsUIPlugin;
import tern.eclipse.ide.tools.internal.ui.Trace;

public class ImageResource {
    private static ImageRegistry imageRegistry;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    private static final String URL_WIZBAN = "full/wizban/";
    public static final String IMG_NEWPLUGIN_WIZ = "newplugin_wiz";
    public static final String IMG_NEWTYPEDEF_WIZ = "newtypedef_wiz";

    static {
        try {
            String pathSuffix = "icons/";
            ICON_BASE_URL = TernToolsUIPlugin.getDefault().getBundle().getEntry(pathSuffix);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Images error", e);
        }
    }

    private ImageResource() {
    }

    protected static void dispose() {
    }

    public static Image getImage(String key) {
        return ImageResource.getImage(key, null);
    }

    public static Image getImage(String key, String keyIfImageNull) {
        Image image;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((image = imageRegistry.get(key)) == null) {
            if (keyIfImageNull != null) {
                return ImageResource.getImage(keyIfImageNull, null);
            }
            imageRegistry.put(key, ImageDescriptor.getMissingImageDescriptor());
            image = imageRegistry.get(key);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor id;
        if (imageRegistry == null) {
            ImageResource.initializeImageRegistry();
        }
        if ((id = imageDescriptors.get(key)) != null) {
            return id;
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    protected static void initializeImageRegistry() {
        imageRegistry = TernToolsUIPlugin.getDefault().getImageRegistry();
        imageDescriptors = new HashMap<String, ImageDescriptor>();
        ImageResource.registerImage(IMG_NEWPLUGIN_WIZ, "full/wizban/newplugin_wiz.png");
        ImageResource.registerImage(IMG_NEWTYPEDEF_WIZ, "full/wizban/newtypedef_wiz.png");
    }

    private static void registerImage(String key, String partialURL) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            imageRegistry.put(key, id);
            imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error registering image " + key + " from " + partialURL, e);
        }
    }
}

