/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidationUtil;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.common.validation.internal.SimpleValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.validation.KBValidator;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamAnnotatedFactory;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamComponentMethod;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamFactory;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.core.SeamCoreBuilder;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamPreferences;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.internal.core.DataModelSelectionAttribute;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.SeamTextSourceReference;
import org.jboss.tools.seam.internal.core.validation.SeamValidationErrorManager;
import org.jboss.tools.seam.internal.core.validation.SeamValidationMessages;

public class SeamCoreValidator
extends SeamValidationErrorManager
implements org.jboss.tools.common.validation.IValidator {
    public static final String ID = "org.jboss.tools.seam.core.CoreValidator";
    public static final int NONUNIQUE_COMPONENT_NAME_MESSAGE_ID = 1;
    public static final int DUPLICATE_REMOVE_MESSAGE_ID = 2;
    public static final int DUPLICATE_DESTROY_MESSAGE_ID = 3;
    public static final int DUPLICATE_CREATE_MESSAGE_ID = 4;
    public static final int DUPLICATE_UNWRAP_MESSAGE_ID = 5;
    public static final int DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN_MESSAGE_ID = 6;
    public static final int CREATE_DOESNT_BELONG_TO_COMPONENT_MESSAGE_ID = 7;
    public static final int UNWRAP_DOESNT_BELONG_TO_COMPONENT_MESSAGE_ID = 8;
    public static final int OBSERVER_DOESNT_BELONG_TO_COMPONENT_MESSAGE_ID = 9;
    public static final int STATEFUL_COMPONENT_DOES_NOT_CONTAIN_REMOVE_ID = 10;
    public static final int STATEFUL_COMPONENT_DOES_NOT_CONTAIN_DESTROY_ID = 11;
    public static final int STATEFUL_COMPONENT_WRONG_SCOPE_ID = 12;
    public static final int ENTITY_COMPONENT_WRONG_SCOPE_ID = 13;
    public static final int UNKNOWN_COMPONENT_PROPERTY_ID = 14;
    private ISeamProject seamProject;
    private SeamProjectsSet set;
    private String projectName;
    private static final String SHORT_ID = "jboss.seam.core";
    private static final String BUILT_IN_COMPONENT_NAME_PREFIX = "org.jboss.seam.";
    static String ATTR_NO_CONVERSATION_VIEW_ID = "no conversation view id";
    static String ATTR_LOGIN_VIEW_ID = "login view id";

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return SeamCoreBuilder.BUILDER_ID;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        return SeamCoreValidator.getSeamValidatingProjects(project);
    }

    public static IValidatingProjectTree getSeamValidatingProjects(IProject project) {
        ISeamProject seamProject;
        SeamProjectsSet set = new SeamProjectsSet(project);
        IProject war = set.getWarProject();
        IProjectValidationContext rootContext = null;
        if (war != null && war.isAccessible()) {
            IKbProject kbProject = KbProjectFactory.getKbProject((IProject)war, (boolean)false);
            if (kbProject != null) {
                rootContext = kbProject.getValidationContext();
            } else {
                KbProject.checkKBBuilderInstalled((IResource)war);
                ISeamProject seamProject2 = SeamCorePlugin.getSeamProject(war, false);
                if (seamProject2 != null) {
                    rootContext = seamProject2.getValidationContext();
                }
            }
        }
        if (rootContext == null && (seamProject = SeamCorePlugin.getSeamProject(project, false)) != null) {
            rootContext = seamProject.getValidationContext();
            war = project;
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        IProject[] array = set.getAllProjects();
        int i = 0;
        while (i < array.length) {
            if (array[i].isAccessible()) {
                projects.add(array[i]);
            }
            ++i;
        }
        ValidatingProjectSet projectSet = new ValidatingProjectSet(war, projects, rootContext);
        return new SimpleValidatingProjectTree((IValidatingProjectSet)projectSet);
    }

    public boolean isEnabled(IProject project) {
        return SeamPreferences.isValidationEnabled(project);
    }

    public boolean shouldValidate(IProject project) {
        try {
            return project != null && project.isAccessible() && project.hasNature("org.jboss.tools.seam.core.seamnature") && this.validateBuilderOrder(project) && this.isPreferencesEnabled(project);
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
            return false;
        }
    }

    private boolean validateBuilderOrder(IProject project) throws CoreException {
        return KBValidator.validateBuilderOrder((IProject)project, (String)this.getBuilderId(), (String)this.getId(), (SeverityPreferences)SeamPreferences.getInstance());
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, validationContext, manager, reporter);
        this.set = new SeamProjectsSet(project);
        IProject warProject = this.set.getWarProject();
        this.seamProject = null;
        this.projectName = null;
        if (warProject.isAccessible()) {
            this.seamProject = SeamCorePlugin.getSeamProject(warProject, false);
            this.projectName = this.seamProject.getProject().getName();
        }
    }

    private boolean isPreferencesEnabled(IProject project) {
        return this.isEnabled(project) && SeamPreferences.shouldValidateCore(project);
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        if (this.seamProject == null) {
            return this.OK_STATUS;
        }
        this.displaySubtask(SeamValidationMessages.SEARCHING_RESOURCES, new String[]{this.projectName});
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        HashSet<ISeamComponent> checkedComponents = new HashSet<ISeamComponent>();
        HashSet<String> markedDuplicateFactoryNames = new HashSet<String>();
        HashSet<Object> resources = new HashSet<Object>();
        HashSet<IPath> newResources = new HashSet<IPath>();
        boolean validateUnnamedResources = false;
        for (IFile currentFile : changedFiles) {
            if (reporter.isCancelled()) break;
            if (!validateUnnamedResources) {
                String fileName = currentFile.getName().toLowerCase();
                boolean bl = validateUnnamedResources = fileName.endsWith(".java") || fileName.endsWith(".properties") || fileName.equals("components.xml");
            }
            if (!ValidationUtil.checkFileExtensionForJavaAndXml((IFile)currentFile)) continue;
            resources.add(currentFile.getFullPath());
            Set<String> newVariableNamesOfChangedFile = this.getVariablesNameByResource(currentFile.getFullPath());
            Set oldDeclarationsOfChangedFile = this.validationContext.getVariableNamesByCoreResource(SHORT_ID, currentFile.getFullPath(), true);
            Iterator iterator = newVariableNamesOfChangedFile.iterator();
            while (iterator.hasNext()) {
                String newVariableName = (String)iterator.next();
                Set linkedResources = this.validationContext.getCoreResourcesByVariableName(SHORT_ID, newVariableName, false);
                if (linkedResources != null) {
                    resources.addAll(linkedResources);
                }
                resources.addAll(this.getAllResourceOfComponent(currentFile.getFullPath()));
            }
            Set oldVariablesNamesOfChangedFile = this.validationContext.getVariableNamesByCoreResource(SHORT_ID, currentFile.getFullPath(), false);
            if (oldVariablesNamesOfChangedFile != null) {
                for (String name : oldVariablesNamesOfChangedFile) {
                    Set linkedResources = this.validationContext.getCoreResourcesByVariableName(SHORT_ID, name, false);
                    if (linkedResources == null) continue;
                    resources.addAll(linkedResources);
                }
            }
            if (oldDeclarationsOfChangedFile != null) {
                for (String name : oldDeclarationsOfChangedFile) {
                    this.validationContext.addVariableNameForELValidation(SHORT_ID, name);
                }
            }
            newResources.add(currentFile.getFullPath());
        }
        this.validationContext.removeLinkedCoreResources(SHORT_ID, resources);
        HashSet<IFile> filesToValidate = new HashSet<IFile>();
        for (IPath iPath : resources) {
            IFile file = root.getFile(iPath);
            if (file == null || !this.shouldBeValidated(file)) continue;
            filesToValidate.add(file);
            this.removeAllMessagesFromResource((IResource)file);
        }
        for (IFile iFile : filesToValidate) {
            this.validateComponent(iFile.getFullPath(), checkedComponents, newResources);
            this.validateFactory(iFile.getFullPath(), markedDuplicateFactoryNames);
            this.validatePageXML(iFile);
            this.validateXMLVersion(iFile);
        }
        if (validateUnnamedResources) {
            Set set = this.validationContext.getUnnamedCoreResources(SHORT_ID);
            newResources.addAll(set);
            for (IPath path : newResources) {
                IFile file = root.getFile(path);
                if (file == null || !file.isAccessible()) continue;
                if (!resources.contains(path)) {
                    this.removeAllMessagesFromResource((IResource)file);
                }
                this.displaySubtask(SeamValidationMessages.VALIDATING_RESOURCE, new String[]{this.projectName, path.toString()});
                Set<ISeamJavaComponentDeclaration> declarations = ((SeamProject)this.seamProject).findJavaDeclarations(path);
                for (ISeamJavaComponentDeclaration d : declarations) {
                    this.validateMethodsOfUnknownComponent(d);
                }
            }
        }
        return this.OK_STATUS;
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        ISeamJavaComponentDeclaration[] values;
        Object object;
        ISeamComponent[] components;
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        if (this.seamProject == null) {
            return this.OK_STATUS;
        }
        IProject[] iProjectArray = this.set.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            this.removeAllMessagesFromResource((IResource)iProject);
            ++n2;
        }
        ISeamComponent[] iSeamComponentArray = components = this.seamProject.getComponents();
        int n3 = components.length;
        n = 0;
        while (n < n3) {
            ISeamComponent component = iSeamComponentArray[n];
            if (reporter.isCancelled()) {
                return this.OK_STATUS;
            }
            Set<ISeamComponentDeclaration> declarations = component.getAllDeclarations();
            object = declarations.iterator();
            if (object.hasNext()) {
                ISeamComponentDeclaration cfr_ignored_0 = (ISeamComponentDeclaration)object.next();
                this.validateComponent(component);
            }
            ++n;
        }
        ISeamFactory[] factories = this.seamProject.getFactories();
        HashSet<String> markedDuplicateFactoryNames = new HashSet<String>();
        object = factories;
        int n4 = factories.length;
        int n5 = 0;
        while (n5 < n4) {
            Object factory = object[n5];
            if (reporter.isCancelled()) {
                return this.OK_STATUS;
            }
            this.validateFactory((ISeamFactory)factory, markedDuplicateFactoryNames);
            ++n5;
        }
        ISeamJavaComponentDeclaration[] iSeamJavaComponentDeclarationArray = values = ((SeamProject)this.seamProject).getAllJavaComponentDeclarations();
        int n6 = values.length;
        n4 = 0;
        while (n4 < n6) {
            ISeamJavaComponentDeclaration d = iSeamJavaComponentDeclarationArray[n4];
            if (reporter.isCancelled()) {
                return this.OK_STATUS;
            }
            this.displaySubtask(SeamValidationMessages.VALIDATING_CLASS, new String[]{this.projectName, d.getClassName()});
            this.validateMethodsOfUnknownComponent(d);
            ++n4;
        }
        IContainer webContent = this.set.getViewsFolder();
        if (webContent instanceof IContainer && webContent.isAccessible()) {
            this.validateAllPageXMLFiles(webContent);
        }
        return this.OK_STATUS;
    }

    void validateAllPageXMLFiles(IContainer c) {
        if (c.isAccessible()) {
            IResource[] rs = null;
            try {
                rs = c.members();
            }
            catch (CoreException e) {
                SeamCorePlugin.getDefault().logError(e);
                return;
            }
            int i = 0;
            while (i < rs.length) {
                if (rs[i] instanceof IContainer) {
                    this.validateAllPageXMLFiles((IContainer)rs[i]);
                } else if (rs[i] instanceof IFile) {
                    this.validatePageXML((IFile)rs[i]);
                }
                ++i;
            }
        }
    }

    private void validateFactory(IPath sourceFilePath, Set<String> markedDuplicateFactoryNames) {
        Set<ISeamFactory> factories = this.seamProject.getFactoriesByPath(sourceFilePath);
        for (ISeamFactory factory : factories) {
            this.validateFactory(factory, markedDuplicateFactoryNames);
        }
    }

    private void validateFactory(ISeamFactory factory, Set<String> markedDuplicateFactoryNames) {
        if (SeamUtil.isJar(factory.getSourcePath())) {
            return;
        }
        String factoryName = factory.getName();
        if (factoryName != null) {
            this.displaySubtask(SeamValidationMessages.VALIDATING_FACTORY, new String[]{this.projectName, factoryName});
        }
        if (factory instanceof ISeamAnnotatedFactory) {
            this.validateAnnotatedFactory((ISeamAnnotatedFactory)factory, markedDuplicateFactoryNames);
        } else {
            this.validateXmlFactory((ISeamXmlFactory)factory, markedDuplicateFactoryNames);
        }
    }

    private void validateXmlFactory(ISeamXmlFactory factory, Set<String> markedDuplicateFactoryNames) {
        String name = factory.getName();
        if (name == null) {
            SeamCorePlugin.getDefault().logError(NLS.bind((String)SeamCoreMessages.SEAM_CORE_VALIDATOR_FACTORY_METHOD_MUST_HAVE_NAME, (Object)factory.getResource()));
            return;
        }
        this.validateFactoryName(factory, name, markedDuplicateFactoryNames, false);
    }

    private void validateAnnotatedFactory(ISeamAnnotatedFactory factory, Set<String> markedDuplicateFactoryNames) {
        IMember sourceMember = factory.getSourceMember();
        if (sourceMember instanceof IMethod) {
            String factoryName = factory.getName();
            if (factoryName == null) {
                SeamCorePlugin.getDefault().logError(NLS.bind((String)SeamCoreMessages.SEAM_CORE_VALIDATOR_FACTORY_METHOD_MUST_HAVE_NAME, (Object)factory.getResource()));
                return;
            }
            this.validateFactoryName(factory, factoryName, markedDuplicateFactoryNames, true);
        }
    }

    private void validateFactoryName(ISeamFactory factory, String factoryName, Set<String> markedDuplicateFactoryNames, boolean validateUnknownName) {
        IMember sourceMember;
        ScopeType factoryScope = factory.getScope();
        Set<ISeamContextVariable> variables = this.seamProject.getVariablesByName(factoryName);
        boolean unknownVariable = true;
        boolean firstDuplicateVariableWasMarked = false;
        for (ISeamContextVariable variable : variables) {
            if (variable instanceof ISeamFactory) {
                if (variable == factory || markedDuplicateFactoryNames.contains(factoryName) || factoryScope != variable.getScope() && factoryScope.getPriority() <= variable.getScope().getPriority()) continue;
                ITextSourceReference location = null;
                if (!firstDuplicateVariableWasMarked) {
                    firstDuplicateVariableWasMarked = true;
                    this.validationContext.addLinkedCoreResource(SHORT_ID, factoryName, factory.getSourcePath(), true);
                    location = SeamUtil.getLocationOfName(factory);
                    this.addError(SeamValidationMessages.DUPLICATE_VARIABLE_NAME, SeamPreferences.DUPLICATE_VARIABLE_NAME, new String[]{factoryName}, location, factory.getResource());
                }
                if (SeamUtil.isJar(variable.getSourcePath())) continue;
                IResource resource = SeamUtil.getComponentResourceWithName(variable);
                this.validationContext.addLinkedCoreResource(SHORT_ID, factoryName, resource.getFullPath(), true);
                location = SeamUtil.getLocationOfName(variable);
                this.addError(SeamValidationMessages.DUPLICATE_VARIABLE_NAME, SeamPreferences.DUPLICATE_VARIABLE_NAME, new String[]{factoryName}, location, resource);
                continue;
            }
            unknownVariable = false;
        }
        if (firstDuplicateVariableWasMarked) {
            markedDuplicateFactoryNames.add(factoryName);
        }
        boolean voidReturnType = false;
        if (factory instanceof ISeamAnnotatedFactory && (sourceMember = ((ISeamAnnotatedFactory)factory).getSourceMember()) instanceof IMethod) {
            IMethod method = (IMethod)sourceMember;
            try {
                String returnType = method.getReturnType();
                if ("V".equals(returnType)) {
                    voidReturnType = true;
                }
            }
            catch (JavaModelException e) {
                SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_CORE_VALIDATOR_ERROR_VALIDATING_SEAM_CORE, e);
            }
        }
        if (unknownVariable && validateUnknownName && voidReturnType) {
            this.validationContext.addLinkedCoreResource(SHORT_ID, factoryName, factory.getSourcePath(), true);
            this.addError(SeamValidationMessages.UNKNOWN_FACTORY_NAME, SeamPreferences.UNKNOWN_FACTORY_NAME, new String[]{factoryName}, SeamUtil.getLocationOfName(factory), factory.getResource());
        }
    }

    private void validateComponent(IPath sourceFilePath, Set<ISeamComponent> checkedComponents, Set<IPath> unnamedResources) {
        Set<ISeamComponent> components = this.seamProject.getComponentsByPath(sourceFilePath);
        if (components.isEmpty()) {
            unnamedResources.add(sourceFilePath);
            return;
        }
        for (ISeamComponent component : components) {
            if (checkedComponents.contains(component)) continue;
            this.validateComponent(component);
            checkedComponents.add(component);
        }
    }

    private Set<String> getVariablesNameByResource(IPath resourcePath) {
        Set<ISeamContextVariable> variables = this.seamProject.getVariablesByPath(resourcePath);
        HashSet<String> result = new HashSet<String>();
        if (variables != null) {
            for (ISeamContextVariable variable : variables) {
                String name = variable.getName();
                result.add(name);
            }
        }
        return result;
    }

    private Set<IPath> getAllResourceOfComponent(IPath sourceComponentFilePath) {
        HashSet<IPath> result = new HashSet<IPath>();
        Set<ISeamComponent> components = this.seamProject.getComponentsByPath(sourceComponentFilePath);
        for (ISeamComponent component : components) {
            Set<ISeamComponentDeclaration> declarations = component.getAllDeclarations();
            for (ISeamComponentDeclaration seamComponentDeclaration : declarations) {
                result.add(seamComponentDeclaration.getResource().getFullPath());
            }
        }
        return result;
    }

    private void validateComponent(ISeamComponent component) {
        ISeamJavaComponentDeclaration firstJavaDeclaration = component.getJavaDeclaration();
        if (firstJavaDeclaration != null) {
            boolean source;
            String componentName = component.getName();
            if (componentName != null) {
                this.displaySubtask(SeamValidationMessages.VALIDATING_COMPONENT, new String[]{this.projectName, componentName});
            }
            HashMap<Integer, ISeamJavaComponentDeclaration> usedPrecedences = new HashMap<Integer, ISeamJavaComponentDeclaration>();
            HashSet<ISeamJavaComponentDeclaration> markedDeclarations = new HashSet<ISeamJavaComponentDeclaration>();
            int firstJavaDeclarationPrecedence = firstJavaDeclaration.getPrecedence();
            usedPrecedences.put(firstJavaDeclarationPrecedence, firstJavaDeclaration);
            Set<ISeamComponentDeclaration> declarations = component.getAllDeclarations();
            for (ISeamComponentDeclaration declaration : declarations) {
                boolean sourceJavaDeclaration;
                if (!(declaration instanceof ISeamJavaComponentDeclaration)) continue;
                ISeamJavaComponentDeclaration jd = (ISeamJavaComponentDeclaration)declaration;
                IType type = (IType)jd.getSourceMember();
                boolean bl = sourceJavaDeclaration = !type.isBinary();
                if (sourceJavaDeclaration) {
                    this.validationContext.addLinkedCoreResource(SHORT_ID, componentName, declaration.getSourcePath(), true);
                    try {
                        IType[] superTypes = TypeInfoCollector.getSuperTypes((IType)type).getSuperTypes();
                        int i = 0;
                        while (superTypes != null && i < superTypes.length) {
                            if (!superTypes[i].isBinary()) {
                                IPath path = superTypes[i].getResource().getFullPath();
                                this.validationContext.addLinkedCoreResource(SHORT_ID, componentName, path, true);
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                }
                if (declaration == firstJavaDeclaration) continue;
                ISeamJavaComponentDeclaration javaDeclaration = (ISeamJavaComponentDeclaration)declaration;
                int javaDeclarationPrecedence = javaDeclaration.getPrecedence();
                ISeamJavaComponentDeclaration checkedDeclaration = (ISeamJavaComponentDeclaration)usedPrecedences.get(javaDeclarationPrecedence);
                if (checkedDeclaration == null) {
                    usedPrecedences.put(javaDeclarationPrecedence, javaDeclaration);
                    continue;
                }
                if (!sourceJavaDeclaration) continue;
                boolean sourceCheckedDeclaration = !((IType)checkedDeclaration.getSourceMember()).isBinary();
                IResource javaDeclarationResource = javaDeclaration.getResource();
                if (!markedDeclarations.contains(checkedDeclaration) && sourceCheckedDeclaration) {
                    IResource checkedDeclarationResource = checkedDeclaration.getResource();
                    ITextSourceReference location = ((SeamComponentDeclaration)((Object)checkedDeclaration)).getLocationFor("name");
                    if (!SeamUtil.isEmptyLocation(location)) {
                        this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, checkedDeclarationResource, 1);
                    }
                    markedDeclarations.add(checkedDeclaration);
                }
                markedDeclarations.add(javaDeclaration);
                ITextSourceReference location = ((SeamComponentDeclaration)((Object)javaDeclaration)).getLocationFor("name");
                if (SeamUtil.isEmptyLocation(location)) continue;
                this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, javaDeclarationResource, 1);
            }
            boolean bl = source = !((IType)firstJavaDeclaration.getSourceMember()).isBinary();
            if (source) {
                this.validateJavaDeclaration(component, firstJavaDeclaration);
            }
        }
        this.validateXmlComponentDeclarations(component);
    }

    private boolean isBuiltInComponentName(String componentName) {
        return componentName.startsWith(BUILT_IN_COMPONENT_NAME_PREFIX);
    }

    private void validateXmlComponentDeclarations(ISeamComponent component) {
        String componentName = component.getName();
        if (componentName != null) {
            HashMap<String, ISeamXmlComponentDeclaration> usedPrecedences = new HashMap<String, ISeamXmlComponentDeclaration>();
            HashSet<ISeamXmlComponentDeclaration> markedDeclarations = new HashSet<ISeamXmlComponentDeclaration>();
            HashSet<ISeamJavaComponentDeclaration> markedJavaDeclarations = new HashSet<ISeamJavaComponentDeclaration>();
            Set<ISeamXmlComponentDeclaration> declarations = component.getXmlDeclarations();
            ISeamXmlComponentDeclaration firstNamedDeclaration = null;
            for (ISeamXmlComponentDeclaration declaration : declarations) {
                if (SeamUtil.isJar(declaration)) {
                    return;
                }
                this.validationContext.addLinkedCoreResource(SHORT_ID, componentName, declaration.getSourcePath(), true);
                String precedence = declaration.getPrecedence();
                if (firstNamedDeclaration == null && declaration.getName() != null) {
                    firstNamedDeclaration = declaration;
                    usedPrecedences.put(precedence, declaration);
                }
                if (declaration.getName() != null && firstNamedDeclaration != declaration) {
                    ISeamXmlComponentDeclaration checkedDeclaration = (ISeamXmlComponentDeclaration)usedPrecedences.get(precedence);
                    if (checkedDeclaration == null) {
                        usedPrecedences.put(precedence, declaration);
                    } else {
                        if (!markedDeclarations.contains(checkedDeclaration)) {
                            IResource checkedDeclarationResource = checkedDeclaration.getResource();
                            ITextSourceReference location = ((SeamComponentDeclaration)((Object)checkedDeclaration)).getLocationFor("name");
                            if (!SeamUtil.isEmptyLocation(location)) {
                                this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, checkedDeclarationResource, 1);
                            }
                            markedDeclarations.add(checkedDeclaration);
                        }
                        markedDeclarations.add(declaration);
                        ITextSourceReference location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("name");
                        if (!SeamUtil.isEmptyLocation(location)) {
                            this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, declaration.getResource(), 1);
                        }
                    }
                }
                Set<ISeamContextVariable> vars = this.seamProject.getVariablesByName(componentName);
                for (ISeamContextVariable variable : vars) {
                    if (!(variable instanceof ISeamComponent)) continue;
                    ISeamComponent c = (ISeamComponent)variable;
                    Set<ISeamComponentDeclaration> decls = c.getAllDeclarations();
                    for (ISeamComponentDeclaration dec : decls) {
                        ITextSourceReference location;
                        String javaPrecedence;
                        if (!(dec instanceof ISeamJavaComponentDeclaration)) continue;
                        ISeamJavaComponentDeclaration javaDec = (ISeamJavaComponentDeclaration)dec;
                        if (declaration.getClassName() == null || javaDec.getName() == null || !javaDec.getName().equals(declaration.getName()) || !(javaPrecedence = "" + javaDec.getPrecedence()).equals(precedence) || this.isBuiltInComponentName(componentName)) continue;
                        if (!markedJavaDeclarations.contains(javaDec)) {
                            markedJavaDeclarations.add(javaDec);
                            location = ((SeamComponentDeclaration)((Object)javaDec)).getLocationFor("name");
                            this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, javaDec.getResource(), 1);
                        }
                        if (markedDeclarations.contains(declaration)) continue;
                        markedDeclarations.add(declaration);
                        location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("name");
                        this.addError(SeamValidationMessages.NONUNIQUE_COMPONENT_NAME_MESSAGE, SeamPreferences.NONUNIQUE_COMPONENT_NAME, new String[]{componentName}, location, declaration.getResource(), 1);
                    }
                }
                String className = declaration.getClassName();
                IType type = null;
                if (className != null) {
                    try {
                        IProject p = this.seamProject.getProject();
                        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)p);
                        if (javaProject == null) {
                            SeamCorePlugin.getDefault().logWarning("Can't get Java project for " + this.seamProject.getProject() != null ? this.seamProject.getProject().getName() : " Seam project.");
                            return;
                        }
                        type = javaProject.findType(className);
                        if (type == null) {
                            ITextSourceReference location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("class");
                            if (SeamUtil.isEmptyLocation(location)) {
                                location = ((SeamComponentDeclaration)((Object)declaration)).getLocationFor("name");
                            }
                            if (SeamUtil.isEmptyLocation(location)) {
                                location = declaration;
                            }
                            if (!declaration.isClassNameGuessed()) {
                                this.addError(SeamValidationMessages.UNKNOWN_COMPONENT_CLASS_NAME, SeamPreferences.UNKNOWN_COMPONENT_CLASS_NAME, new String[]{className}, location, declaration.getResource());
                            } else {
                                this.addError(SeamValidationMessages.UNKNOWN_COMPONENT_CLASS_NAME, SeamPreferences.UNKNOWN_COMPONENT_CLASS_NAME_GUESS, new String[]{className}, location, declaration.getResource());
                            }
                        } else if (!type.isBinary()) {
                            this.validationContext.addLinkedCoreResource(SHORT_ID, componentName, type.getResource().getFullPath(), true);
                        }
                    }
                    catch (JavaModelException e) {
                        SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_CORE_VALIDATOR_ERROR_VALIDATING_SEAM_CORE, e);
                    }
                }
                Collection<ISeamProperty> properties = declaration.getProperties();
                for (ISeamProperty property : properties) {
                    boolean ok;
                    IMember member;
                    if (SeamUtil.isJar(property)) {
                        return;
                    }
                    String name = property.getName();
                    if (name == null) {
                        return;
                    }
                    if (type == null && component.getJavaDeclaration() != null && (member = component.getJavaDeclaration().getSourceMember()) instanceof IType) {
                        type = (IType)member;
                    }
                    if (type == null) continue;
                    boolean bl = ok = type.isBinary() || SeamUtil.findProperty(type, name) != null;
                    if (ok) continue;
                    this.addError(SeamValidationMessages.UNKNOWN_COMPONENT_PROPERTY, SeamPreferences.UNKNOWN_COMPONENT_PROPERTY, new String[]{type.getElementName(), componentName, name}, property, declaration.getResource(), 14);
                }
            }
        }
    }

    private void validateEntityComponent(ISeamComponent component) {
        if (component.isEntity()) {
            ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
            ScopeType scope = component.getScope();
            if (scope == ScopeType.STATELESS) {
                ITextSourceReference location = this.getScopeLocation(component);
                this.addError(SeamValidationMessages.ENTITY_COMPONENT_WRONG_SCOPE, SeamPreferences.ENTITY_COMPONENT_WRONG_SCOPE, new String[]{component.getName()}, location, javaDeclaration.getResource(), 13);
            }
        }
    }

    private ITextSourceReference getScopeLocation(ISeamComponent component) {
        ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
        ITextSourceReference location = ((SeamComponentDeclaration)((Object)javaDeclaration)).getLocationFor("scope");
        if (SeamUtil.isEmptyLocation(location)) {
            location = this.getNameLocation(javaDeclaration);
        }
        return location;
    }

    private IJavaSourceReference getNameLocation(IJavaSourceReference source) {
        int length = 0;
        int offset = 0;
        try {
            length = source.getSourceMember().getNameRange().getLength();
            offset = source.getSourceMember().getNameRange().getOffset();
        }
        catch (JavaModelException e) {
            SeamCorePlugin.getDefault().logError(SeamCoreMessages.SEAM_CORE_VALIDATOR_ERROR_VALIDATING_SEAM_CORE, e);
        }
        return new SeamTextSourceReference(source.getSourceMember(), length, offset, source.getResource());
    }

    private void validateStatefulComponent(ISeamComponent component) {
        if (component.isStateful()) {
            ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
            this.validateStatefulComponentMethods(SeamComponentMethodType.DESTROY, component, SeamValidationMessages.STATEFUL_COMPONENT_DOES_NOT_CONTAIN_DESTROY, SeamPreferences.STATEFUL_COMPONENT_DOES_NOT_CONTENT_DESTROY, 11);
            this.validateStatefulComponentMethods(SeamComponentMethodType.REMOVE, component, SeamValidationMessages.STATEFUL_COMPONENT_DOES_NOT_CONTAIN_REMOVE, SeamPreferences.STATEFUL_COMPONENT_DOES_NOT_CONTENT_REMOVE, 10);
            ScopeType scope = component.getScope();
            if (scope == ScopeType.PAGE || scope == ScopeType.STATELESS) {
                ITextSourceReference location = this.getScopeLocation(component);
                this.addError(SeamValidationMessages.STATEFUL_COMPONENT_WRONG_SCOPE, SeamPreferences.STATEFUL_COMPONENT_WRONG_SCOPE, new String[]{component.getName()}, location, javaDeclaration.getResource(), 12);
            }
            this.validateDuplicateComponentMethod(SeamComponentMethodType.REMOVE, component, SeamValidationMessages.DUPLICATE_REMOVE, SeamPreferences.DUPLICATE_REMOVE, 2);
        }
    }

    private void validateStatefulComponentMethods(SeamComponentMethodType methodType, ISeamComponent component, String message, String preferenceKey, int id) {
        ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
        IJavaSourceReference classNameLocation = this.getNameLocation(javaDeclaration);
        Set<ISeamComponentMethod> methods = javaDeclaration.getMethodsByType(methodType);
        if (methods == null || methods.isEmpty()) {
            this.addError(message, preferenceKey, new String[]{component.getName()}, (ITextSourceReference)classNameLocation, javaDeclaration.getResource(), id);
        }
    }

    private void validateDuplicateComponentMethods(ISeamComponent component) {
        this.validateDuplicateComponentMethod(SeamComponentMethodType.DESTROY, component, SeamValidationMessages.DUPLICATE_DESTROY, SeamPreferences.DUPLICATE_DESTROY, 3);
        this.validateDuplicateComponentMethod(SeamComponentMethodType.CREATE, component, SeamValidationMessages.DUPLICATE_CREATE, SeamPreferences.DUPLICATE_CREATE, 4);
        this.validateDuplicateComponentMethod(SeamComponentMethodType.UNWRAP, component, SeamValidationMessages.DUPLICATE_UNWRAP, SeamPreferences.DUPLICATE_UNWRAP, 5);
    }

    private void validateDuplicateComponentMethod(SeamComponentMethodType methodType, ISeamComponent component, String message, String preferenceKey, int message_id) {
        ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
        Set<ISeamComponentMethod> methods = javaDeclaration.getMethodsByType(methodType);
        if (methods != null && methods.size() > 1) {
            for (ISeamComponentMethod method : methods) {
                if (!javaDeclaration.getSourcePath().equals((Object)method.getSourcePath())) continue;
                IMethod javaMethod = (IMethod)method.getSourceMember();
                String methodName = javaMethod.getElementName();
                IJavaSourceReference methodNameLocation = this.getNameLocation(method);
                this.addError(message, preferenceKey, new String[]{methodName}, (ITextSourceReference)methodNameLocation, javaDeclaration.getResource(), message_id);
            }
        }
    }

    private void validateJavaDeclaration(ISeamComponent component, ISeamJavaComponentDeclaration declaration) {
        this.validateBijections(declaration);
        this.validateStatefulComponent(component);
        this.validateDuplicateComponentMethods(component);
        this.validateEntityComponent(component);
        this.validateDestroyMethod(component);
    }

    private void validateBijections(ISeamJavaComponentDeclaration declaration) {
        Set<IBijectedAttribute> bijections = declaration.getBijectedAttributes();
        if (bijections == null) {
            return;
        }
        for (IBijectedAttribute bijection : bijections) {
            if (bijection.isOfType(BijectedAttributeType.DATA_MODEL_SELECTION) || bijection.isOfType(BijectedAttributeType.DATA_MODEL_SELECTION_INDEX)) {
                this.validateDataModelSelection(declaration, bijection);
                continue;
            }
            this.validateInAndOut(declaration, bijection);
        }
    }

    private void validateInAndOut(ISeamJavaComponentDeclaration declaration, IBijectedAttribute bijection) {
        String name = bijection.getName();
        if (name == null || name.startsWith("#{") || name.startsWith("${")) {
            return;
        }
        if (bijection.isOfType(BijectedAttributeType.IN)) {
            ISeamProject parentProject;
            this.validationContext.addLinkedCoreResource(SHORT_ID, name, declaration.getSourcePath(), false);
            Set<ISeamContextVariable> variables = declaration.getVariablesByName(name);
            if (variables == null || variables.isEmpty()) {
                variables = this.seamProject.getVariablesByName(name);
            }
            if ((variables == null || variables.isEmpty()) && (parentProject = this.seamProject.getParentProject()) != null) {
                variables = parentProject.getVariablesByName(name);
            }
            if (variables == null || variables.size() < 1) {
                IResource declarationResource = declaration.getResource();
                IJavaSourceReference nameRef = this.getNameLocation(bijection);
                if (nameRef == null) {
                    nameRef = bijection;
                }
                this.addError(SeamValidationMessages.UNKNOWN_VARIABLE_NAME, SeamPreferences.UNKNOWN_VARIABLE_NAME, new String[]{name}, (ITextSourceReference)nameRef, declarationResource);
            }
        } else {
            this.validationContext.addLinkedCoreResource(SHORT_ID, name, declaration.getSourcePath(), true);
        }
    }

    private void validateDataModelSelection(ISeamJavaComponentDeclaration declaration, IBijectedAttribute bijection) {
        String dataModelName = bijection.getValue();
        String selectionName = bijection.getName();
        this.validationContext.addLinkedCoreResource(SHORT_ID, selectionName, declaration.getSourcePath(), false);
        if (dataModelName == null) {
            Set<IBijectedAttribute> dataBinders = declaration.getBijectedAttributesByType(BijectedAttributeType.DATA_BINDER);
            ITextSourceReference location = null;
            if (dataBinders != null && dataBinders.size() > 1) {
                for (IBijectedAttribute dataBinder : dataBinders) {
                    location = dataBinder.getLocationFor("name");
                    this.addError(SeamValidationMessages.MULTIPLE_DATA_BINDER, SeamPreferences.MULTIPLE_DATA_BINDER, location, declaration.getResource());
                }
            }
        } else {
            this.validationContext.addLinkedCoreResource(SHORT_ID, dataModelName, declaration.getSourcePath(), true);
            Set<IBijectedAttribute> dataBinders = declaration.getBijectedAttributesByName(dataModelName);
            if (dataBinders != null) {
                for (IBijectedAttribute dataBinder : dataBinders) {
                    if (!dataBinder.isOfType(BijectedAttributeType.DATA_BINDER) && !dataBinder.isOfType(BijectedAttributeType.OUT)) continue;
                    return;
                }
            }
            this.addError(SeamValidationMessages.UNKNOWN_DATA_MODEL, SeamPreferences.UNKNOWN_DATA_MODEL, new String[]{dataModelName}, SeamUtil.getLocationOfAttribute(bijection, DataModelSelectionAttribute.VALUE), declaration.getResource());
        }
    }

    private void validateMethodsOfUnknownComponent(ISeamJavaComponentDeclaration declaration) {
        if (this.seamProject.getComponentsByPath(declaration.getSourcePath()).isEmpty()) {
            IMember member = declaration.getSourceMember();
            try {
                if (member != null && !Flags.isAbstract((int)member.getFlags())) {
                    this.validateMethodOfUnknownComponent(SeamComponentMethodType.CREATE, declaration, SeamValidationMessages.CREATE_DOESNT_BELONG_TO_COMPONENT, SeamPreferences.CREATE_DOESNT_BELONG_TO_COMPONENT, 7);
                    this.validateMethodOfUnknownComponent(SeamComponentMethodType.UNWRAP, declaration, SeamValidationMessages.UNWRAP_DOESNT_BELONG_TO_COMPONENT, SeamPreferences.UNWRAP_DOESNT_BELONG_TO_COMPONENT, 8);
                    this.validateMethodOfUnknownComponent(SeamComponentMethodType.OBSERVER, declaration, SeamValidationMessages.OBSERVER_DOESNT_BELONG_TO_COMPONENT, SeamPreferences.OBSERVER_DOESNT_BELONG_TO_COMPONENT, 9);
                }
            }
            catch (JavaModelException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        this.validationContext.removeUnnamedCoreResource(SHORT_ID, declaration.getSourcePath());
    }

    private void validateDestroyMethod(ISeamComponent component) {
        if (component.isStateless()) {
            ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
            Set<ISeamComponentMethod> methods = javaDeclaration.getMethodsByType(SeamComponentMethodType.DESTROY);
            if (methods == null) {
                return;
            }
            for (ISeamComponentMethod method : methods) {
                IMethod javaMethod = (IMethod)method.getSourceMember();
                String methodName = javaMethod.getElementName();
                if (!javaDeclaration.getSourcePath().equals((Object)javaMethod.getPath())) continue;
                this.validationContext.addLinkedCoreResource(SHORT_ID, component.getName(), javaDeclaration.getSourcePath(), true);
                IJavaSourceReference methodNameLocation = this.getNameLocation(method);
                this.addError(SeamValidationMessages.DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN, SeamPreferences.DESTROY_METHOD_BELONGS_TO_STATELESS_SESSION_BEAN, new String[]{methodName}, (ITextSourceReference)methodNameLocation, method.getResource(), 6);
            }
        }
    }

    private void validateMethodOfUnknownComponent(SeamComponentMethodType methodType, ISeamJavaComponentDeclaration declaration, String message, String preferenceKey, int message_id) {
        Set<ISeamComponentMethod> methods = declaration.getMethodsByType(methodType);
        if (methods != null && !methods.isEmpty()) {
            for (ISeamComponentMethod method : methods) {
                IMethod javaMethod = (IMethod)method.getSourceMember();
                String methodName = javaMethod.getElementName();
                if (!declaration.getSourcePath().equals((Object)javaMethod.getPath())) continue;
                IJavaSourceReference methodNameLocation = this.getNameLocation(method);
                this.addError(message, preferenceKey, new String[]{methodName}, (ITextSourceReference)methodNameLocation, method.getResource(), message_id);
                this.validationContext.addUnnamedCoreResource(SHORT_ID, declaration.getSourcePath());
            }
        } else {
            this.validationContext.removeUnnamedCoreResource(SHORT_ID, declaration.getSourcePath());
        }
    }

    private void validateXMLVersion(IFile file) {
        String ext = file.getFileExtension();
        if (!"xml".equals(ext)) {
            return;
        }
        XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)file);
        if (o == null) {
            return;
        }
        if (!o.getModelEntity().getName().startsWith("FileSeamComponent")) {
            return;
        }
        Set<String> vs = this.getXMLVersions(o);
        SeamRuntime runtime = this.seamProject.getRuntime();
        if (runtime == null) {
            return;
        }
        String version = runtime.getVersion().toString();
        String wrongVersion = null;
        for (String v : vs) {
            if (v.startsWith(version)) continue;
            wrongVersion = v;
            break;
        }
        if (wrongVersion != null) {
            this.addError(SeamValidationMessages.INVALID_XML_VERSION, SeamPreferences.INVALID_XML_VERSION, new String[]{wrongVersion, version}, (IResource)file);
        }
    }

    private Set<String> getXMLVersions(XModelObject o) {
        HashSet<String> result = new HashSet<String>();
        if (o.getModelEntity().getName().endsWith("11")) {
            result.add("1.1");
            return result;
        }
        String sl = o.getAttributeValue("xsi:schemaLocation");
        int i = 0;
        while (i >= 0 && i < sl.length()) {
            int k;
            int j = sl.indexOf(45, i);
            if (j < 0 || (k = sl.indexOf(".xsd", j)) < 0) break;
            String v = sl.substring(j + 1, k);
            if (this.isVersion(v)) {
                result.add(v);
            }
            i = k;
        }
        return result;
    }

    private boolean isVersion(String s) {
        if (s.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != '.' && !Character.isDigit(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void validatePageXML(IFile f) {
        if (f.isAccessible() && (f.getName().equals("pages.xml") || f.getName().endsWith(".page.xml"))) {
            XModelObject object = EclipseResourceUtil.createObjectForResource((IResource)f);
            if (object == null) {
                return;
            }
            if (object.getModelEntity().getName().startsWith("FileSeamPage")) {
                this.validatePageViewIds(object, f);
            }
        }
    }

    private void validatePageViewIds(XModelObject o, IFile f) {
        String entity = o.getModelEntity().getName();
        this.validatePageViewId(o, f);
        if (!entity.startsWith("SeamPageRedirect") && !entity.startsWith("SeamPageRender")) {
            XModelObject[] cs;
            XModelObject[] xModelObjectArray = cs = o.getChildren();
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject c = xModelObjectArray[n2];
                this.validatePageViewIds(c, f);
                ++n2;
            }
        }
    }

    private void validatePageViewId(XModelObject object, IFile f) {
        this.validatePageViewId(object, f, "view id");
        this.validatePageViewId(object, f, ATTR_NO_CONVERSATION_VIEW_ID);
        this.validatePageViewId(object, f, ATTR_LOGIN_VIEW_ID);
    }

    private void validatePageViewId(XModelObject object, IFile f, String attr) {
        XModelObject target;
        if (object.getModelEntity().getAttribute(attr) == null) {
            return;
        }
        String path = object.getAttributeValue(attr);
        if (path == null || path.length() == 0 || path.indexOf(42) >= 0) {
            return;
        }
        if ((path = path.replace('\\', '/')).indexOf(63) >= 0) {
            path = path.substring(0, path.indexOf(63));
        }
        if ((target = object.getModel().getByPath(path)) == null) {
            XMLValueInfo i = new XMLValueInfo(object, attr);
            this.addError(NLS.bind((String)SeamValidationMessages.UNRESOLVED_VIEW_ID, (Object)path), SeamPreferences.UNRESOLVED_VIEW_ID, (ITextSourceReference)i, (IResource)f);
        }
    }

    public IMarker addError(String message, String preferenceKey, String[] messageArguments, ITextSourceReference location, IResource target, int messageId) {
        IMarker marker = this.addError(message, preferenceKey, messageArguments, location, target);
        try {
            if (marker != null) {
                marker.setAttribute("Message_id", (Object)new Integer(messageId));
            }
        }
        catch (CoreException ex) {
            SeamCorePlugin.getDefault().logError(ex);
        }
        return marker;
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new SeamPreferenceInfo());
    }

    class SeamPreferenceInfo
    implements IPreferenceInfo {
        SeamPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return "org.jboss.tools.seam.ui.preferences.SeamValidatorPreferencePage";
        }

        public String getPropertyPageId() {
            return "org.jboss.tools.seam.ui.propertyPages.SeamValidatorPreferencePage";
        }

        public String getPluginId() {
            return "org.jboss.tools.seam.core";
        }
    }
}

