/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.jboss.tools.seam.core.SeamCorePlugin;

public class WtpUtils {
    public static IProject createEclipseProject(String projectName, IProgressMonitor monitor) {
        IProject newProjectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(projectName);
        ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toString();
        try {
            newProjectHandle.create(description, (IProgressMonitor)new NullProgressMonitor());
            newProjectHandle.open(monitor);
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return newProjectHandle;
    }

    public static IProject createEarProject(String projectName, IProgressMonitor monitor) {
        IProject earProject = WtpUtils.createEclipseProject(projectName, monitor);
        return earProject;
    }

    public static IProject createDefaultEjbProject(String projectName, IProgressMonitor monitor) {
        IProject ejbProject = WtpUtils.createEclipseProject(projectName, monitor);
        WtpUtils.addJavaNature(ejbProject, (IPath)new Path("build/classes"), (IPath)new Path("ejbModule"), monitor);
        return ejbProject;
    }

    public static void addJavaNature(IProject project, IPath outputLocation, IPath srcLocation, IProgressMonitor monitor) {
        try {
            IProjectDescription newDescr = project.getDescription();
            newDescr.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            ICommand builderCmd = project.getDescription().newCommand();
            builderCmd.setBuilderName("org.eclipse.jdt.core.javabuilder");
            newDescr.setBuildSpec(new ICommand[]{builderCmd});
            project.setDescription(newDescr, monitor);
            IJavaProject newJavaPr = JavaCore.create((IProject)project);
            project.getFolder(outputLocation).create(1, true, monitor);
            project.getFolder(srcLocation).create(1, true, monitor);
            newJavaPr.setRawClasspath(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)Path.ROOT.append(srcLocation)), JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER))}, monitor);
            newJavaPr.setOutputLocation(outputLocation, monitor);
            newJavaPr.save(monitor, true);
        }
        catch (JavaModelException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static String getServerRuntimeName(IProject project) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IRuntime rt = facetedProject.getPrimaryRuntime();
            if (rt != null) {
                return rt.getName();
            }
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IResource createSourceFolder(IProject project, IPath path, IPath exclude, IPath outputFolder) {
        if (project == null || !project.exists()) {
            return null;
        }
        if (!project.isOpen()) {
            return null;
        }
        try {
            IFolder newSourceFolder;
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return null;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] javaProjectEntries = javaProject.getRawClasspath();
            IPath outputLocation = javaProject.getOutputLocation();
            IPath projPath = javaProject.getProject().getFullPath();
            IPath newSourceFolderPath = projPath.append(path);
            IPath excludeSourceFolderPath = projPath.append(exclude);
            ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(javaProjectEntries.length + 1);
            int projectEntryIndex = -1;
            int i = 0;
            while (true) {
                block22: {
                    IClasspathEntry curr;
                    block23: {
                        if (i >= javaProjectEntries.length) {
                            if (outputFolder != null) {
                                CoreUtility.createDerivedFolder((IFolder)project.getFolder(outputFolder), (boolean)true, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            if ((newSourceFolder = javaProject.getProject().getFolder(path)).exists()) break;
                            CoreUtility.createFolder((IFolder)newSourceFolder, (boolean)true, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        curr = javaProjectEntries[i];
                        IClasspathEntry resolved = curr;
                        if (resolved.getEntryKind() == 4) {
                            try {
                                resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)resolved);
                            }
                            catch (AssertionFailedException assertionFailedException) {
                                break block22;
                            }
                        }
                        if (resolved.getEntryKind() != 3) break block23;
                        if (newSourceFolderPath.equals((Object)resolved.getPath())) {
                            return null;
                        }
                        if (projPath.equals((Object)resolved.getPath())) {
                            projectEntryIndex = i;
                        }
                        if (excludeSourceFolderPath.equals((Object)resolved.getPath())) break block22;
                    }
                    newEntries.add(curr);
                }
                ++i;
            }
            IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)newSourceFolderPath, (IPath[])new Path[]{}, (IPath[])new Path[]{}, outputFolder != null ? project.getFullPath().append(outputFolder) : null);
            if (projectEntryIndex != -1) {
                newEntries.set(projectEntryIndex, newEntry);
            } else {
                WtpUtils.insertClasspathEntry(newEntry, newEntries);
            }
            IClasspathEntry[] newClasspathEntries = newEntries.toArray(new IClasspathEntry[newEntries.size()]);
            IPath newOutputLocation = outputLocation;
            IJavaModelStatus result = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])newClasspathEntries, (IPath)newOutputLocation);
            if (!result.isOK()) {
                if (!outputLocation.equals((Object)projPath)) {
                    return null;
                }
                newOutputLocation = projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                result = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])newClasspathEntries, (IPath)newOutputLocation);
                if (!result.isOK()) {
                    return null;
                }
            }
            javaProject.setRawClasspath(newClasspathEntries, newOutputLocation, (IProgressMonitor)new NullProgressMonitor());
            return newSourceFolder;
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    private static void insertClasspathEntry(IClasspathEntry entry, List<IClasspathEntry> entries) {
        int length = entries.size();
        IClasspathEntry[] elements = entries.toArray(new IClasspathEntry[length]);
        int i = 0;
        while (i < length && elements[i].getEntryKind() != entry.getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getEntryKind() == entry.getEntryKind()) {
                ++i;
            }
            entries.add(i, entry);
            return;
        }
        switch (entry.getEntryKind()) {
            case 3: {
                entries.add(0, entry);
                break;
            }
            default: {
                entries.add(entry);
            }
        }
    }

    public static void setClasspathEntryAsExported(IProject project, IPath path, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject jProject = JavaCore.create((IProject)project);
        IClasspathEntry[] cps = jProject.getRawClasspath();
        int i = 0;
        while (i < cps.length) {
            if (cps[i].getEntryKind() == 5 && cps[i].getPath().equals((Object)path)) {
                cps[i] = JavaCore.newContainerEntry((IPath)cps[i].getPath(), (boolean)true);
            }
            ++i;
        }
        jProject.setRawClasspath(cps, monitor);
    }

    public static void reconfigure(IProject project, IProgressMonitor monitor) throws CoreException {
        Object object;
        if (!(project != null && project.exists() && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature"))) {
            return;
        }
        project.refreshLocal(2, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null && javaProject.exists() && javaProject.isOpen() && javaProject instanceof JavaProject && (object = ((JavaProject)javaProject).getElementInfo()) instanceof OpenableElementInfo) {
            OpenableElementInfo info = (OpenableElementInfo)object;
            IClasspathEntry[] resolvedClasspath = ((JavaProject)javaProject).getResolvedClasspath();
            IPackageFragmentRoot[] children = ((JavaProject)javaProject).computePackageFragmentRoots(resolvedClasspath, false, null);
            info.setChildren((IJavaElement[])children);
            ((JavaProject)javaProject).getPerProjectInfo().rememberExternalLibTimestamps();
        }
    }
}

