/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.kb.internal.KbBuilder;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentDeclaration;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreBuilder;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.internal.core.AbstractContextVariable;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;

public class SeamUtil {
    private static final String SEAM_JAR_NAME = "jboss-seam.jar";
    private static final String SEAM_VERSION_ATTRIBUTE_NAME = "Seam-Version";
    private static final String IMPLEMENTATION_VERSION_ATTRIBUTE_NAME = "Implementation-Version";

    public static void enableSeamSupport(IProject project) {
        if (project == null) {
            return;
        }
        try {
            WebModelPlugin.addNatureToProjectWithValidationSupport((IProject)project, (String)KbBuilder.BUILDER_ID, (String)"org.jboss.tools.jst.web.kb.kbnature");
            WebModelPlugin.addNatureToProjectWithValidationSupport((IProject)project, (String)SeamCoreBuilder.BUILDER_ID, (String)"org.jboss.tools.seam.core.seamnature");
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public static String getSeamVersionFromManifest(IProject project) {
        ISeamProject seamProject = SeamCorePlugin.getSeamProject(project, false);
        if (seamProject == null) {
            SeamCorePlugin.getPluginLog().logWarning("Can't find Seam Project for " + project.getName());
            return null;
        }
        return SeamUtil.getSeamVersionFromManifest(seamProject);
    }

    public static String getSeamVersionFromManifest(ISeamProject project) {
        SeamRuntime runtime = project.getRuntime();
        if (runtime == null) {
            SeamCorePlugin.getPluginLog().logWarning("Seam Runtime for " + project.getProject().getName() + " is null.");
            return null;
        }
        return SeamUtil.getSeamVersionFromManifest(runtime);
    }

    public static String getSeamVersionFromManifest(SeamRuntime runtime) {
        return SeamUtil.getSeamVersionFromManifest(runtime.getHomeDir());
    }

    public static String getSeamVersionFromManifest(String seamHome, int depth) {
        return SeamUtil.trimSeamVersion(SeamUtil.getSeamVersionFromManifest(seamHome), depth);
    }

    public static boolean areSeamVersionsMatched(String version1, String version2) {
        String longerVersion = version1.length() > version2.length() ? version1 : version2;
        String shorterVersion = longerVersion == version1 ? version2 : version1;
        StringTokenizer sSt = new StringTokenizer(shorterVersion, ".", false);
        StringTokenizer lSt = new StringTokenizer(longerVersion, ".", false);
        while (sSt.hasMoreElements() && lSt.hasMoreElements()) {
            if (sSt.nextToken().equals(lSt.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static String getSeamVersionFromManifest(String seamHome) {
        File jarFile = new File(seamHome, "lib/jboss-seam.jar");
        if (!jarFile.isFile() && !(jarFile = new File(seamHome, SEAM_JAR_NAME)).isFile()) {
            return null;
        }
        try {
            JarFile jar = new JarFile(jarFile);
            Attributes attributes = jar.getManifest().getMainAttributes();
            String version = attributes.getValue(SEAM_VERSION_ATTRIBUTE_NAME);
            if (version == null) {
                SeamCorePlugin.getPluginLog().logWarning("Can't get Seam-Version from " + jar.getName() + " MANIFEST.");
                version = attributes.getValue(IMPLEMENTATION_VERSION_ATTRIBUTE_NAME);
                if (version == null) {
                    SeamCorePlugin.getPluginLog().logWarning("Can't get Implementation-Version from " + jar.getName() + " MANIFEST.");
                }
            }
            return version;
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    public static String trimSeamVersion(String fullSeamVersion, int depth) {
        if (fullSeamVersion == null || depth < 1) {
            return fullSeamVersion;
        }
        StringBuffer version = new StringBuffer();
        StringTokenizer st = new StringTokenizer(fullSeamVersion, ".", false);
        while (st.hasMoreElements() && depth > 0) {
            version.append(st.nextToken());
            if (!st.hasMoreElements() || --depth <= 0) continue;
            version.append('.');
        }
        return version.toString();
    }

    public static String getSeamPackageName(String projectName) {
        if (projectName == null) {
            return null;
        }
        String packageName = projectName.toLowerCase();
        if (packageName.indexOf(" ") >= 0) {
            packageName = packageName.replace(" ", "");
        }
        if (packageName.indexOf("-") >= 0) {
            packageName = packageName.replace("-", "");
        }
        if (packageName.indexOf("+") >= 0) {
            packageName = packageName.replace("+", "");
        }
        if (packageName.indexOf("_") >= 0) {
            packageName = packageName.replace("_", "");
        }
        while (packageName.indexOf("..") >= 0) {
            packageName = packageName.replace("..", ".");
        }
        return packageName;
    }

    public static ISeamProject findReferencingSeamWarProjectForProject(IProject project) {
        return SeamUtil.findReferencingSeamWarProjectForProject(project, true);
    }

    public static ISeamProject findReferencingSeamWarProjectForProject(IProject project, boolean searchInEARs) {
        ISeamProject seamProject;
        IProject[] referencing = J2EEProjectUtilities.getReferencingWebProjects((IProject)project);
        int i = 0;
        while (i < referencing.length) {
            seamProject = SeamCorePlugin.getSeamProject(referencing[i], false);
            if (seamProject != null) {
                return seamProject;
            }
            ++i;
        }
        if (searchInEARs) {
            referencing = EarUtilities.getReferencingEARProjects((IProject)project);
            i = 0;
            while (i < referencing.length) {
                seamProject = SeamUtil.findReferencingSeamWarProjectForProject(referencing[i], false);
                if (seamProject != null) {
                    return seamProject;
                }
                ++i;
            }
            IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] refComponents = null;
            if (comp != null) {
                IVirtualReference[] iVirtualReferenceArray = refComponents = comp.getReferences();
                int n = refComponents.length;
                int n2 = 0;
                while (n2 < n) {
                    ISeamProject seamProject2;
                    IVirtualReference virtualReference = iVirtualReferenceArray[n2];
                    IVirtualComponent component = virtualReference.getReferencedComponent();
                    if (component != null && !component.isBinary() && WebUtilities.isDynamicWebComponent((IVirtualComponent)component) && (seamProject2 = SeamCorePlugin.getSeamProject(component.getProject(), false)) != null) {
                        return seamProject2;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public static IResource getComponentResourceWithName(ISeamElement element) {
        if (element instanceof ISeamComponent) {
            Set<ISeamComponentDeclaration> declarations = ((ISeamComponent)element).getAllDeclarations();
            for (ISeamComponentDeclaration o : declarations) {
                SeamComponentDeclaration d = (SeamComponentDeclaration)o;
                ITextSourceReference location = d.getLocationFor("name");
                if (SeamUtil.isEmptyLocation(location)) continue;
                return d.getResource();
            }
        }
        return element.getResource();
    }

    public static ITextSourceReference getLocationOfName(ISeamElement element) {
        return SeamUtil.getLocationOfAttribute(element, "name");
    }

    public static ITextSourceReference getLocationOfAttribute(ISeamElement element, String attributeName) {
        ITextSourceReference location = null;
        if (element instanceof AbstractContextVariable) {
            location = ((AbstractContextVariable)element).getLocationFor(attributeName);
        } else if (element instanceof ISeamComponent) {
            Set<ISeamComponentDeclaration> declarations = ((ISeamComponent)element).getAllDeclarations();
            for (ISeamComponentDeclaration d : declarations) {
                location = ((SeamComponentDeclaration)d).getLocationFor(attributeName);
                if (SeamUtil.isEmptyLocation(location)) {
                    continue;
                }
                break;
            }
        } else if (element instanceof SeamComponentDeclaration) {
            location = ((SeamComponentDeclaration)element).getLocationFor(attributeName);
        }
        if (SeamUtil.isEmptyLocation(location) && element instanceof ITextSourceReference) {
            location = (ITextSourceReference)element;
        }
        return location;
    }

    public static boolean isEmptyLocation(ITextSourceReference location) {
        return location == null || location.getStartPosition() == 0 && location.getLength() == 0;
    }

    public static boolean isJar(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException(SeamCoreMessages.SEAM_VALIDATION_HELPER_RESOURCE_MUST_NOT_BE_NULL);
        }
        String ext = path.getFileExtension();
        return ext != null && ext.equalsIgnoreCase("jar");
    }

    public static boolean isJar(ISeamElement element) {
        return SeamUtil.isJar(element.getSourcePath());
    }

    public static IType getClassTypeForComponentXml(IFile componentXmlFile, IProject rootProject) {
        String className = SeamUtil.getClassNameForComponentXml(componentXmlFile, rootProject);
        if (className == null) {
            return null;
        }
        return SeamUtil.findType(className, rootProject);
    }

    public static IType findType(String fullyQualifiedName, IProject rootProject) {
        try {
            IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)rootProject);
            return jp.findType(fullyQualifiedName);
        }
        catch (JavaModelException e) {
            SeamCorePlugin.getDefault().logError(e);
            return null;
        }
    }

    public static String getClassNameForComponentXml(IFile componentXmlFile, IProject rootProject) {
        IPackageFragment packageFragment;
        String className;
        block4: {
            String fileName = componentXmlFile.getName();
            int firstDot = fileName.indexOf(46);
            if (firstDot == -1) {
                return null;
            }
            className = fileName.substring(0, firstDot);
            try {
                IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)rootProject);
                packageFragment = jp.findPackageFragment(componentXmlFile.getFullPath().removeLastSegments(1));
                if (packageFragment != null) break block4;
                return null;
            }
            catch (JavaModelException e) {
                SeamCorePlugin.getDefault().logError(e);
                return null;
            }
        }
        return String.valueOf(packageFragment.getElementName()) + "." + className;
    }

    public static IMember findProperty(IType type, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        try {
            return SeamUtil.findPropertyInHierarchy(type, propertyName);
        }
        catch (JavaModelException e) {
            SeamCorePlugin.getDefault().logError(e);
            return null;
        }
    }

    public static IMember findPropertyInHierarchy(IType type, String propertyName) throws JavaModelException {
        String[][] packages;
        String firstLetter = propertyName.substring(0, 1).toUpperCase();
        String nameWithoutFirstLetter = propertyName.substring(1);
        String setterName = "set" + firstLetter + nameWithoutFirstLetter;
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().equals(setterName) && methods[i].getParameterNames().length == 1) {
                return methods[i];
            }
            ++i;
        }
        IField[] fields = type.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            if (fields[i2].getElementName().equals(propertyName)) {
                return fields[i2];
            }
            ++i2;
        }
        String superclassName = type.getSuperclassName();
        if (superclassName != null && (packages = type.resolveType(superclassName)) != null) {
            int i3 = 0;
            while (i3 < packages.length) {
                IMember property;
                String packageName = packages[i3][0];
                packageName = packageName != null && packageName.length() > 0 ? String.valueOf(packageName) + "." : "";
                String qName = String.valueOf(packageName) + packages[i3][1];
                IType superclass = type.getJavaProject().findType(qName);
                if (superclass != null && (property = SeamUtil.findPropertyInHierarchy(superclass, propertyName)) != null) {
                    return property;
                }
                ++i3;
            }
        }
        return null;
    }
}

