/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor.ecore.pages.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Link;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.Page;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PageException;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesElement;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesFactory;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesModel;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesPackage;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.impl.PagesElementImpl;

public class PagesModelImpl
extends PagesElementImpl
implements PagesModel {
    SeamPagesDiagramStructureHelper h = SeamPagesDiagramStructureHelper.getInstance();
    Map<String, PagesElement> elementsByPath = null;
    Map<String, Link> linksByPath = null;
    XModelTreeListener modelListener = new ML();

    protected PagesModelImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PagesPackage.Literals.PAGES_MODEL;
    }

    @Override
    public PagesModel getPagesModel() {
        return this;
    }

    @Override
    public PagesElement findElement(Object data) {
        if (data instanceof XModelObject) {
            data = ((XModelObject)data).getPath();
        }
        if (data instanceof String) {
            PagesElement result = this.elementsByPath.get(data);
            return result;
        }
        return null;
    }

    @Override
    public void bindElement(Object data, PagesElement element) {
        element.setData(data);
        if (data instanceof XModelObject) {
            this.addElement((XModelObject)data, element);
        } else if (data != null) {
            this.elementsByPath.put(data.toString(), element);
        }
    }

    void addElement(XModelObject data, PagesElement element) {
        this.elementsByPath.put(data.getPath(), element);
    }

    @Override
    public Link findLink(Object data) {
        if (data instanceof XModelObject) {
            data = ((XModelObject)data).getPath();
        }
        if (data instanceof String) {
            Link result = this.linksByPath.get(data);
            return result;
        }
        return null;
    }

    @Override
    public void bindLink(Object data, Link link) {
        link.setData(data);
        if (data instanceof XModelObject) {
            this.linksByPath.put(((XModelObject)data).getPath(), link);
        } else if (data != null) {
            this.linksByPath.put(data.toString(), link);
        }
    }

    void unbind(String path) {
        String p;
        Iterator<String> it = this.elementsByPath.keySet().iterator();
        while (it.hasNext()) {
            p = it.next();
            if (!p.equals(path) && !p.startsWith(String.valueOf(path) + "/")) continue;
            it.remove();
        }
        it = this.linksByPath.keySet().iterator();
        while (it.hasNext()) {
            p = it.next();
            if (!p.equals(path) && !path.startsWith(String.valueOf(p) + "/")) continue;
            it.remove();
        }
    }

    @Override
    public void load() {
        XModelObject diagramXML = (XModelObject)this.getData();
        if (diagramXML == null) {
            return;
        }
        this.elementsByPath = new HashMap<String, PagesElement>();
        this.linksByPath = new HashMap<String, Link>();
        this.addElement(diagramXML, this);
        XModelObject[] is = this.h.getItems(diagramXML);
        int i = 0;
        while (i < is.length) {
            this.addItem(is[i]);
            ++i;
        }
        i = 0;
        while (i < is.length) {
            this.addItemLinks(is[i]);
            ++i;
        }
        diagramXML.getModel().removeModelTreeListener(this.modelListener);
        diagramXML.getModel().addModelTreeListener(this.modelListener);
    }

    @Override
    public void childAdded(Object childData) {
        if (childData instanceof XModelObject) {
            XModelObject added = (XModelObject)childData;
            this.addItem(added);
            this.addItemLinks(added);
        }
    }

    private void addItem(XModelObject item) {
        String type = item.getAttributeValue("type");
        if ("page".equals(type)) {
            Page page = PagesFactory.eINSTANCE.createPage();
            this.bindElement(item, page);
            page.dataChanged();
            this.getChildren().add((Object)page);
        } else if ("exception".equals(type)) {
            PageException exc = PagesFactory.eINSTANCE.createPageException();
            this.bindElement(item, exc);
            exc.dataChanged();
            this.getChildren().add((Object)exc);
        }
    }

    private void addItemLinks(XModelObject item) {
        String type = item.getAttributeValue("type");
        if ("page".equals(type) || "exception".equals(type)) {
            PagesElement from = this.findElement(item);
            if (from == null) {
                return;
            }
            XModelObject[] os = this.h.getOutputs(item);
            int j = 0;
            while (j < os.length) {
                from.childAdded(os[j]);
                ++j;
            }
        }
    }

    @Override
    public void dispose() {
        XModelObject diagramXML = (XModelObject)this.getData();
        if (diagramXML == null) {
            return;
        }
        diagramXML.getModel().removeModelTreeListener(this.modelListener);
    }

    class ML
    implements XModelTreeListener {
        ML() {
        }

        public void nodeChanged(final XModelTreeEvent event) {
            if (Display.getCurrent() != null) {
                this.nodeChangedInternal(event);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ML.this.nodeChangedInternal(event);
                    }
                });
            }
        }

        private void nodeChangedInternal(XModelTreeEvent event) {
            Link link;
            if (PagesModelImpl.this.getData() == null) {
                return;
            }
            XModelObject diagramXML = (XModelObject)PagesModelImpl.this.getData();
            String newPath = event.getModelObject().getPath();
            if (diagramXML.getPath() == null) {
                return;
            }
            if (!newPath.startsWith(diagramXML.getPath())) {
                return;
            }
            String oldPath = event.getInfo().toString();
            PagesElement item = PagesModelImpl.this.findElement(oldPath);
            if (item != null) {
                if (!oldPath.equals(newPath)) {
                    PagesModelImpl.this.elementsByPath.remove(oldPath);
                    PagesModelImpl.this.elementsByPath.put(newPath, item);
                    String[] keys = PagesModelImpl.this.linksByPath.keySet().toArray(new String[0]);
                    int i = 0;
                    while (i < keys.length) {
                        Link o;
                        if (keys[i].startsWith(String.valueOf(oldPath) + "/") && (o = PagesModelImpl.this.linksByPath.get(keys[i])) != null) {
                            String key = String.valueOf(newPath) + keys[i].substring(oldPath.length());
                            PagesModelImpl.this.linksByPath.put(key, o);
                        }
                        ++i;
                    }
                }
                item.dataChanged();
            }
            if ((link = PagesModelImpl.this.findLink(event.getInfo().toString())) != null) {
                link.dataChanged();
            }
        }

        public void structureChanged(final XModelTreeEvent event) {
            if (Display.getCurrent() != null) {
                this.structureChangedInternal(event);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ML.this.structureChangedInternal(event);
                    }
                });
            }
        }

        public void structureChangedInternal(XModelTreeEvent event) {
            if (PagesModelImpl.this.getData() == null) {
                return;
            }
            XModelObject diagramXML = (XModelObject)PagesModelImpl.this.getData();
            XModelObject target = event.getModelObject();
            if (diagramXML.getPath() == null) {
                return;
            }
            if (!target.getPath().startsWith(diagramXML.getPath())) {
                return;
            }
            if (event.kind() == 1) {
                XModelObject added = (XModelObject)event.getInfo();
                if (target == diagramXML) {
                    PagesModelImpl.this.childAdded(added);
                } else {
                    PagesElement item = PagesModelImpl.this.findElement(target);
                    item.childAdded(added);
                }
            } else if (event.kind() == 2) {
                Link removed;
                if (target == diagramXML) {
                    PagesElement removed2 = PagesModelImpl.this.findElement(event.getInfo());
                    if (removed2 != null) {
                        Link[] ls = (Link[])removed2.getOutputLinks().toArray((Object[])new Link[0]);
                        HashSet<Link> r = new HashSet<Link>();
                        int i = 0;
                        while (i < ls.length) {
                            ls[i].setFromElement(null);
                            ls[i].setToElement(null);
                            r.add(ls[i]);
                            ++i;
                        }
                        ls = (Link[])removed2.getInputLinks().toArray((Object[])new Link[0]);
                        i = 0;
                        while (i < ls.length) {
                            ls[i].setToElement(null);
                            ++i;
                        }
                        if (!r.isEmpty()) {
                            Iterator<Link> it = PagesModelImpl.this.linksByPath.values().iterator();
                            while (it.hasNext()) {
                                Link l = it.next();
                                if (!r.contains(l)) continue;
                                it.remove();
                            }
                        }
                        PagesModelImpl.this.getChildren().remove((Object)removed2);
                    }
                } else if (PagesModelImpl.this.findElement(target) != null && (removed = PagesModelImpl.this.findLink(event.getInfo())) != null) {
                    removed.setToElement(null);
                    removed.setFromElement(null);
                    PagesModelImpl.this.linksByPath.remove(event.getInfo());
                }
                PagesModelImpl.this.unbind(event.getInfo().toString());
            }
        }
    }
}

