/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.pages.editor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.gef.GEFConnectionCreationToolEntry;
import org.jboss.tools.common.gef.GEFEditor;
import org.jboss.tools.common.gef.action.DiagramAlignmentAction;
import org.jboss.tools.common.gef.action.IDiagramSelectionProvider;
import org.jboss.tools.common.gef.edit.GEFRootEditPart;
import org.jboss.tools.common.gef.editor.xpl.DefaultPaletteCustomizer;
import org.jboss.tools.common.gef.outline.xpl.DiagramContentOutlinePage;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.seam.pages.xml.model.SeamPagesPreference;
import org.jboss.tools.seam.pages.xml.model.handlers.SelectOnDiagramHandler;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;
import org.jboss.tools.seam.ui.pages.SeamUIPagesMessages;
import org.jboss.tools.seam.ui.pages.SeamUiPagesPlugin;
import org.jboss.tools.seam.ui.pages.editor.ExceptionTemplate;
import org.jboss.tools.seam.ui.pages.editor.PageTemplate;
import org.jboss.tools.seam.ui.pages.editor.PagesContextMenuProvider;
import org.jboss.tools.seam.ui.pages.editor.actions.PagesCopyAction;
import org.jboss.tools.seam.ui.pages.editor.actions.PagesCutAction;
import org.jboss.tools.seam.ui.pages.editor.actions.PagesDeleteAction;
import org.jboss.tools.seam.ui.pages.editor.actions.PagesPasteAction;
import org.jboss.tools.seam.ui.pages.editor.dnd.FileTransferDropTargetListener;
import org.jboss.tools.seam.ui.pages.editor.dnd.PagesTemplateTransferDropTargetListener;
import org.jboss.tools.seam.ui.pages.editor.dnd.XModelTransferDropTargetListener;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesElement;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesModel;
import org.jboss.tools.seam.ui.pages.editor.ecore.pages.PagesModelListener;
import org.jboss.tools.seam.ui.pages.editor.edit.GraphicalPartFactory;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesDiagramEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.PagesEditPart;
import org.jboss.tools.seam.ui.pages.editor.edit.SelectionUtil;
import org.jboss.tools.seam.ui.pages.editor.edit.xpl.PagesConnectionRouter;
import org.jboss.tools.seam.ui.pages.editor.figures.NodeFigure;
import org.jboss.tools.seam.ui.pages.editor.palette.PagesPaletteViewerPreferences;

public class PagesEditor
extends GEFEditor
implements PagesModelListener,
XModelTreeListener {
    private KeyHandler sharedKeyHandler;
    private PagesModel model;
    ScrollingGraphicalViewer viewer;
    private static GEFConnectionCreationToolEntry connectionCreationTool = null;
    public static String PRINT_DIAGRAM = "Print_Diagram";
    private static boolean switchToSelectionTool = SeamPagesPreference.ENABLE_CONTROL_MODE_ON_TRANSITION_COMPLETED.getValue().equals("yes");
    private ModelSelectionProvider modelSelectionProvider = new ModelSelectionProvider();

    protected void createPaletteViewer(Composite parent) {
        PaletteViewer viewer = new PaletteViewer();
        PagesPaletteViewerPreferences prefs = new PagesPaletteViewerPreferences(this);
        prefs.setUseLargeIcons(1, false);
        prefs.setUseLargeIcons(0, false);
        prefs.setUseLargeIcons(2, false);
        prefs.setUseLargeIcons(3, false);
        prefs.setLayoutSetting(0);
        viewer.createControl(parent);
        this.setPaletteViewer(viewer);
        this.setPaletteLayout((PaletteViewerPreferences)prefs, this.loadPaletteSize());
        this.paletteViewer.setPaletteViewerPreferences((PaletteViewerPreferences)prefs);
        this.configurePaletteViewer();
        this.hookPaletteViewer();
        this.initializePaletteViewer();
    }

    public PagesEditor(IEditorInput input) {
        super(input);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected void configurePaletteViewer() {
        PaletteViewer viewer = this.getPaletteViewer();
        PaletteContextMenuProvider provider = new PaletteContextMenuProvider(viewer);
        this.getPaletteViewer().setContextMenu((MenuManager)provider);
        viewer.setCustomizer((PaletteCustomizer)new DefaultPaletteCustomizer());
    }

    public ScrollingGraphicalViewer getScrollingGraphicalViewer() {
        return this.viewer;
    }

    protected void configureGraphicalViewer() {
        this.viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.modelSelectionProvider);
        GEFRootEditPart root = new GEFRootEditPart();
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        root.getZoomManager().setZoomLevels(new double[]{0.25, 0.5, 0.75, 1.0});
        root.getZoomManager().setZoom(this.loadZoomSize());
        root.getZoomManager().addZoomListener(new ZoomListener(){

            public void zoomChanged(double zoom) {
                PagesEditor.this.saveZoomSize(zoom);
            }
        });
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.registerAction((IAction)zoomIn);
        this.registerAction((IAction)zoomOut);
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory(this));
        PagesContextMenuProvider provider = new PagesContextMenuProvider((EditPartViewer)this.viewer, this.getActionRegistry());
        this.viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("JSFContextmenu", (MenuManager)provider, (ISelectionProvider)this.viewer);
        this.viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)this.viewer).setParent(this.getCommonKeyHandler()));
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        int cfr_ignored_0 = e.stateMask;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof PagesEditPart) {
            ((PagesEditPart)part).doMouseDown(new Point(e.x, e.y));
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public Control getControl() {
        return this.getPaletteViewer().getControl();
    }

    protected void createOutputStream(OutputStream os) throws IOException {
    }

    public void dispose() {
        PreferenceModelUtilities.getPreferenceModel().removeModelTreeListener((XModelTreeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class type) {
        if (type == IDiagramSelectionProvider.class) {
            if (this.getScrollingGraphicalViewer() == null) {
                return null;
            }
            return new IDiagramSelectionProvider(){

                public ISelection getSelection() {
                    if (PagesEditor.this.getScrollingGraphicalViewer() == null) {
                        return null;
                    }
                    return PagesEditor.this.getScrollingGraphicalViewer().getSelection();
                }
            };
        }
        if (type == CommandStackInspectorPage.class) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        if (type == IContentOutlinePage.class) {
            if (this.outline != null) {
                return this.outline;
            }
            this.outline = new DiagramContentOutlinePage((EditPartViewer)new TreeViewer());
            this.outline.setGraphicalViewer(this.getGraphicalViewer());
            this.outline.setSelectionSynchronizer(this.getSelectionSynchronizer());
            return this.outline;
        }
        if (type == ZoomManager.class && this.getGraphicalViewer() != null) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected int getInitialPaletteSize() {
        return 22;
    }

    protected void handlePaletteResized(int newSize) {
    }

    protected KeyHandler getCommonKeyHandler() {
        return this.sharedKeyHandler;
    }

    public PagesModel getPagesModel() {
        return this.model;
    }

    protected PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("control");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setDescription(SeamUIPagesMessages.PAGESDIAGRAM_SELECT);
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tool.setDescription(SeamUIPagesMessages.PAGESDIAGRAM_MARQUEE);
        entries.add(tool);
        PaletteSeparator sep = new PaletteSeparator("separator");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        connectionCreationTool = new GEFConnectionCreationToolEntry("New Link", "New Link", null, ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/transition.gif"), null){

            protected void dragFinished() {
                XModelTransferBuffer.getInstance().disable();
            }
        };
        connectionCreationTool.setUnloadWhenFinished(switchToSelectionTool);
        entries.add(connectionCreationTool);
        entries.add(sep);
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(SeamUIPagesMessages.PAGES_DIAGRAM_VIEW_TEMPLATE, SeamUIPagesMessages.PAGES_DIAGRAM_VIEW_TEMPLATE, (Object)"page template", (CreationFactory)new SimpleFactory(PageTemplate.class), ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/view.gif"), null);
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry(SeamUIPagesMessages.PAGES_DIAGRAM_EXCEPTION_TEMPLATE, SeamUIPagesMessages.PAGES_DIAGRAM_EXCEPTION_TEMPLATE, (Object)"exception template", (CreationFactory)new SimpleFactory(ExceptionTemplate.class), ImageDescriptor.createFromFile(PagesEditor.class, (String)"icons/exception.gif"), null);
        entries.add(combined);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.getPagesModel());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new XModelTransferDropTargetListener(this));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new FileTransferDropTargetListener(this));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new PagesTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        ((ConnectionLayer)((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Connection Layer")).setConnectionRouter((ConnectionRouter)new PagesConnectionRouter());
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)Boolean.TRUE);
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)Boolean.TRUE);
        this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(8, 8));
    }

    protected void initializePaletteViewer() {
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
        FigureCanvas canvas = (FigureCanvas)this.paletteViewer.getControl();
        this.makeUnwrapPaletteItems(canvas.getContents());
        canvas.getContents().revalidate();
        canvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        canvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer()));
    }

    protected void createActions() {
        this.register((IAction)new PagesDeleteAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new PagesCopyAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new PagesPasteAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new PagesCutAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 1), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 4), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 8), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 32), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 2), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 16), true, false);
    }

    private void register(IAction action, boolean isSelectionAction, boolean isKeyBindingAction) {
        ActionRegistry registry = this.getActionRegistry();
        registry.registerAction(action);
        if (isSelectionAction) {
            this.getSelectionActions().add(action.getId());
        }
        if (isKeyBindingAction) {
            this.getSite().getKeyBindingService().registerAction(action);
        }
    }

    private void registerAction(IAction action) {
        if (action == null) {
            return;
        }
        IHandlerService handler = (IHandlerService)this.getSite().getService(IHandlerService.class);
        String id = action.getId();
        handler.activateHandler(id, (IHandler)new ActionHandler(action));
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    protected boolean performSaveAs() {
        return false;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public void setInput(XModelObject input) {
    }

    public void setPagesModel(PagesModel diagram) {
        this.model = diagram;
        PreferenceModelUtilities.getPreferenceModel().addModelTreeListener((XModelTreeListener)this);
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected void superSetInput(IEditorInput input) {
        super.setInput(input);
    }

    public ISelectionProvider getModelSelectionProvider() {
        return this.modelSelectionProvider;
    }

    private XModelObject getTarget(ISelection ss) {
        if (ss.isEmpty() || !(ss instanceof StructuredSelection)) {
            return null;
        }
        return SelectionUtil.getTarget(((StructuredSelection)ss).getFirstElement());
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
    }

    public void nodeChanged(XModelTreeEvent event) {
        String path = event.getModelObject().getPath();
        if (path.equals(SeamPagesPreference.SEAM_PAGES_EDITOR_PATH)) {
            switchToSelectionTool = SeamPagesPreference.ENABLE_CONTROL_MODE_ON_TRANSITION_COMPLETED.getValue().equals("yes");
            connectionCreationTool.setUnloadWhenFinished(switchToSelectionTool);
        }
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    public class ModelSelectionProvider
    extends AbstractSelectionProvider
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            this.fireSelectionChanged();
            PagesEditor.this.updateActions(PagesEditor.this.getSelectionActions());
        }

        protected XModelObject getSelectedModelObject() {
            if (PagesEditor.this.viewer == null) {
                return null;
            }
            XModelObject o = PagesEditor.this.getTarget(PagesEditor.this.viewer.getSelection());
            if (!(o instanceof ReferenceObject)) {
                return o;
            }
            XModelObject ref = SeamPagesDiagramStructureHelper.instance.getReference(o);
            return ref;
        }

        public void scroll(FreeformViewport vp, NodeFigure figure) {
            int delta;
            int SCROLL_MARGIN = 20;
            Point origin = vp.getViewLocation();
            if (figure.getLocation().x - SCROLL_MARGIN < origin.x) {
                delta = origin.x - (figure.getLocation().x - SCROLL_MARGIN);
                origin.x -= delta;
            } else if (figure.getLocation().x + figure.getSize().width + SCROLL_MARGIN > origin.x + vp.getSize().width) {
                delta = figure.getLocation().x + figure.getSize().width + SCROLL_MARGIN - (origin.x + vp.getSize().width);
                origin.x += delta;
            }
            if (figure.getLocation().y - SCROLL_MARGIN < origin.y) {
                delta = origin.y - (figure.getLocation().y - SCROLL_MARGIN);
                origin.y -= delta;
            } else if (figure.getLocation().y + figure.getSize().height + SCROLL_MARGIN > origin.y + vp.getSize().height) {
                delta = figure.getLocation().y + figure.getSize().height + SCROLL_MARGIN - (origin.y + vp.getSize().height);
                origin.y += delta;
            }
            if (origin.x != vp.getViewLocation().x || origin.y != vp.getViewLocation().y) {
                vp.setViewLocation(origin);
            }
        }

        public void setSelectedModelObject(XModelObject object) {
            if (object == null) {
                return;
            }
            XModelObject diagramXML = (XModelObject)PagesEditor.this.getPagesModel().getData();
            if (diagramXML == null) {
                return;
            }
            XModelObject fileXML = diagramXML.getParent();
            if (fileXML == null || !object.getPath().startsWith(fileXML.getPath())) {
                return;
            }
            if (!object.getPath().startsWith(diagramXML.getPath()) && (object = SelectOnDiagramHandler.getItemOnDiagram((XModelObject)object)) == null) {
                return;
            }
            Object element = PagesEditor.this.getPagesModel().findElement(object);
            if (element == null) {
                element = PagesEditor.this.getPagesModel().findLink(object);
            }
            if (element == null) {
                return;
            }
            EditPart part = (EditPart)PagesEditor.this.viewer.getEditPartRegistry().get(element);
            if (part != null) {
                PagesEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)part));
                PagesDiagramEditPart diagram = (PagesDiagramEditPart)PagesEditor.this.getScrollingGraphicalViewer().getRootEditPart().getChildren().get(0);
                FreeformViewport vp = diagram.getFreeformViewport();
                if (vp != null && part instanceof PagesEditPart && part != diagram) {
                    PagesEditPart pagesPart = (PagesEditPart)part;
                    NodeFigure fig = (NodeFigure)pagesPart.getFigure();
                    if (fig.getLocation().x == 0 && fig.getLocation().y == 0) {
                        fig.setLocation(((PagesElement)pagesPart.getModel()).getLocation());
                    }
                    this.scroll(vp, fig);
                }
            }
        }
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                SeamUiPagesPlugin.log(exception);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((FileEditorInput)PagesEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!PagesEditor.this.isDirty()) {
                        PagesEditor.this.closeEditor(false);
                    }
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = PagesEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PagesEditor.this.superSetInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }
}

