/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol;

import com.eclipsesource.json.JsonObject;
import tern.server.protocol.JsonHelper;
import tern.server.protocol.html.HtmlHelper;
import tern.server.protocol.html.ScriptTagRegion;

public class TernFile
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private static final String NAME_FIELD_NAME = "name";
    private static final String TEXT_FIELD_NAME = "text";
    private static final String OFFSET_FIELD_NAME = "offset";
    private static final String TYPE_FIELD_NAME = "type";
    private static final String OFFSET_LINES_FIELD_TYPE = "offsetLines";

    public TernFile(String name) {
        super.add(NAME_FIELD_NAME, name);
        super.add(TYPE_FIELD_NAME, FileType.delete.name());
    }

    public TernFile(String name, String text, ScriptTagRegion[] tags) {
        this(name, text, tags, null);
    }

    public TernFile(String name, String text, ScriptTagRegion[] tags, Integer offset) {
        super.add(NAME_FIELD_NAME, name);
        super.add(TEXT_FIELD_NAME, this.getText(text, tags));
        if (offset != null) {
            super.add(TYPE_FIELD_NAME, FileType.part.name());
            super.add(OFFSET_LINES_FIELD_TYPE, offset.intValue());
        } else {
            super.add(TYPE_FIELD_NAME, FileType.full.name());
        }
    }

    private String getText(String text, ScriptTagRegion[] tags) {
        if (text == null || tags == null) {
            return text;
        }
        return HtmlHelper.extractJS(text, tags);
    }

    public String getName() {
        return JsonHelper.getString(this, NAME_FIELD_NAME);
    }

    public String getText() {
        return JsonHelper.getString(this, TEXT_FIELD_NAME);
    }

    public Integer getOffset() {
        return JsonHelper.getInteger(this, OFFSET_FIELD_NAME);
    }

    public String getType() {
        return JsonHelper.getString(this, TYPE_FIELD_NAME);
    }

    private static enum FileType {
        part,
        full,
        delete;

    }
}

