/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import tern.metadata.TernModuleMetadata;
import tern.metadata.TernModuleMetadataManager;
import tern.server.ITernPlugin;
import tern.server.ModuleType;

public enum TernPlugin implements ITernPlugin
{
    aui15("aui", "1.5.x"),
    aui2("aui", "2.0.x"),
    angular("tern/plugin/angular"),
    chrome_apps("chrome-apps", "chrome-apps", null, null),
    component("tern/plugin/component"),
    ckeditor_4_4_1("ckeditor", "4.4.1", true),
    closure(""),
    cordovajs("tern/plugin/cordovajs"),
    doc_comment("tern/plugin/doc_comment"),
    dojotoolkit_1_6("dojotoolkit", "1.6", true),
    dojotoolkit_1_8("dojotoolkit", "1.8", true),
    dojotoolkit_1_9("dojotoolkit", "1.9", true),
    extjs_4_2_1("extjs", "4.2.1", true),
    extjs_5_0_0("extjs", "5.0.0", true),
    guess_types("guess-types", "guess-types", null, null),
    gmaps_3_16("gmaps", "3.16", true),
    gmaps_3_17("gmaps", "3.17", true),
    grunt("tern/plugin/grunt"),
    gas("tern/plugin/gas"),
    liferay("tern/plugin/liferay"),
    lint("tern/plugin/lint"),
    node_express("node-express", "node-express", null, null),
    node_mongodb_native("node-mongodb-native", "node-mongodb-native", null, null),
    node_mongoose("node-mongoose", "node-mongoose", null, null),
    node("tern/plugin/node"),
    tabris("tern-tabris"),
    meteor("tern/plugin/meteor"),
    qooxdoo_4_1("qooxdoo", "4.1", true),
    requirejs("tern/plugin/requirejs"),
    yui3("yui", "3");

    private final String name;
    private final String type;
    private final String version;
    private final String path;
    private TernModuleMetadata metadata;

    private TernPlugin(String path) {
        this(null, null, null, path);
    }

    private TernPlugin(String type, String version) {
        this(type, version, false);
    }

    private TernPlugin(String type, String version, boolean oldName) {
        this(type + (oldName ? "_" : "") + version, type, version, "tern/plugin/" + type + "_" + version);
    }

    private TernPlugin(String name, String type, String version, String path) {
        this.name = name != null ? name : this.name();
        this.type = type != null ? type : this.name();
        this.path = path;
        this.version = version;
        this.metadata = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ModuleType getModuleType() {
        return ModuleType.Plugin;
    }

    public static ITernPlugin getTernPlugin(String name) {
        TernPlugin[] plugins = TernPlugin.values();
        TernPlugin plugin = null;
        int i = 0;
        while (i < plugins.length) {
            plugin = plugins[i];
            if (plugin.getName().equals(name)) {
                return plugin;
            }
            ++i;
        }
        return null;
    }

    @Override
    public TernModuleMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = TernModuleMetadataManager.getInstance().getMetadata(this.getType());
        }
        return this.metadata;
    }
}

