/*
 * Decompiled with CFR 0.152.
 */
package tern.server;

import com.eclipsesource.json.JsonObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import tern.TernException;
import tern.metadata.TernModuleMetadata;
import tern.server.ITernModule;
import tern.server.ITernModuleConfigurable;
import tern.server.ModuleType;
import tern.utils.StringUtils;

public class TernModuleConfigurable
implements ITernModuleConfigurable {
    private ITernModule wrappedModule;
    private final Map<String, ITernModule> modules = new LinkedHashMap<String, ITernModule>();
    private JsonObject options;

    public TernModuleConfigurable(ITernModule module) {
        this.wrappedModule = module;
        this.addModule(module);
    }

    @Override
    public String getName() {
        return this.wrappedModule.getName();
    }

    @Override
    public String getType() {
        return this.wrappedModule.getType();
    }

    @Override
    public String getVersion() {
        return this.wrappedModule.getVersion();
    }

    @Override
    public String getPath() {
        return this.wrappedModule.getPath();
    }

    @Override
    public ModuleType getModuleType() {
        return ModuleType.Configurable;
    }

    public void addModule(ITernModule module) {
        if (!StringUtils.isEmpty(module.getVersion())) {
            this.modules.put(module.getVersion(), module);
        }
    }

    @Override
    public ITernModule getWrappedModule() {
        return this.wrappedModule;
    }

    @Override
    public ITernModule setVersion(String version) throws TernException {
        ITernModule module = this.modules.get(version);
        if (module == null) {
            throw new TernException("Unsupported version " + version + " for type " + this.getType());
        }
        this.wrappedModule = module;
        return module;
    }

    @Override
    public Set<String> getAvailableVersions() {
        return this.modules.keySet();
    }

    @Override
    public TernModuleMetadata getMetadata() {
        return this.wrappedModule.getMetadata();
    }

    @Override
    public JsonObject getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(JsonObject options) {
        this.options = options;
    }

    @Override
    public ITernModule getModule(String name) {
        for (ITernModule module : this.modules.values()) {
            if (!name.equals(module.getName())) continue;
            return module;
        }
        return null;
    }

    @Override
    public Collection<ITernModule> getModules() {
        return this.modules.values();
    }

    @Override
    public boolean hasVersion() {
        return !this.modules.isEmpty();
    }

    public String toString() {
        return this.getType();
    }
}

