/*
 * Decompiled with CFR 0.152.
 */
package tern.internal.resources;

import java.io.IOException;
import org.w3c.dom.Document;
import tern.IDOMProvider;
import tern.ITernFile;
import tern.ITernFileSynchronizer;
import tern.ITernProject;
import tern.ITernResourcesManagerDelegate;
import tern.internal.resources.DefaultDOMProvider;
import tern.internal.resources.DefaultScriptTagRegionsProvider;
import tern.internal.resources.DefaultTernResourcesManager;
import tern.server.protocol.html.IScriptTagRegionProvider;
import tern.server.protocol.html.ScriptTagRegion;

public class InternalTernResourcesManager {
    private static final InternalTernResourcesManager INSTANCE = new InternalTernResourcesManager();
    private ITernResourcesManagerDelegate ternResourcesManagerDelegate = new DefaultTernResourcesManager();
    private IScriptTagRegionProvider scriptTagRegionProvider = new DefaultScriptTagRegionsProvider();
    private IDOMProvider provider = DefaultDOMProvider.INSTANCE;

    public static synchronized InternalTernResourcesManager getInstance() {
        return INSTANCE;
    }

    public ScriptTagRegion[] getScriptTagRegions(ITernFile file) {
        if (this.scriptTagRegionProvider != null) {
            return this.scriptTagRegionProvider.getScriptTags(file);
        }
        return null;
    }

    public ITernProject getTernProject(Object project, boolean force) throws IOException {
        return this.ternResourcesManagerDelegate.getTernProject(project, force);
    }

    public ITernFile getTernFile(ITernProject project, String name) {
        return this.ternResourcesManagerDelegate.getTernFile(project, name);
    }

    public ITernFile getTernFile(Object fileObject) {
        return this.ternResourcesManagerDelegate.getTernFile(fileObject);
    }

    public ITernFileSynchronizer createTernFileSynchronizer(ITernProject project) {
        return this.ternResourcesManagerDelegate.createTernFileSynchronizer(project);
    }

    public void setTernResourcesManagerDelegate(ITernResourcesManagerDelegate ternResourcesFactory) {
        this.ternResourcesManagerDelegate = ternResourcesFactory;
    }

    public void setScriptTagRegionProvider(IScriptTagRegionProvider scriptTagRegionProvider) {
        this.scriptTagRegionProvider = scriptTagRegionProvider;
    }

    public void setDOMProvider(IDOMProvider provider) {
        this.provider = provider;
    }

    public boolean isHTMLFile(Object fileObject) {
        return this.ternResourcesManagerDelegate.isHTMLFile(fileObject);
    }

    public boolean isJSFile(Object fileObject) {
        return this.ternResourcesManagerDelegate.isJSFile(fileObject);
    }

    public Document getDocument(ITernFile resource) {
        if (this.provider != null) {
            return this.provider.getDocument(resource);
        }
        return null;
    }
}

