/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.index.IndexManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.maven.core.MavenCoreActivator;
import org.jboss.tools.maven.ui.Activator;
import org.jboss.tools.maven.ui.internal.repositories.SettingsRepositoryBuilder;
import org.jboss.tools.maven.ui.preferences.AutoResizeTableLayout;
import org.jboss.tools.maven.ui.wizard.AddRepositoryDialog;
import org.jboss.tools.maven.ui.wizard.RepositoryWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class ConfigureMavenRepositoriesWizardPage
extends WizardPage
implements IPageChangedListener {
    private static final String ACTIVE_PROFILE = "activeProfile";
    private static final String ACTIVE_PROFILES = "activeProfiles";
    private static final String REPOSITORY_APACHE_ORG_ID = "repository-apache-org";
    private static final String REPOSITORY_APACHE_ORG_PROFILE_ID = "repository-apache-org";
    private static final String COM_SPRINGSOURCE_REPOSITORY_BUNDLES_EXTERNAL_ID = "com-springsource-repository-bundles-external";
    private static final String COM_SPRINGSOURCE_REPOSITORY_BUNDLES_EXTERNAL_PROFILE_ID = "com-springsource-repository-bundles-external";
    private static final String COM_SPRINGSOURCE_REPOSITORY_BUNDLES_RELEASE_ID = "com-springsource-repository-bundles-release";
    private static final String COM_SPRINGSOURCE_REPOSITORY_BUNDLES_RELEASE_PROFILE_ID = "com-springsource-repository-bundles-release";
    private static final String JAVA_NET_PUBLIC_ID = "java-net-public";
    private static final String JAVA_NET_PUBLIC_PROFILE_ID = "java-net-public";
    private static final String JBOSS_PUBLIC_REPOSITORY_ID = "jboss-public-repository";
    private static final String JBOSS_PUBLIC_REPOSITORY_PROFILE_ID = "jboss-public-repository";
    private static final String RED_HAT_TECHPREVIEW_ALL_REPOSITORY_ID = "redhat-techpreview-all-repository";
    private static final String RED_HAT_TECHPREVIEW_ALL_REPOSITORY_PROFILE_ID = "redhat-techpreview-all-repository";
    private static final String ERROR_TITLE = "Error";
    private static final String SNAPSHOTS_ELEMENT = "snapshots";
    private static final String UPDATE_POLICY_ELEMENT = "updatePolicy";
    private static final String ENABLED_ELEMENT = "enabled";
    private static final String RELEASES_ELEMENT = "releases";
    private static final String LAYOUT_ELEMENT = "layout";
    private static final String NAME_ELEMENT = "name";
    private static final String URL_ELEMENT = "url";
    private static final String REPOSITORY_ELEMENT = "repository";
    private static final String PLUGIN_REPOSITORIES_ELEMENT = "pluginRepositories";
    private static final String PLUGIN_REPOSITORY_ELEMENT = "pluginRepository";
    private static final String REPOSITORIES_ELEMENT = "repositories";
    private static final String ID_ELEMENT = "id";
    private static final String PROFILE_ELEMENT = "profile";
    private static final String PROFILES_ELEMENT = "profiles";
    private static final String UTF_8 = "UTF-8";
    private static final String PAGE_NAME = "org.jboss.tools.maven.ui.wizard.page";
    private static final String ADD_REPOSITORY = " Add Repository...";
    private static final String EDIT_REPOSITORY = " Edit Repository...";
    private static final String REMOVE_ALL = " Remove All ";
    private static final String REMOVE = " Remove ";
    private Button removeButton;
    private Button removeAllButton;
    private Button addRepositoryButton;
    private Button editRepositoryButton;
    private IMaven maven;
    private TableViewer includedRepositoriesViewer;
    private Set<RepositoryWrapper> includedRepositories;
    private Set<RepositoryWrapper> availableRepositories;
    private Set<RepositoryWrapper> selectedIncludedRepositories = new HashSet<RepositoryWrapper>();
    private Document document;
    private CompareConfiguration compareConfiguration;
    private TextMergeViewer previewViewer;
    private String newSettings;
    private String oldSettings;
    private ArtifactKey artifactKey;
    private String preSelectedProfileId;
    private Map<String, String> preconfiguredRepositoryUrls;

    public ConfigureMavenRepositoriesWizardPage(ArtifactKey artifactKey) {
        this(artifactKey, null);
    }

    public ConfigureMavenRepositoriesWizardPage(ArtifactKey artifactKey, String profileId) {
        super(PAGE_NAME);
        this.setTitle("Configure Maven Repositories");
        this.maven = MavenPlugin.getMaven();
        this.artifactKey = artifactKey;
        this.preSelectedProfileId = profileId;
    }

    public void createControl(Composite parent) {
        DocumentBuilder builder;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        Label userSettingsLabel = new Label(composite, 0);
        gd = new GridData(4, 4, true, false);
        userSettingsLabel.setLayoutData((Object)gd);
        String userSettings = ConfigureMavenRepositoriesWizardPage.getUserSettings();
        userSettingsLabel.setText("User settings: " + userSettings);
        File settingsFile = new File(userSettings);
        try {
            if (!settingsFile.exists()) {
                this.createDefaultSettings();
                this.maven.reloadSettings();
                this.oldSettings = "";
            } else {
                this.newSettings = this.oldSettings = this.readFile(settingsFile);
            }
        }
        catch (Exception e) {
            Activator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_TITLE, (String)e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Activator.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)ERROR_TITLE, (String)e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            this.document = builder.parse(new InputSource(new StringReader(this.newSettings)));
        }
        catch (Exception e) {
            Activator.log(e);
            try {
                this.createDefaultSettings();
            }
            catch (Exception e1) {
                Activator.log(e1);
                MessageDialog.openError((Shell)this.getShell(), (String)ERROR_TITLE, (String)e1.getMessage());
                throw new RuntimeException(e1);
            }
            try {
                this.document = builder.parse(new InputSource(new StringReader(this.newSettings)));
            }
            catch (Exception e1) {
                Activator.log(e1);
                MessageDialog.openError((Shell)this.getShell(), (String)ERROR_TITLE, (String)e1.getMessage());
                throw new RuntimeException(e1);
            }
        }
        Group repositoriesGroup = new Group(composite, 0);
        gd = new GridData(4, 4, true, false);
        GridLayout layout = new GridLayout(3, false);
        repositoriesGroup.setLayout((Layout)layout);
        repositoriesGroup.setLayoutData((Object)gd);
        repositoriesGroup.setText("Repositories");
        Composite includedRepositoriesComposite = new Composite((Composite)repositoriesGroup, 0);
        gd = new GridData(4, 4, true, false);
        includedRepositoriesComposite.setLayoutData((Object)gd);
        includedRepositoriesComposite.setLayout((Layout)new GridLayout(1, false));
        this.includedRepositoriesViewer = new TableViewer(includedRepositoriesComposite, 2818);
        gd = new GridData(4, 4, true, false);
        gd.widthHint = 500;
        gd.heightHint = 150;
        this.includedRepositoriesViewer.getTable().setLayoutData((Object)gd);
        this.includedRepositoriesViewer.getTable().setLinesVisible(false);
        this.includedRepositoriesViewer.getTable().setHeaderVisible(false);
        TableViewerColumn c = new TableViewerColumn(this.includedRepositoriesViewer, 0);
        c.getColumn().setText("Repository");
        c.getColumn().setResizable(true);
        AutoResizeTableLayout includedLayout = new AutoResizeTableLayout(this.includedRepositoriesViewer.getTable());
        ColumnWeightData columnLayoutData = new ColumnWeightData(350, 350);
        includedLayout.addColumnData((ColumnLayoutData)columnLayoutData);
        this.includedRepositoriesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.includedRepositoriesViewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.includedRepositoriesViewer, (int)2);
        this.createButtons((Composite)repositoriesGroup);
        this.includedRepositories = this.getIncludedRepositories();
        this.availableRepositories = this.getAvailableRepositories();
        ArrayList<RepositoryWrapper> remove = new ArrayList<RepositoryWrapper>();
        for (RepositoryWrapper availableRepository : this.availableRepositories) {
            if (!this.includedRepositories.contains(availableRepository)) continue;
            remove.add(availableRepository);
        }
        for (RepositoryWrapper repository : remove) {
            this.availableRepositories.remove(repository);
        }
        this.includedRepositoriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                ConfigureMavenRepositoriesWizardPage.this.selectedIncludedRepositories.clear();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    for (Object object : selection) {
                        if (!(object instanceof RepositoryWrapper)) continue;
                        ConfigureMavenRepositoriesWizardPage.this.selectedIncludedRepositories.add((RepositoryWrapper)object);
                    }
                }
                ConfigureMavenRepositoriesWizardPage.this.configureButtons();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = ConfigureMavenRepositoriesWizardPage.this.getMessageDialog(ConfigureMavenRepositoriesWizardPage.this.selectedIncludedRepositories);
                if (ok) {
                    for (RepositoryWrapper wrapper : ConfigureMavenRepositoriesWizardPage.this.selectedIncludedRepositories) {
                        ConfigureMavenRepositoriesWizardPage.this.includedRepositories.remove(wrapper);
                        ConfigureMavenRepositoriesWizardPage.this.availableRepositories.add(wrapper);
                        ConfigureMavenRepositoriesWizardPage.this.removeRepository(wrapper);
                    }
                    ConfigureMavenRepositoriesWizardPage.this.setPageComplete(true);
                    ConfigureMavenRepositoriesWizardPage.this.refreshRepositories();
                }
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = ConfigureMavenRepositoriesWizardPage.this.getMessageDialog(ConfigureMavenRepositoriesWizardPage.this.includedRepositories);
                if (!ok) {
                    return;
                }
                ArrayList<RepositoryWrapper> list = new ArrayList<RepositoryWrapper>();
                for (RepositoryWrapper wrapper : ConfigureMavenRepositoriesWizardPage.this.includedRepositories) {
                    list.add(wrapper);
                    ConfigureMavenRepositoriesWizardPage.this.removeRepository(wrapper);
                }
                ConfigureMavenRepositoriesWizardPage.this.includedRepositories.removeAll(list);
                ConfigureMavenRepositoriesWizardPage.this.availableRepositories.addAll(list);
                ConfigureMavenRepositoriesWizardPage.this.setPageComplete(true);
                ConfigureMavenRepositoriesWizardPage.this.refreshRepositories();
            }
        });
        this.addRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureMavenRepositoriesWizardPage.this.openAddRepositoryDialog();
            }
        });
        this.editRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureMavenRepositoriesWizardPage.this.openEditRepositoryDialog();
            }
        });
        Label separator = new Label(composite, 258);
        separator.setVisible(false);
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText("Preview:");
        this.createPreviewer(composite);
        Object[] newRepos = this.createPreselectedRepositories();
        this.setPageComplete(newRepos.length > 0);
        this.refreshRepositories();
        this.includedRepositoriesViewer.setSelection((ISelection)new StructuredSelection(newRepos));
    }

    private RepositoryWrapper[] createPreselectedRepositories() {
        if (this.preconfiguredRepositoryUrls == null || this.preconfiguredRepositoryUrls.isEmpty()) {
            return new RepositoryWrapper[0];
        }
        HashSet<RepositoryWrapper> allRepos = new HashSet<RepositoryWrapper>();
        allRepos.addAll(this.availableRepositories);
        allRepos.addAll(this.includedRepositories);
        ArrayList<RepositoryWrapper> newRepos = new ArrayList<RepositoryWrapper>();
        for (Map.Entry<String, String> entry : this.preconfiguredRepositoryUrls.entrySet()) {
            String repoId = entry.getKey();
            try {
                new URL(entry.getValue());
            }
            catch (Exception e) {
                Activator.log(e);
                continue;
            }
            RepositoryWrapper preconfiguredRepository = null;
            String preConfUrl = entry.getValue();
            for (RepositoryWrapper repo : allRepos) {
                if (!preConfUrl.equals(repo.getRepository().getUrl())) continue;
                preconfiguredRepository = repo;
                break;
            }
            if (preconfiguredRepository == null) {
                SettingsRepositoryBuilder r = new SettingsRepositoryBuilder();
                String name = StringUtils.capitaliseAllWords((String)repoId.replace("redhat", "Red Hat").replace("-", " "));
                if (!name.endsWith(" Repository")) {
                    name = String.valueOf(name) + " Repository";
                }
                r.setName(this.getUniqueName(name, allRepos));
                r.setUrl(preConfUrl);
                String id = this.getUniqueProfileId(repoId, allRepos);
                r.setId(id);
                preconfiguredRepository = new RepositoryWrapper(r.get());
            }
            this.includedRepositories.add(preconfiguredRepository);
            this.removeRepository(preconfiguredRepository);
            this.availableRepositories.remove(preconfiguredRepository);
            this.addRepository(preconfiguredRepository, true);
            newRepos.add(preconfiguredRepository);
        }
        RepositoryWrapper[] result = new RepositoryWrapper[newRepos.size()];
        newRepos.toArray(result);
        return result;
    }

    private String getUniqueName(String name, Collection<RepositoryWrapper> repos) {
        return this.getUniqueName(name, 1, repos);
    }

    private String getUniqueName(String name, int iteration, Collection<RepositoryWrapper> repos) {
        String candidateName = iteration > 1 ? String.valueOf(name) + " (" + iteration + ")" : name;
        for (RepositoryWrapper rw : repos) {
            if (!candidateName.equals(rw.getRepository().getName())) continue;
            return this.getUniqueName(candidateName, ++iteration, repos);
        }
        return candidateName;
    }

    private String getUniqueProfileId(String profileId, Collection<RepositoryWrapper> repos) {
        return this.getUniqueProfileId(profileId, 1, repos);
    }

    private String getUniqueProfileId(String profileId, int iteration, Collection<RepositoryWrapper> repos) {
        String candidateId = iteration > 1 ? String.valueOf(profileId) + "-" + iteration : profileId;
        for (RepositoryWrapper rw : repos) {
            if (!candidateId.equals(rw.getProfileId()) && !candidateId.equals(rw.getRepository().getId())) continue;
            return this.getUniqueProfileId(candidateId, ++iteration, repos);
        }
        return candidateId;
    }

    protected void createButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 128, false, false);
        buttonsComposite.setLayoutData((Object)gd);
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        this.removeButton = this.createButton(buttonsComposite, REMOVE);
        this.removeAllButton = this.createButton(buttonsComposite, REMOVE_ALL);
        this.addRepositoryButton = this.createButton(buttonsComposite, ADD_REPOSITORY);
        this.editRepositoryButton = this.createButton(buttonsComposite, EDIT_REPOSITORY);
    }

    private void createDefaultSettings() throws CoreException, UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.maven.writeSettings(new Settings(), (OutputStream)out);
        this.newSettings = new String(out.toByteArray(), UTF_8);
    }

    private void addRepository(RepositoryWrapper wrapper, boolean activeByDefault) {
        Element pluginRepositoriesElement;
        if (wrapper == null || wrapper.getProfileId() == null || wrapper.getRepository() == null) {
            return;
        }
        String profileId = wrapper.getProfileId();
        Element profile = this.getProfile(profileId);
        Element repositoriesElement = this.getElement(profile, REPOSITORIES_ELEMENT);
        if (repositoriesElement != null) {
            this.addRepository(wrapper, repositoriesElement, false);
        }
        if ((pluginRepositoriesElement = this.getElement(profile, PLUGIN_REPOSITORIES_ELEMENT)) != null) {
            this.addRepository(wrapper, pluginRepositoriesElement, true);
        }
        if (activeByDefault) {
            NodeList activeProfilesList = this.document.getElementsByTagName(ACTIVE_PROFILES);
            Node activeProfiles = null;
            if (activeProfilesList.getLength() > 0) {
                activeProfiles = (Element)activeProfilesList.item(0);
            }
            if (activeProfiles == null) {
                activeProfiles = this.document.createElement(ACTIVE_PROFILES);
                this.document.getDocumentElement().appendChild(activeProfiles);
            }
            NodeList activeProfileList = activeProfiles.getChildNodes();
            boolean activated = false;
            int i = 0;
            while (i < activeProfileList.getLength()) {
                Node node = activeProfileList.item(i);
                if (node.getNodeType() == 1 && ACTIVE_PROFILE.equals(node.getNodeName())) {
                    String id = node.getTextContent();
                    if (id != null) {
                        id = id.trim();
                    }
                    if (profileId.equals(id)) {
                        activated = true;
                        break;
                    }
                }
                ++i;
            }
            if (!activated) {
                this.addElement((Element)activeProfiles, ACTIVE_PROFILE, profileId);
            }
        }
    }

    private Element getElement(Element element, String name) {
        NodeList elements = element.getChildNodes();
        int len = elements.getLength();
        int i = 0;
        while (i < len) {
            Node node = elements.item(i);
            if (node.getNodeType() == 1 && name.equals(node.getNodeName())) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    private Element getProfile(String profileId) {
        Node profiles;
        NodeList profilesList = this.document.getElementsByTagName(PROFILES_ELEMENT);
        Element profileElement = null;
        if (profilesList.getLength() > 0) {
            profiles = profilesList.item(0);
            NodeList profileNodes = profiles.getChildNodes();
            int length = profileNodes.getLength();
            int i = 0;
            while (i < length) {
                Node profile = profileNodes.item(i);
                if (profile.getNodeType() == 1 && PROFILE_ELEMENT.equals(profile.getNodeName())) {
                    NodeList profileElements = profile.getChildNodes();
                    int j = 0;
                    while (j < profileElements.getLength()) {
                        Node node = profileElements.item(j);
                        if (node.getNodeType() == 1 && ID_ELEMENT.equals(node.getNodeName())) {
                            String id = node.getTextContent();
                            if (id != null) {
                                id = id.trim();
                            }
                            if (profileId.equals(id)) {
                                profileElement = (Element)profile;
                                break;
                            }
                        }
                        ++j;
                    }
                }
                if (profileElement == null) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            profiles = this.document.createElement(PROFILES_ELEMENT);
            this.document.getDocumentElement().appendChild(profiles);
        }
        if (profileElement == null) {
            profileElement = this.createProfile(profiles, profileId);
        }
        this.configureProfile(profileElement);
        return profileElement;
    }

    private Element createProfile(Node profiles, String profileId) {
        Element profile = this.document.createElement(PROFILE_ELEMENT);
        profiles.appendChild(profile);
        Element id = this.document.createElement(ID_ELEMENT);
        id.setTextContent(profileId);
        profile.appendChild(id);
        return profile;
    }

    private void configureProfile(Element profileElement) {
        NodeList nodeList = profileElement.getChildNodes();
        int len = nodeList.getLength();
        Element repositoriesElement = null;
        Element pluginRepositoriesElement = null;
        int i = 0;
        while (i < len) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && REPOSITORIES_ELEMENT.equals(node.getNodeName())) {
                repositoriesElement = (Element)node;
            }
            if (node.getNodeType() == 1 && PLUGIN_REPOSITORIES_ELEMENT.equals(node.getNodeName())) {
                pluginRepositoriesElement = (Element)node;
            }
            if (repositoriesElement != null && pluginRepositoriesElement != null) {
                return;
            }
            ++i;
        }
        if (repositoriesElement == null) {
            repositoriesElement = this.document.createElement(REPOSITORIES_ELEMENT);
            profileElement.appendChild(repositoriesElement);
        }
        if (pluginRepositoriesElement == null) {
            pluginRepositoriesElement = this.document.createElement(PLUGIN_REPOSITORIES_ELEMENT);
            profileElement.appendChild(pluginRepositoriesElement);
        }
    }

    private void addRepository(RepositoryWrapper wrapper, Element repos, boolean isPluginRepository) {
        RepositoryPolicy policy;
        Element repository = isPluginRepository ? this.document.createElement(PLUGIN_REPOSITORY_ELEMENT) : this.document.createElement(REPOSITORY_ELEMENT);
        repos.appendChild(repository);
        this.addElement(repository, ID_ELEMENT, wrapper.getRepository().getId());
        String name = wrapper.getRepository().getName();
        if (name != null) {
            this.addElement(repository, NAME_ELEMENT, wrapper.getRepository().getName());
        }
        this.addElement(repository, URL_ELEMENT, wrapper.getRepository().getUrl());
        String layout = wrapper.getRepository().getLayout();
        if (layout != null) {
            this.addElement(repository, LAYOUT_ELEMENT, wrapper.getRepository().getLayout());
        }
        if ((policy = wrapper.getRepository().getReleases()) != null) {
            Element releases = this.addElement(repository, RELEASES_ELEMENT, null);
            this.addElement(releases, ENABLED_ELEMENT, policy.isEnabled() ? "true" : "false");
            this.addElement(releases, UPDATE_POLICY_ELEMENT, policy.getUpdatePolicy());
            repository.appendChild(releases);
        }
        if ((policy = wrapper.getRepository().getSnapshots()) != null) {
            Element snapshots = this.addElement(repository, SNAPSHOTS_ELEMENT, null);
            this.addElement(snapshots, ENABLED_ELEMENT, policy.isEnabled() ? "true" : "false");
            this.addElement(snapshots, UPDATE_POLICY_ELEMENT, policy.getUpdatePolicy());
            repository.appendChild(snapshots);
        }
    }

    protected Element addElement(Element element, String name, String value) {
        Element child = this.document.createElement(name);
        if (value != null) {
            Text textNode = this.document.createTextNode(value);
            child.appendChild(textNode);
        }
        element.appendChild(child);
        return child;
    }

    protected void removeRepository(RepositoryWrapper wrapper) {
        Node node;
        int i;
        int len;
        NodeList nodeList;
        Element pluginRepositoriesElement;
        if (wrapper == null || wrapper.getProfileId() == null || wrapper.getRepository() == null || wrapper.getRepository().getUrl() == null) {
            return;
        }
        String url = wrapper.getRepository().getUrl();
        String profileId = wrapper.getProfileId();
        Element profile = this.getProfile(profileId);
        if (profile == null) {
            return;
        }
        Element repositoriesElement = this.getElement(profile, REPOSITORIES_ELEMENT);
        if (repositoriesElement != null) {
            this.removeRepository(url, repositoriesElement, false);
        }
        if ((pluginRepositoriesElement = this.getElement(profile, PLUGIN_REPOSITORIES_ELEMENT)) != null) {
            this.removeRepository(url, pluginRepositoriesElement, true);
        }
        if (repositoriesElement != null) {
            nodeList = repositoriesElement.getChildNodes();
            len = nodeList.getLength();
            i = 0;
            while (i < len) {
                node = nodeList.item(i);
                if (node.getNodeType() == 1 && REPOSITORY_ELEMENT.equals(node.getNodeName())) {
                    return;
                }
                ++i;
            }
        }
        if (pluginRepositoriesElement != null) {
            nodeList = pluginRepositoriesElement.getChildNodes();
            len = nodeList.getLength();
            i = 0;
            while (i < len) {
                node = nodeList.item(i);
                if (node.getNodeType() == 1 && PLUGIN_REPOSITORY_ELEMENT.equals(node.getNodeName())) {
                    return;
                }
                ++i;
            }
        }
        NodeList profilesList = this.document.getElementsByTagName(PROFILES_ELEMENT);
        Element profiles = (Element)profilesList.item(0);
        profiles.removeChild(profile);
        NodeList activeProfilesList = this.document.getElementsByTagName(ACTIVE_PROFILES);
        Node activeProfiles = null;
        if (activeProfilesList.getLength() > 0) {
            activeProfiles = (Element)activeProfilesList.item(0);
        }
        if (activeProfiles != null) {
            NodeList activeProfileList = activeProfiles.getChildNodes();
            Node profileNode = null;
            int i2 = 0;
            while (i2 < activeProfileList.getLength()) {
                Node node2 = activeProfileList.item(i2);
                if (node2.getNodeType() == 1 && ACTIVE_PROFILE.equals(node2.getNodeName())) {
                    String id = node2.getTextContent();
                    if (id != null) {
                        id = id.trim();
                    }
                    if (profileId.equals(id)) {
                        profileNode = node2;
                        break;
                    }
                }
                ++i2;
            }
            if (profileNode != null) {
                activeProfiles.removeChild(profileNode);
            }
        }
    }

    protected void removeRepository(String url, Element repos, boolean isPluginRepository) {
        NodeList repositoryNodeList = repos.getChildNodes();
        int len = repositoryNodeList.getLength();
        String name = isPluginRepository ? PLUGIN_REPOSITORY_ELEMENT : REPOSITORY_ELEMENT;
        Node repository = null;
        int i = 0;
        while (i < len) {
            Node node = repositoryNodeList.item(i);
            if (node.getNodeType() == 1 && name.equals(node.getNodeName())) {
                String urlNode = this.getRepositoryUrl(node);
                if (url != null && !url.endsWith("/")) {
                    url = String.valueOf(url) + "/";
                }
                if (urlNode != null && urlNode.equals(url)) {
                    repository = node;
                    break;
                }
            }
            ++i;
        }
        if (repository != null) {
            repos.removeChild(repository);
        }
    }

    private String getRepositoryUrl(Node repository) {
        NodeList nodeList = repository.getChildNodes();
        int len = nodeList.getLength();
        int i = 0;
        while (i < len) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && URL_ELEMENT.equals(node.getNodeName())) {
                String value = node.getTextContent();
                if (value != null && !(value = value.trim()).endsWith("/")) {
                    value = String.valueOf(value) + "/";
                }
                return value;
            }
            ++i;
        }
        return null;
    }

    private void createPreviewer(Composite composite) {
        this.compareConfiguration = new CompareConfiguration();
        this.compareConfiguration.setAncestorLabel("Preview:");
        this.compareConfiguration.setLeftLabel("Old settings");
        this.compareConfiguration.setLeftEditable(false);
        this.compareConfiguration.setRightLabel("New settings");
        this.compareConfiguration.setRightEditable(false);
        this.previewViewer = new TextMergeViewer(composite, 2048, this.compareConfiguration);
        this.previewViewer.setInput((Object)new DiffNode(3, null, (ITypedElement)new StringPreviewerInput(this.oldSettings), (ITypedElement)new PreviewerInput()));
        Control control = this.previewViewer.getControl();
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 200;
        control.setLayoutData((Object)gd);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ConfigureMavenRepositoriesWizardPage.this.compareConfiguration != null) {
                    ConfigureMavenRepositoriesWizardPage.this.compareConfiguration.dispose();
                }
            }
        });
    }

    private String getNewSettings() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", 2);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (Exception e) {
            Activator.log(e);
            return null;
        }
    }

    private String readFile(File file) throws FileNotFoundException {
        StringBuilder text = new StringBuilder();
        String NL = System.getProperty("line.separator");
        Scanner scanner = new Scanner((InputStream)new FileInputStream(file), UTF_8);
        try {
            while (scanner.hasNextLine()) {
                text.append(scanner.nextLine()).append(NL);
            }
        }
        finally {
            scanner.close();
        }
        return text.toString();
    }

    public static String getUserSettings() {
        String userSettings = MavenPlugin.getMavenConfiguration().getUserSettingsFile();
        if (userSettings == null || userSettings.length() == 0) {
            userSettings = MavenCli.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        }
        return userSettings;
    }

    private void configureButtons() {
        this.removeAllButton.setEnabled(this.includedRepositories.size() > 0);
        this.removeButton.setEnabled(this.selectedIncludedRepositories.size() > 0);
        this.editRepositoryButton.setEnabled(this.selectedIncludedRepositories.size() == 1);
    }

    private void refreshRepositories() {
        this.includedRepositoriesViewer.setInput((Object)this.includedRepositories.toArray(new RepositoryWrapper[0]));
        this.previewViewer.refresh();
        this.selectedIncludedRepositories.clear();
        this.includedRepositoriesViewer.setSelection((ISelection)new StructuredSelection((Object[])this.selectedIncludedRepositories.toArray(new RepositoryWrapper[0])));
        this.configureButtons();
    }

    private Set<RepositoryWrapper> getIncludedRepositories() {
        TreeSet<RepositoryWrapper> repositories = new TreeSet<RepositoryWrapper>();
        try {
            List<Profile> profiles = this.getProfiles();
            for (Profile profile : profiles) {
                List repos = profile.getRepositories();
                for (Repository repository : repos) {
                    String profileId = profile.getId() == null ? "" : profile.getId();
                    repositories.add(new RepositoryWrapper(repository, profileId));
                }
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return repositories;
    }

    private Set<RepositoryWrapper> getAvailableRepositories() {
        TreeSet<RepositoryWrapper> repositories = new TreeSet<RepositoryWrapper>();
        SettingsRepositoryBuilder repoBuilder = new SettingsRepositoryBuilder().setId("jboss-public-repository").setName("JBoss Public").setUrl("https://repository.jboss.org/nexus/content/groups/public-jboss/");
        repositories.add(new RepositoryWrapper(repoBuilder.get()));
        repoBuilder = new SettingsRepositoryBuilder().setId("redhat-techpreview-all-repository").setName("Red Hat Tech Preview repository (all)").setUrl("http://maven.repository.redhat.com/techpreview/all/");
        repositories.add(new RepositoryWrapper(repoBuilder.get()));
        repoBuilder = new SettingsRepositoryBuilder().setId("java-net-public").setName("Java Net Public").setUrl("https://maven.java.net/content/groups/public/");
        repositories.add(new RepositoryWrapper(repoBuilder.get()));
        repoBuilder = new SettingsRepositoryBuilder().setId("com-springsource-repository-bundles-release").setName("EBR Spring Release").setUrl("http://repository.springsource.com/maven/bundles/release/");
        repositories.add(new RepositoryWrapper(repoBuilder.get()));
        repoBuilder = new SettingsRepositoryBuilder().setId("com-springsource-repository-bundles-external").setName("EBR External Release").setUrl("http://repository.springsource.com/maven/bundles/external/");
        repositories.add(new RepositoryWrapper(repoBuilder.get()));
        repoBuilder = new SettingsRepositoryBuilder().setId("repository-apache-org").setName("Apache Repository").setUrl("https://repository.apache.org/content/groups/public/");
        repositories.add(new RepositoryWrapper(repoBuilder.get()));
        return repositories;
    }

    private List<Profile> getProfiles() throws CoreException {
        return this.maven.getSettings().getProfiles();
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 16384);
        GridData gd = new GridData(4, 4, false, false);
        button.setLayoutData((Object)gd);
        button.setText(text);
        return button;
    }

    public static byte[] getBytes(String s, String encoding) {
        byte[] bytes = null;
        if (s != null) {
            try {
                bytes = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = s.getBytes();
            }
        }
        return bytes;
    }

    private boolean isActive(RepositoryWrapper wrapper) {
        if (wrapper != null) {
            String profileId = wrapper.getProfileId();
            NodeList activeProfilesList = this.document.getElementsByTagName(ACTIVE_PROFILES);
            Node activeProfiles = null;
            if (activeProfilesList.getLength() > 0) {
                activeProfiles = (Element)activeProfilesList.item(0);
            }
            if (activeProfiles == null) {
                return false;
            }
            NodeList activeProfileList = activeProfiles.getChildNodes();
            int i = 0;
            while (i < activeProfileList.getLength()) {
                Node node = activeProfileList.item(i);
                if (node.getNodeType() == 1 && ACTIVE_PROFILE.equals(node.getNodeName())) {
                    String id = node.getTextContent();
                    if (id != null) {
                        id = id.trim();
                    }
                    if (profileId.equals(id)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public boolean finishPage() {
        String userSettings = ConfigureMavenRepositoriesWizardPage.getUserSettings();
        File file = new File(userSettings);
        boolean ok = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Confirm File Update", (String)("Are you sure you want to update the file '" + userSettings + "'?"));
        if (!ok) {
            return false;
        }
        String outputString = this.getNewSettings();
        FileOutputStream out = null;
        try {
            try {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                out = new FileOutputStream(file);
                byte[] bytes = outputString.getBytes(UTF_8);
                out.write(bytes);
                out.flush();
                this.updateSettings();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)ERROR_TITLE, (String)e.getMessage());
                Activator.log(e);
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    protected void updateSettings() {
        final String userSettings = ConfigureMavenRepositoriesWizardPage.getUserSettings();
        Job job = new Job("Updating Maven settings..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject[] projects;
                    MavenPlugin.getMaven().reloadSettings();
                    File localRepositoryDir = new File(ConfigureMavenRepositoriesWizardPage.this.maven.getLocalRepository().getBasedir());
                    IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
                    if (userSettings.length() > 0) {
                        mavenConfiguration.setUserSettingsFile(userSettings);
                    } else {
                        mavenConfiguration.setUserSettingsFile(null);
                    }
                    MavenCoreActivator.getDefault().notifyMavenSettingsChanged();
                    File newRepositoryDir = new File(ConfigureMavenRepositoriesWizardPage.this.maven.getLocalRepository().getBasedir());
                    if (!newRepositoryDir.equals(localRepositoryDir)) {
                        IndexManager indexManager = MavenPlugin.getIndexManager();
                        indexManager.getWorkspaceIndex().updateIndex(true, monitor);
                    }
                    if ((projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) != null && projects.length > 0) {
                        MavenUpdateRequest updateRequest = new MavenUpdateRequest(projects, mavenConfiguration.isOffline(), true);
                        MavenPlugin.getMavenProjectRegistry().refresh(updateRequest);
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Activator.log(e);
                    return e.getStatus();
                }
            }
        };
        job.schedule();
    }

    private boolean getMessageDialog(Set<RepositoryWrapper> repos) {
        if (repos.size() == 0) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        if (repos.size() == 1) {
            builder.append("Are you sure you want to delete the '");
            builder.append(repos.iterator().next().getRepository().getUrl());
            builder.append("' repository?");
        } else {
            builder.append("Are you sure you want to delete the following repositories:\n\n");
            for (RepositoryWrapper wrapper : repos) {
                builder.append(wrapper.getRepository().getUrl());
                builder.append("\n");
            }
            builder.append("\n");
        }
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)"Question?", (String)builder.toString());
    }

    public void pageChanged(PageChangedEvent event) {
        if (((Object)((Object)this)).equals(event.getSelectedPage())) {
            if (this.preSelectedProfileId == null) {
                this.openEditRepositoryDialog();
            } else {
                for (RepositoryWrapper repo : this.availableRepositories) {
                    if (!this.preSelectedProfileId.equals(repo.getProfileId())) continue;
                    this.openAddRepositoryDialog();
                    break;
                }
                this.preSelectedProfileId = null;
            }
        }
    }

    private void openEditRepositoryDialog() {
        RepositoryWrapper editWrapper;
        if (this.selectedIncludedRepositories.size() != 1) {
            return;
        }
        RepositoryWrapper selectedWrapper = this.selectedIncludedRepositories.iterator().next();
        if (selectedWrapper == null || selectedWrapper.getProfileId() == null) {
            return;
        }
        try {
            editWrapper = selectedWrapper.clone();
        }
        catch (CloneNotSupportedException e) {
            Activator.log(e);
            editWrapper = selectedWrapper;
        }
        AddRepositoryDialog dialog = new AddRepositoryDialog(this.getShell(), this.availableRepositories, this.includedRepositories, this.maven, this.artifactKey, editWrapper, this.isActive(editWrapper));
        dialog.setPreSelectedProfile(selectedWrapper.getProfileId());
        int ok = dialog.open();
        if (ok == 0) {
            RepositoryWrapper wrapper = dialog.getRepositoryWrapper();
            this.includedRepositories.remove(selectedWrapper);
            this.removeRepository(selectedWrapper);
            this.addRepository(wrapper, dialog.isActiveByDefault());
            this.includedRepositories.add(wrapper);
            this.setPageComplete(true);
            this.refreshRepositories();
        }
    }

    private void openAddRepositoryDialog() {
        AddRepositoryDialog dialog = new AddRepositoryDialog(this.getShell(), this.availableRepositories, this.includedRepositories, this.maven, this.artifactKey);
        dialog.setPreSelectedProfile(this.preSelectedProfileId);
        int ok = dialog.open();
        if (ok == 0) {
            RepositoryWrapper wrapper = dialog.getRepositoryWrapper();
            this.includedRepositories.add(wrapper);
            this.availableRepositories.remove(wrapper);
            this.addRepository(wrapper, dialog.isActiveByDefault());
            this.setPageComplete(true);
            this.refreshRepositories();
        }
    }

    public void addPreconfiguredRepositories(Map<String, String> preconfiguredRepositories) {
        this.preconfiguredRepositoryUrls = preconfiguredRepositories;
    }

    class PreviewerInput
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        PreviewerInput() {
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return "no name";
        }

        public String getType() {
            return "xml";
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(ConfigureMavenRepositoriesWizardPage.getBytes(ConfigureMavenRepositoriesWizardPage.this.getNewSettings(), ConfigureMavenRepositoriesWizardPage.UTF_8));
        }

        public String getCharset() {
            return ConfigureMavenRepositoriesWizardPage.UTF_8;
        }
    }

    class RepositoryLabelProvider
    extends StyledCellLabelProvider {
        RepositoryLabelProvider() {
        }

        public String getToolTipText(Object element) {
            if (element instanceof RepositoryWrapper) {
                return ((RepositoryWrapper)element).getDisplayName();
            }
            return null;
        }

        public Point getToolTipShift(Object object) {
            return new Point(10, 10);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 1000;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RepositoryWrapper) {
                return ((RepositoryWrapper)element).getDisplayName();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof RepositoryWrapper) {
                RepositoryWrapper wrapper = (RepositoryWrapper)element;
                StyledString text = new StyledString();
                String displayName = ConfigureMavenRepositoriesWizardPage.this.isActive(wrapper) ? wrapper.getDisplayName() : String.valueOf(wrapper.getDisplayName()) + " (Inactive)";
                StyleRange styledRange = new StyleRange(0, displayName.length(), null, null);
                text.append(displayName, StyledString.DECORATIONS_STYLER);
                cell.setText(text.toString());
                styledRange.font = ConfigureMavenRepositoriesWizardPage.this.isActive(wrapper) ? JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont") : JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
                StyleRange[] range = new StyleRange[]{styledRange};
                cell.setStyleRanges(range);
            }
            super.update(cell);
        }
    }

    class StringPreviewerInput
    extends PreviewerInput {
        String fContent;

        StringPreviewerInput(String content) {
            if (content == null) {
                content = "<null>";
            }
            this.fContent = content;
        }

        @Override
        public InputStream getContents() {
            return new ByteArrayInputStream(ConfigureMavenRepositoriesWizardPage.getBytes(this.fContent, ConfigureMavenRepositoriesWizardPage.UTF_8));
        }
    }
}

