/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.Iterator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.jboss.tools.hibernate.proxy.PersistentClassProxy;
import org.jboss.tools.hibernate.proxy.PropertyProxy;
import org.jboss.tools.hibernate.spi.IPersistentClass;
import org.jboss.tools.hibernate.spi.IProperty;
import org.jboss.tools.hibernate.spi.IValue;

public class SpecialRootClassProxy
extends PersistentClassProxy {
    private IProperty property;
    private IProperty parentProperty;

    public SpecialRootClassProxy(IProperty property) {
        super((PersistentClass)new RootClass());
        this.property = property;
        this.generate();
    }

    private void generate() {
        if (this.property == null) {
            return;
        }
        IValue propVal = this.property.getValue();
        IValue component = null;
        if (propVal != null && propVal.isCollection()) {
            IValue collection = propVal;
            component = collection.getElement();
        } else if (propVal.isComponent()) {
            component = propVal;
        }
        if (component != null) {
            this.setClassName(component.getComponentClassName());
            this.setEntityName(component.getComponentClassName());
            IPersistentClass ownerClass = component.getOwner();
            if (component.getParentProperty() != null) {
                this.parentProperty = new PropertyProxy(new Property());
                this.parentProperty.setName(component.getParentProperty());
                this.parentProperty.setPersistentClass(ownerClass);
            }
            Iterator iterator = component.getPropertyIterator();
            while (iterator.hasNext()) {
                IProperty property = (IProperty)iterator.next();
                if (property == null) continue;
                this.addProperty(property);
            }
        }
    }

    @Override
    public IProperty getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public IProperty getProperty() {
        return this.property;
    }

    @Override
    public boolean isInstanceOfSpecialRootClass() {
        return true;
    }
}

