/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.ProgressListener;
import org.jboss.tools.hibernate.proxy.DatabaseCollectorProxy;
import org.jboss.tools.hibernate.proxy.MetaDataDialectProxy;
import org.jboss.tools.hibernate.spi.IDatabaseCollector;
import org.jboss.tools.hibernate.spi.IJDBCReader;
import org.jboss.tools.hibernate.spi.IMetaDataDialect;
import org.jboss.tools.hibernate.spi.IProgressListener;

public class JDBCReaderProxy
implements IJDBCReader {
    private JDBCReader target = null;
    private IMetaDataDialect metaDataDialect = null;

    public JDBCReaderProxy(JDBCReader reader) {
        this.target = reader;
    }

    public IMetaDataDialect getMetaDataDialect() {
        if (this.metaDataDialect == null) {
            this.metaDataDialect = new MetaDataDialectProxy(this.target.getMetaDataDialect());
        }
        return this.metaDataDialect;
    }

    public void readDatabaseSchema(IDatabaseCollector databaseCollector, String defaultCatalogName, String defaultSchemaName, IProgressListener progressListener) {
        assert (databaseCollector instanceof DatabaseCollectorProxy);
        this.target.readDatabaseSchema((DatabaseCollector)((DatabaseCollectorProxy)databaseCollector).getTarget(), defaultCatalogName, defaultSchemaName, (ProgressListener)new ProgressListenerImpl(progressListener));
    }

    private class ProgressListenerImpl
    implements ProgressListener {
        private IProgressListener target;

        public ProgressListenerImpl(IProgressListener progressListener) {
            this.target = progressListener;
        }

        public void startSubTask(String name) {
            this.target.startSubTask(name);
        }
    }
}

