/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.result.CompositeResult;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.tools.forge.ui.internal.ForgeUIPlugin;
import org.jboss.tools.forge.ui.internal.ext.context.UIContextImpl;
import org.jboss.tools.forge.ui.internal.ext.dialog.InterruptableProgressMonitor;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardHelper;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;
import org.jboss.tools.forge.ui.internal.ext.wizards.MutableWizard;
import org.jboss.tools.forge.ui.notifications.NotificationType;

public class ForgeWizard
extends MutableWizard {
    private final CommandController controller;
    private final UIContextImpl uiContext;
    private ForgeWizardHelper helper = new ForgeWizardHelper();
    private InterruptableProgressMonitor progressMonitor;

    public ForgeWizard(String command, CommandController controller, UIContextImpl contextImpl) {
        this.controller = controller;
        this.uiContext = contextImpl;
        this.setWindowTitle(this.constructTitle(command));
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(this.isWizard());
        this.helper.onCreate(contextImpl);
    }

    public UIContextImpl getUIContext() {
        return this.uiContext;
    }

    private String constructTitle(String command) {
        UISelection currentSelection = this.uiContext.getInitialSelection();
        StringBuilder title = new StringBuilder(command);
        if (!currentSelection.isEmpty()) {
            IResource resource = currentSelection.getResource();
            String currentSelectionLabel = resource != null ? resource.getFullPath().toOSString() : currentSelection.get().toString();
            title.append(" [Current Selection: ").append(currentSelectionLabel).append("]");
        }
        return title.toString();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.createPage());
    }

    public boolean canFinish() {
        return this.controller.canExecute();
    }

    public boolean performFinish() {
        try {
            IWizardContainer container = this.getContainer();
            this.performFinish((IRunnableContext)container, container.getShell());
        }
        catch (Exception e) {
            ForgeUIPlugin.log(e);
        }
        return true;
    }

    public void performFinish(IRunnableContext runnableContext, final Shell shell) throws InvocationTargetException, InterruptedException {
        runnableContext.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (ForgeWizard.this.progressMonitor != null) {
                            ForgeWizard.this.progressMonitor.setRunnableThread(Thread.currentThread());
                        }
                        monitor.beginTask("Executing Forge Wizard", -1);
                        Map attributeMap = ForgeWizard.this.uiContext.getAttributeMap();
                        attributeMap.put(IProgressMonitor.class, monitor);
                        attributeMap.put(Shell.class, shell);
                        Result commandResult = ForgeWizard.this.controller.execute();
                        ForgeWizard.this.displayResult(commandResult);
                        ForgeWizard.this.helper.onFinish(ForgeWizard.this.getUIContext());
                        monitor.done();
                    }
                    catch (Exception e) {
                        ForgeUIPlugin.displayMessage(ForgeWizard.this.getWindowTitle(), "Error while executing task, check Error log view", NotificationType.ERROR);
                        ForgeUIPlugin.log(e);
                        try {
                            ForgeWizard.this.controller.close();
                        }
                        catch (Exception e2) {
                            ForgeUIPlugin.log(e2);
                        }
                    }
                }
                finally {
                    try {
                        ForgeWizard.this.controller.close();
                    }
                    catch (Exception e) {
                        ForgeUIPlugin.log(e);
                    }
                }
            }
        });
    }

    public void setProgressMonitor(InterruptableProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    private void displayResult(Result result) {
        if (result instanceof CompositeResult) {
            for (Result thisResult : ((CompositeResult)result).getResults()) {
                this.displayResult(thisResult);
            }
        } else if (result != null) {
            Throwable exception;
            String message = result.getMessage();
            if (message != null) {
                NotificationType notificationType = result instanceof Failed ? NotificationType.ERROR : NotificationType.INFO;
                ForgeUIPlugin.displayMessage(this.getWindowTitle(), message, notificationType);
            }
            if (result instanceof Failed && (exception = ((Failed)result).getException()) != null) {
                ForgeUIPlugin.log(exception);
                ForgeUIPlugin.displayMessage(this.getWindowTitle(), String.valueOf(exception.getMessage()), NotificationType.ERROR);
            }
        }
    }

    public boolean performCancel() {
        this.helper.onCancel(this.getUIContext());
        return true;
    }

    protected ForgeWizardPage createPage() {
        return new ForgeWizardPage(this, this.controller);
    }

    private boolean isWizard() {
        return this.controller instanceof WizardCommandController;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage != null) {
            this.removeSubsequentPages(nextPage);
            nextPage = null;
        }
        if (nextPage == null) {
            try {
                this.addPage((IWizardPage)this.createPage());
                nextPage = super.getNextPage(page);
            }
            catch (Exception e) {
                ForgeUIPlugin.log(e);
            }
        }
        return nextPage;
    }

    private void removeSubsequentPages(IWizardPage page) {
        List<ForgeWizardPage> pageList = this.getPageList();
        int idx = pageList.indexOf(page);
        List<ForgeWizardPage> subList = pageList.subList(idx, pageList.size());
        for (ForgeWizardPage forgeWizardPage : subList) {
            forgeWizardPage.dispose();
        }
        subList.clear();
    }
}

