/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.dialog;

import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.forge.ui.internal.ext.dialog.ForgeCommandDialog;
import org.jboss.tools.forge.ui.internal.ext.dialog.InterruptableProgressMonitor;

public class ForgeProgressMonitorPart
extends ProgressMonitorPart {
    private ToolItem fStopButton;
    private ToolBar fToolBar;
    private ForgeCommandDialog dialog;

    public ForgeProgressMonitorPart(Composite parent, Layout layout, ForgeCommandDialog dialog) {
        super(parent, layout, true);
        this.dialog = dialog;
    }

    protected void initialize(Layout layout, int progressIndicatorHeight) {
        if (layout == null) {
            GridLayout l = new GridLayout();
            l.marginWidth = 0;
            l.marginHeight = 0;
            layout = l;
        }
        int numColumns = 2;
        this.setLayout(layout);
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).numColumns = numColumns;
        }
        this.fLabel = new Label((Composite)this, 16384);
        this.fLabel.setLayoutData((Object)new GridData(4, 2, true, false, numColumns, 1));
        if (progressIndicatorHeight == -1) {
            GC gc = new GC((Drawable)this.fLabel);
            FontMetrics fm = gc.getFontMetrics();
            gc.dispose();
            progressIndicatorHeight = fm.getHeight();
        }
        this.fProgressIndicator = new ProgressIndicator((Composite)this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.verticalAlignment = 2;
        gd.heightHint = progressIndicatorHeight;
        this.fProgressIndicator.setLayoutData((Object)gd);
        this.fToolBar = new ToolBar((Composite)this, 0x800000);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = false;
        gd.verticalAlignment = 2;
        this.fToolBar.setLayoutData((Object)gd);
        this.fStopButton = new ToolItem(this.fToolBar, 8);
        this.fStopButton.addListener(13, (Listener)new CancelListener());
        final Image stopImage = ImageDescriptor.createFromFile(ForgeProgressMonitorPart.class, (String)"images/stop.gif").createImage((Device)this.getDisplay());
        final Cursor arrowCursor = new Cursor((Device)this.getDisplay(), 0);
        this.fToolBar.setCursor(arrowCursor);
        this.fStopButton.setImage(stopImage);
        this.fStopButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                stopImage.dispose();
                arrowCursor.dispose();
            }
        });
        this.fStopButton.setEnabled(false);
        this.fStopButton.setToolTipText(JFaceResources.getString((String)"ProgressMonitorPart.cancelToolTip"));
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public void attachToCancelComponent(Control cancelComponent) {
        cancelComponent.addListener(13, (Listener)new CancelListener());
        this.setCancelEnabled(true);
    }

    public void setCancelEnabled(boolean enabled) {
        if (this.fStopButton != null && !this.fStopButton.isDisposed()) {
            this.fStopButton.setEnabled(enabled);
            if (enabled) {
                this.fToolBar.setFocus();
            }
        }
    }

    private final class CancelListener
    implements Listener {
        private CancelListener() {
        }

        public void handleEvent(Event event) {
            InterruptableProgressMonitor progressMonitor = ForgeProgressMonitorPart.this.dialog.getProgressMonitor();
            if (progressMonitor != null && ForgeProgressMonitorPart.this.dialog.isRunning()) {
                if (progressMonitor.isPreviouslyCancelled()) {
                    ForgeProgressMonitorPart.this.dialog.setErrorMessage("Attempting to force stop...");
                    progressMonitor.setCanceled(true);
                    ForgeProgressMonitorPart.this.setCanceled(true);
                    if (ForgeProgressMonitorPart.this.fStopButton != null) {
                        ForgeProgressMonitorPart.this.fStopButton.setEnabled(false);
                    }
                } else {
                    progressMonitor.setCanceled(true);
                    ForgeProgressMonitorPart.this.dialog.setErrorMessage("Cancel requested: click again to attempt force stop.");
                }
            }
        }
    }
}

