/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.ui.internal.ext.control.many;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.tools.forge.ui.internal.ext.control.ControlBuilder;
import org.jboss.tools.forge.ui.internal.ext.wizards.ForgeWizardPage;

public abstract class AbstractListButtonControl
extends ControlBuilder<Control> {
    @Override
    public Control build(final ForgeWizardPage page, final InputComponent<?, ?> input, String inputName, Composite container) {
        Group group = new Group(container, 32);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)layoutData);
        group.setText(InputComponents.getLabelFor(input, (boolean)false));
        Composite groupPanel = new Composite((Composite)group, 0);
        groupPanel.setLayoutData((Object)new GridData(768));
        groupPanel.setLayout((Layout)new GridLayout(2, false));
        final List containerList = new List(groupPanel, 770);
        GridData gd = new GridData(768);
        containerList.setLayoutData((Object)gd);
        UIInputMany inputMany = (UIInputMany)input;
        ConverterFactory converterFactory = this.getConverterFactory();
        Converter converter = converterFactory.getConverter(input.getValueType(), String.class);
        Iterable value = inputMany.getValue();
        if (value != null) {
            for (Object item : value) {
                String convertedValue = (String)converter.convert(item);
                if (convertedValue == null) continue;
                containerList.add(convertedValue);
            }
        }
        containerList.setToolTipText(input.getDescription());
        Composite buttons = new Composite(groupPanel, 0);
        buttons.setLayout((Layout)new GridLayout(1, true));
        buttons.setLayoutData((Object)new GridData(66));
        Button addButton = new Button(buttons, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText("Add...");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractListButtonControl.this.addButtonPressed(page, input, containerList);
            }
        });
        Button removeButton = new Button(buttons, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText("Remove");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractListButtonControl.this.removeButtonPressed(page, input, containerList);
            }
        });
        group.setData((Object)new Control[]{containerList, addButton, removeButton});
        return group;
    }

    protected abstract void addButtonPressed(ForgeWizardPage var1, InputComponent<?, ?> var2, List var3);

    protected void removeButtonPressed(ForgeWizardPage page, InputComponent<?, ?> input, List containerList) {
        containerList.remove(containerList.getSelectionIndices());
        this.updateItems(input, containerList);
    }

    protected void updateItems(InputComponent<?, ?> input, List containerList) {
        InputComponents.setValueFor((ConverterFactory)this.getConverterFactory(), input, Arrays.asList(containerList.getItems()));
    }

    @Override
    public Control[] getModifiableControlsFor(Control control) {
        return (Control[])control.getData();
    }

    @Override
    protected Class<?>[] getSupportedInputComponentTypes() {
        return new Class[]{UIInputMany.class};
    }
}

