/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.model.ui.internal.editors.PaletteItemResult;
import org.jboss.tools.common.text.IExecutableTextProposal;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizard;

public class RunnablePaletteItem
implements IExecutableTextProposal {
    String category;
    String version;
    String name;
    List<String> alternatives = new ArrayList<String>();

    public RunnablePaletteItem(String category, String version, String name) {
        this.category = category;
        this.version = version;
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAlternatives() {
        return this.alternatives;
    }

    public PaletteItemResult getResult(JSPTextEditor textEditor) {
        return AbstractNewHTMLWidgetWizard.runWithoutUi(textEditor, this.category, this.version, this.name);
    }

    public void apply(ITextEditor textEditor, int startOffset, int endOffset) {
        JSPTextEditor jsp = null;
        if (textEditor instanceof JSPTextEditor) {
            jsp = (JSPTextEditor)textEditor;
        } else if (textEditor instanceof JSPMultiPageEditor) {
            jsp = ((JSPMultiPageEditor)textEditor).getJspEditor();
        } else {
            return;
        }
        IDocument document = jsp.getTextViewer().getDocument();
        try {
            if (endOffset > startOffset) {
                document.replace(startOffset, endOffset - startOffset, "");
            }
        }
        catch (BadLocationException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        catch (StringIndexOutOfBoundsException e) {
            WebUiPlugin.getDefault().logError(e);
        }
        AbstractNewHTMLWidgetWizard.applyWithoutUi(jsp, this);
    }
}

