/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.editors.dnd.DefaultDropWizardPage;
import org.jboss.tools.common.model.ui.editors.dnd.DropCommandFactory;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.IDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizard;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardExtension;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.ui.editors.dnd.ITagProposalFactory;
import org.jboss.tools.common.model.ui.internal.editors.PaletteItemResult;
import org.jboss.tools.common.model.ui.views.palette.PaletteInsertManager;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.LinkAttributeProvider;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPTagProposalFactory;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteDropCommand;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizardPage;
import org.jboss.tools.jst.web.ui.palette.html.wizard.HTMLConstants;
import org.jboss.tools.jst.web.ui.palette.internal.RunnablePaletteItem;
import org.jboss.tools.jst.web.ui.palette.model.PaletteModel;

public class AbstractNewHTMLWidgetWizard
extends Wizard
implements PropertyChangeListener,
IDropWizard,
IDropWizardExtension,
IWorkbenchWizard,
HTMLConstants {
    protected IDropCommand command;
    Set<String> ids = new HashSet<String>();
    protected int leftPanelWidth = -1;
    protected static IElementGenerator.ElementNode SEPARATOR = IElementGenerator.SEPARATOR;
    ElementGenerator g = new ElementGenerator();

    public void initWithoutUI() {
        this.addPages();
        ((AbstractNewHTMLWidgetWizardPage)this.getPages()[0]).createFields();
    }

    public final void addPages() {
        this.doAddPages();
        this.getWizardModel().addPropertyChangeListener((PropertyChangeListener)this);
        this.getWizardModel().setElementGenerator((IElementGenerator)this.g);
    }

    protected void doAddPages() {
    }

    public int getLeftPanelWidth() {
        return this.leftPanelWidth;
    }

    public void setLeftPanelWidth(int w, boolean force) {
        if ((force || this.leftPanelWidth < 0) && w > 0) {
            this.leftPanelWidth = w;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            DefaultDropWizardPage page = (DefaultDropWizardPage)pages[i];
            page.runValidation();
            ++i;
        }
        ((WizardDialog)this.getContainer()).updateButtons();
    }

    public final boolean performFinish() {
        if (this.getContainer() == null) {
            this.doPerformFinish();
            return true;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AbstractNewHTMLWidgetWizard.this.doPerformFinish();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InterruptedException e) {
            WebUiPlugin.getDefault().logError(e);
            return false;
        }
        catch (InvocationTargetException e) {
            WebUiPlugin.getDefault().logError(e.getCause());
            return false;
        }
        return true;
    }

    protected void doPerformFinish() {
        this.command.execute();
    }

    protected String[] generateData() {
        IElementGenerator.ElementNode root = AbstractNewHTMLWidgetWizard.createRoot();
        this.addContent(root);
        IElementGenerator.NodeWriter w = new IElementGenerator.NodeWriter(true);
        root.flush(w, 0);
        String[] result = w.getResult();
        String startText = result[0];
        String endText = result.length < 2 ? "" : result[1];
        return new String[]{startText, endText};
    }

    protected Properties getCommandProperties() {
        return ((PaletteDropCommand)this.command).getProperties();
    }

    protected void addContent(IElementGenerator.ElementNode parent) {
    }

    public String getTextForBrowser() {
        IElementGenerator.ElementNode html = new IElementGenerator.ElementNode("html", false);
        IElementGenerator.ElementNode body = html.addChild("body");
        this.addContent(body);
        IElementGenerator.NodeWriter sb = new IElementGenerator.NodeWriter(false);
        body.flush(sb, 0);
        return sb.getText();
    }

    public String getTextForTextView() {
        IElementGenerator.ElementNode root = AbstractNewHTMLWidgetWizard.createRoot();
        this.addContent(root);
        IElementGenerator.NodeWriter sb = new IElementGenerator.NodeWriter(false);
        root.flush(sb, 0);
        return sb.getText();
    }

    public void setCommand(IDropCommand command) {
        this.command = command;
        this.collectAllIDs();
    }

    public boolean isIDAvailable(String id) {
        return !this.ids.contains(id);
    }

    public IDropWizardModel getWizardModel() {
        return this.command.getDefaultModel();
    }

    public void dispose() {
        this.getWizardModel().removePropertyChangeListener((PropertyChangeListener)this);
        super.dispose();
    }

    protected int generateIndex(String maskPrefix, String maskSuffix, int countFrom) {
        while (this.ids.contains(String.valueOf(maskPrefix) + countFrom + maskSuffix)) {
            ++countFrom;
        }
        return countFrom;
    }

    private void collectAllIDs() {
        String text = this.command.getDefaultModel().getDropData().getSourceViewer().getDocument().get();
        int index = 0;
        while (index >= 0 && index < text.length()) {
            int i1 = this.next(text, "name", index);
            int i2 = this.next(text, "id", index);
            int n = i1 < 0 ? i2 : (i2 < 0 ? i1 : (index = i1 < i2 ? i1 : i2));
            if (index < 0) {
                return;
            }
            this.readValue(text, index);
        }
    }

    public List<LinkAttributeProvider.ElementID> getIDs() {
        IEditorInput input = this.command.getDefaultModel().getDropData().getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file == null) {
            return Collections.emptyList();
        }
        return LinkAttributeProvider.findAllIds((IFile)file, (boolean)false);
    }

    public IFile getFile() {
        IEditorInput input = this.command.getDefaultModel().getDropData().getEditorInput();
        return (IFile)input.getAdapter(IFile.class);
    }

    private int next(String text, String attrName, int from) {
        int i = text.indexOf(attrName, from);
        while (i >= 0) {
            if (i == 0 || Character.isWhitespace(text.charAt(i - 1))) {
                i += attrName.length();
                while (true) {
                    if (i >= text.length()) {
                        return -1;
                    }
                    char ch = text.charAt(i);
                    if (ch == '=') {
                        return i;
                    }
                    if (!Character.isWhitespace(ch)) break;
                    ++i;
                }
            }
            i = text.indexOf(attrName, i + attrName.length());
        }
        return -1;
    }

    private void readValue(String text, int from) {
        int i = text.indexOf("\"", from);
        if (i < 0) {
            return;
        }
        int j = text.indexOf("\"", i + 1);
        if (j < 0) {
            return;
        }
        String value = text.substring(i + 1, j).trim();
        this.ids.add(value);
    }

    public static IElementGenerator.ElementNode createRoot() {
        return IElementGenerator.RootNode.newRoot();
    }

    public static PaletteItemResult runWithoutUi(JSPTextEditor textEditor, String category, String version, String item) {
        XModelObject m = AbstractNewHTMLWidgetWizard.findMacro(category, version, item);
        return m != null ? AbstractNewHTMLWidgetWizard.runPaletteItemWithoutUI(textEditor, m) : null;
    }

    public static void applyWithoutUi(JSPTextEditor textEditor, RunnablePaletteItem item) {
        XModelObject m = AbstractNewHTMLWidgetWizard.findMacro(item.getCategory(), item.getVersion(), item.getName());
        IDropCommand dropCommand = AbstractNewHTMLWidgetWizard.createDropCommand(textEditor, m);
        AbstractNewHTMLWidgetWizard wizard = AbstractNewHTMLWidgetWizard.createWizardWithoutUI(textEditor, m);
        if (wizard != null) {
            wizard.performFinish();
        } else {
            dropCommand.execute();
        }
    }

    private static XModelObject findMacro(String category, String version, String item) {
        XModelObject c = AbstractNewHTMLWidgetWizard.findCategory(category);
        if (c == null) {
            return null;
        }
        XModelObject g = c.getChildByPath(String.valueOf(PaletteModel.VERSION_PREFIX) + version);
        if (g == null) {
            return null;
        }
        return AbstractNewHTMLWidgetWizard.findMacro(g, item);
    }

    private static XModelObject findCategory(String category) {
        XModelObject[] cs;
        XModelObject g = PreferenceModelUtilities.getPreferenceModel().getByPath(PaletteModel.MOBILE_PATH);
        XModelObject[] xModelObjectArray = cs = g.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            String n3 = c.getAttributeValue("name");
            if (category.equals(n3) || n3.endsWith("." + category)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    private static XModelObject findMacro(XModelObject g, String item) {
        XModelObject[] cs = g.getChildren();
        if (cs.length == 0) {
            String n = g.getAttributeValue("name");
            if (item.equals(n) || n.endsWith("." + item)) {
                return g;
            }
        } else {
            XModelObject[] xModelObjectArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject c = xModelObjectArray[n2];
                XModelObject m = AbstractNewHTMLWidgetWizard.findMacro(c, item);
                if (m != null) {
                    return m;
                }
                ++n2;
            }
        }
        return null;
    }

    private static PaletteItemResult runPaletteItemWithoutUI(JSPTextEditor textEditor, XModelObject macro) {
        AbstractNewHTMLWidgetWizard wizard = AbstractNewHTMLWidgetWizard.createWizardWithoutUI(textEditor, macro);
        if (wizard != null) {
            String startText = wizard.getWizardModel().getElementGenerator().generateStartTag();
            String endText = wizard.getWizardModel().getElementGenerator().generateEndTag();
            return new PaletteItemResult(startText, endText);
        }
        String startText = macro.getAttributeValue("start text");
        String endText = macro.getAttributeValue("end text");
        return new PaletteItemResult(startText, endText);
    }

    private static AbstractNewHTMLWidgetWizard createWizardWithoutUI(JSPTextEditor textEditor, XModelObject macro) {
        IDropCommand dropCommand = AbstractNewHTMLWidgetWizard.createDropCommand(textEditor, macro);
        return AbstractNewHTMLWidgetWizard.createWizardWithoutUI(dropCommand, macro);
    }

    private static AbstractNewHTMLWidgetWizard createWizardWithoutUI(IDropCommand dropCommand, XModelObject macro) {
        Properties properties = new Properties();
        properties.setProperty("palettePath", macro.getPath());
        String wizardName = PaletteInsertManager.getInstance().getWizardName(properties);
        if (wizardName != null) {
            AbstractNewHTMLWidgetWizard wizard = (AbstractNewHTMLWidgetWizard)PaletteInsertManager.getInstance().createWizardInstance(properties);
            wizard.setCommand(dropCommand);
            wizard.initWithoutUI();
            return wizard;
        }
        return null;
    }

    private static IDropCommand createDropCommand(JSPTextEditor textEditor, XModelObject macro) {
        Properties p = new Properties();
        p.setProperty("isDrag", "true");
        XActionInvoker.invoke((String)"CopyActions.Copy", (XModelObject)macro, (Properties)p);
        DropData dropData = new DropData("vpe/model", null, textEditor.getEditorInput(), (ISourceViewer)textEditor.getTextViewer(), textEditor.getSelectionProvider());
        dropData.setValueProvider(textEditor.createAttributeDescriptorValueProvider());
        IDropCommand dropCommand = DropCommandFactory.getInstance().getDropCommand("vpe/model", (ITagProposalFactory)JSPTagProposalFactory.getInstance());
        dropCommand.getDefaultModel().setDropData(dropData);
        dropCommand.initialize();
        return dropCommand;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    class ElementGenerator
    implements IElementGenerator {
        String startText;
        String endText;

        ElementGenerator() {
        }

        public String generateStartTag() {
            String[] results = AbstractNewHTMLWidgetWizard.this.generateData();
            this.startText = results[0];
            this.endText = results[1];
            return this.startText;
        }

        public void setDataModel(Object object) {
        }

        public String generateEndTag() {
            return this.endText;
        }
    }
}

