/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryConstants;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewJQueryWidgetWizard;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.NewRangeSliderWizardPage;

public class NewRangeSliderWizard
extends NewJQueryWidgetWizard<NewRangeSliderWizardPage>
implements JQueryConstants {
    public NewRangeSliderWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.RANGE_SLIDER_IMAGE));
    }

    @Override
    protected NewRangeSliderWizardPage createPage() {
        return new NewRangeSliderWizardPage();
    }

    protected boolean isRange() {
        return this.isTrue("range");
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent) {
        String id = ((NewRangeSliderWizardPage)this.page).getEditorValue("id");
        if (this.isRange()) {
            IElementGenerator.ElementNode div = parent.addChild("div");
            div.addAttribute("data-role", "rangeslider");
            this.applyContainerAttributes(div);
            String id1 = id;
            String id2 = id;
            if (id1.length() == 0) {
                id1 = "range-" + this.generateIndex("range-", "a", 1) + "a";
                id2 = "range-" + this.generateIndex("range-", "b", 1) + "b";
            } else {
                id2 = String.valueOf(id1) + this.generateIndex(id1, "", 1);
            }
            IElementGenerator.ElementNode label = div.addChild("label", ((NewRangeSliderWizardPage)this.page).getEditorValue("label"));
            IElementGenerator.ElementNode input = div.addChild("input");
            this.applyAttributes(label, input, id1, "value");
            label = div.addChild("label", ((NewRangeSliderWizardPage)this.page).getEditorValue("label"));
            input = div.addChild("input");
            this.applyAttributes(label, input, id2, "right-value");
        } else {
            if (id.length() == 0) {
                id = "range-" + this.generateIndex("range-", "", 1);
            }
            IElementGenerator.ElementNode label = parent.addChild("label", ((NewRangeSliderWizardPage)this.page).getEditorValue("label"));
            IElementGenerator.ElementNode input = parent.addChild("input");
            this.applyAttributes(label, input, id, "value");
        }
    }

    void applyAttributes(IElementGenerator.ElementNode label, IElementGenerator.ElementNode input, String id, String valueEditorID) {
        label.addAttribute("for", id);
        if (this.isTrue("hide-label")) {
            label.addAttribute("class", "ui-hidden-accessible");
        }
        input.addAttribute("name", id);
        input.addAttribute("id", id);
        if (!this.isRange()) {
            this.applyContainerAttributes(input);
        }
        if (this.isTrue("disabled")) {
            input.addAttribute("disabled", "disabled");
        }
        input.addAttribute("min", ((NewRangeSliderWizardPage)this.page).getEditorValue("min"));
        input.addAttribute("max", ((NewRangeSliderWizardPage)this.page).getEditorValue("max"));
        String step = ((NewRangeSliderWizardPage)this.page).getEditorValue("step");
        if (step.length() > 0) {
            input.addAttribute("step", step);
        }
        input.addAttribute("value", ((NewRangeSliderWizardPage)this.page).getEditorValue(valueEditorID));
        input.addAttribute("type", "range");
    }

    void applyContainerAttributes(IElementGenerator.ElementNode input) {
        String trackThemeValue;
        String themeValue;
        if (this.isMini()) {
            input.addAttribute("data-mini", "true");
        }
        if (this.isTrue("data-highlight")) {
            if (!this.isRange()) {
                input.addAttribute("data-highlight", "true");
            }
        } else if (this.isRange()) {
            input.addAttribute("data-highlight", "false");
        }
        if ((themeValue = ((NewRangeSliderWizardPage)this.page).getEditorValue("theme")).length() > 0) {
            input.addAttribute("data-theme", themeValue);
        }
        if ((trackThemeValue = ((NewRangeSliderWizardPage)this.page).getEditorValue("data-track-theme")).length() > 0) {
            input.addAttribute("data-track-theme", trackThemeValue);
        }
    }

    @Override
    protected void createBodyForBrowser(IElementGenerator.ElementNode body) {
        IElementGenerator.ElementNode form = this.getFormNode(body);
        IElementGenerator.ElementNode div = form.addChild("div");
        div.addAttribute("style", "padding: 20px 20px 20px 20px;");
        this.addContent(div);
    }
}

