/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.palette.html.jquery.wizard;

import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.IDContentProposalProvider;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.ItemsEditor;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.wizard.AbstractNewHTMLWidgetWizardPage;

public class ListEditor
extends ItemsEditor {
    public ListEditor(AbstractNewHTMLWidgetWizardPage page, int minNumber, int maxNumber) {
        super(page, minNumber, maxNumber);
        int i = 0;
        while (i < maxNumber) {
            this.setLabel(i, "Item " + (i + 1));
            this.setURL(i, "item" + (i + 1) + ".html");
            this.items[i].setValue("divider", "false");
            ++i;
        }
    }

    @Override
    protected void createItemEditors() {
        this.addItemEditor(JQueryFieldEditorFactory.createLabelEditor());
        this.addItemEditor(JQueryFieldEditorFactory.createDividerEditor());
        IFieldEditor url = JQueryFieldEditorFactory.createURLEditor();
        this.addItemEditor(url);
        if (this.page.getLeftPanel() != null) {
            new IDContentProposalProvider(this.page.getWizard().getIDs(), url);
        }
    }

    public String getLabel(int i) {
        return this.items[i].getValue("label");
    }

    public void setLabel(int i, String value) {
        this.items[i].setValue("label", value);
    }

    public String getURL(int i) {
        return this.items[i].getValue("url");
    }

    public void setURL(int i, String value) {
        this.items[i].setValue("url", value);
    }

    public boolean isDivider(int i) {
        return "true".equals(this.items[i].getValue("divider"));
    }

    @Override
    public void updateEnablement() {
        IFieldEditor read = this.page.getEditor("readonly");
        IFieldEditor url = this.page.getEditor("url");
        IFieldEditor div = this.page.getEditor("divider");
        if (read != null && url != null && div != null) {
            boolean en = !"true".equals(this.page.getEditorValue("readonly")) && !"true".equals(this.page.getEditorValue("divider"));
            url.setEnabled(en);
        }
    }
}

