/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.text.ext.hyperlink.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.internal.wizards.NewWizardRegistry;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.ui.dialog.CheckboxMessageDialog;
import org.jboss.tools.jst.web.kb.preferences.CreateNewFilePreferences;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;

public class CreateNewFileHyperlink
extends AbstractHyperlink {
    public static final String NEW_CSS_WIZARD_ID = "org.eclipse.wst.css.ui.internal.wizard.NewCSSWizard";
    public static final String NEW_JS_WIZARD_ID = "org.eclipse.wst.jsdt.ui.NewJSWizard";
    public static final String NEW_JSP_WIZARD_ID = "org.eclipse.jst.jsp.ui.internal.wizard.NewJSPWizard";
    public static final String NEW_XHTML_WIZARD_ID = "org.jboss.tools.jst.web.ui.wizards.newfile.NewXHTMLWizard";
    public static final String NEW_HTML_WIZARD_ID = "org.eclipse.wst.html.ui.internal.wizard.NewHTMLWizard";
    public static final int WIZARD_NOT_FOUND = -123;
    private IFile file;
    private String fileName;
    private ArrayList<IFolder> folders = null;

    public CreateNewFileHyperlink(IDocument document, IRegion region, String fileName, IFile file) {
        this.fileName = fileName;
        this.file = file;
        this.setRegion(region);
        this.setDocument(document);
    }

    public IFile getFile() {
        return this.file;
    }

    public String getHyperlinkText() {
        return NLS.bind((String)WebUIMessages.FileDoesNotExistClickToCreate, (Object)this.fileName);
    }

    protected void doHyperlink(IRegion region) {
        this.doHyperlinkInternal(false);
    }

    public void test() {
        this.doHyperlinkInternal(true);
    }

    public static String getWizardID(String fileExtension) {
        if ("css".equals(fileExtension)) {
            return NEW_CSS_WIZARD_ID;
        }
        if ("js".equals(fileExtension)) {
            return NEW_JS_WIZARD_ID;
        }
        if ("jsp".equals(fileExtension)) {
            return NEW_JSP_WIZARD_ID;
        }
        if ("xhtml".equals(fileExtension)) {
            return NEW_XHTML_WIZARD_ID;
        }
        if ("html".equals(fileExtension) || "htm".equals(fileExtension)) {
            return NEW_HTML_WIZARD_ID;
        }
        return null;
    }

    protected void doHyperlinkInternal(boolean test) {
        String wizardId = CreateNewFileHyperlink.getWizardID(this.file.getFileExtension().toLowerCase());
        if (wizardId != null) {
            NewWizardRegistry registry = NewWizardRegistry.getInstance();
            IWizardDescriptor descriptor = registry.findWizard(wizardId);
            if (descriptor == null) {
                ExtensionsPlugin.getDefault().logError(NLS.bind((String)WebUIMessages.WizardNotFound, (Object)wizardId));
                return;
            }
            CheckboxMessageDialog mDialog = new CheckboxMessageDialog(Display.getCurrent().getActiveShell(), WebUIMessages.Question, NLS.bind((String)WebUIMessages.FileDoesNotExistDoYouWantToCreate, (Object)this.fileName), NLS.bind((String)WebUIMessages.UseWizard, (Object)descriptor.getLabel()), CreateNewFilePreferences.isWizardUsed());
            boolean confirm = false;
            boolean runWizard = false;
            if (test) {
                confirm = true;
                runWizard = false;
            } else {
                int result = mDialog.open();
                if (result == 2 || result == 0) {
                    confirm = true;
                }
                boolean bl = runWizard = (result & 2) > 0;
            }
            if (!this.file.exists() && confirm) {
                CreateNewFilePreferences.setWizardUsed((boolean)runWizard);
                this.createFolders();
                if (runWizard) {
                    int returnCode = this.runWizard(descriptor);
                    if (returnCode != 0) {
                        this.deleteFolders();
                    }
                } else {
                    this.createFile();
                    if (!test) {
                        this.openFileInEditor(this.file);
                    }
                }
            }
        } else if (!this.file.exists() && (test || MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)WebUIMessages.Question, (String)NLS.bind((String)WebUIMessages.FileDoesNotExistDoYouWantToCreate, (Object)this.fileName)))) {
            this.createFolders();
            this.createFile();
        }
    }

    private void createFolders() {
        this.folders = new ArrayList();
        IContainer folder = this.file.getParent();
        while (folder instanceof IFolder && !folder.exists()) {
            this.folders.add((IFolder)folder);
            folder = folder.getParent();
        }
        int index = this.folders.size() - 1;
        while (index >= 0) {
            try {
                this.folders.get(index).create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ExtensionsPlugin.getDefault().logError((Throwable)e);
            }
            --index;
        }
    }

    private void deleteFolders() {
        if (this.folders.size() > 0) {
            IFolder folder = this.folders.get(this.folders.size() - 1);
            try {
                folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ExtensionsPlugin.getDefault().logError((Throwable)e);
            }
        }
    }

    private void createFile() {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
            this.file.create((InputStream)stream, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ExtensionsPlugin.getDefault().logError((Throwable)e);
        }
    }

    private int runWizard(IWizardDescriptor descriptor) {
        try {
            IWizardPage[] pages;
            IWorkbenchWizard wizard = descriptor.createWizard();
            StructuredSelection selection = new StructuredSelection((Object)this.file);
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
            WizardDialog wDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
            wDialog.setBlockOnOpen(false);
            wDialog.open();
            IWizardPage[] iWizardPageArray = pages = wizard.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                if (page instanceof WizardNewFileCreationPage) {
                    ((WizardNewFileCreationPage)page).setFileName(this.file.getName());
                }
                ++n2;
            }
            wDialog.setBlockOnOpen(true);
            return wDialog.open();
        }
        catch (CoreException e) {
            ExtensionsPlugin.getDefault().logError((Throwable)e);
            return -1;
        }
    }
}

