/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties.jquery;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.web.html.JQueryHTMLConstants;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileVersion;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.PagePaletteContents;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.AbstractAdvancedPropertySetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.IFieldEditorProvider;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;
import org.jboss.tools.jst.web.ui.internal.properties.jquery.JQueryLayouts;
import org.jboss.tools.jst.web.ui.internal.properties.jquery.JQueryPropertiesFieldEditorFactory;
import org.jboss.tools.jst.web.ui.internal.properties.jquery.JQueryPropertySetContext;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.WizardDescriptions;

public class JQueryPropertySetViewer
extends AbstractAdvancedPropertySetViewer
implements JQueryHTMLConstants {
    JQueryPropertySetContext context = new JQueryPropertySetContext(this);
    JQueryLayouts layouts = new JQueryLayouts(this);

    @Override
    public String getCategoryDisplayName() {
        return "jQuery";
    }

    protected JQueryMobileVersion getVersion() {
        PagePaletteContents contents = (PagePaletteContents)((Object)this.model.getWorkbenchPart().getAdapter(PagePaletteContents.class));
        if (contents != null) {
            String version = contents.getVersion("jQuery Mobile");
            JQueryMobileVersion[] jQueryMobileVersionArray = JQueryMobileVersion.ALL_VERSIONS;
            int n = JQueryMobileVersion.ALL_VERSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                JQueryMobileVersion v = jQueryMobileVersionArray[n2];
                if (v.toString().equals(version)) {
                    return v;
                }
                ++n2;
            }
        }
        return JQueryMobileVersion.getLatestDefaultVersion();
    }

    @Override
    protected boolean isStructureChanged(List<IPropertyDescriptor> descriptors) {
        return this.context.update();
    }

    public JQueryPropertySetContext getContext() {
        return this.context;
    }

    @Override
    protected List<IPropertyDescriptor> getFilteredDescriptors(List<IPropertyDescriptor> descriptors) {
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        for (IPropertyDescriptor d : descriptors) {
            if (this.category == null || !this.category.equals(d.getCategory())) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    protected void layoutEditors(Composite fields, List<AbstractAdvancedPropertySetViewer.Entry> entries) {
        if (this.layouts.isButtonLayout()) {
            this.layouts.layoutButton(fields, entries);
        } else if (this.context.isInput() && "range".equals(this.context.getTypeName())) {
            this.layouts.layoutRange(fields, entries);
        } else if (this.context.isTag("select")) {
            this.layouts.layoutSelect(fields, entries);
        } else if (this.context.isPage()) {
            this.layouts.layoutPage(fields, entries);
        } else if (this.context.isCollapsible() || this.context.isCollapsibleSet()) {
            this.layouts.layoutCollapsible(fields, entries);
        } else if (this.context.isControlGroup()) {
            this.layouts.layoutControlgroup(fields, entries);
        } else if (this.context.isDialog()) {
            this.layouts.layoutDialog(fields, entries);
        } else if (this.context.isListview()) {
            this.layouts.layoutListview(fields, entries);
        } else if (this.context.isPanel()) {
            this.layouts.layoutPanel(fields, entries);
        } else if (this.context.isPopup()) {
            this.layouts.layoutPopup(fields, entries);
        } else if (this.context.isTag("table") && this.context.isTableRole()) {
            this.layouts.layoutTable(fields, entries);
        } else if (this.context.isHeader() || this.context.isFooter()) {
            this.layouts.layoutToolbar(fields, entries);
        } else {
            if (this.hasEditor("data-role")) {
                this.layoutEditor(this.getEditor("data-role"), fields, true);
                if (entries.size() > 1) {
                    LayoutUtil.createSeparator(fields);
                }
            }
            this.layouts.layoutAjaxEnhanceDom(fields, false);
        }
        for (AbstractAdvancedPropertySetViewer.Entry e : entries) {
            if (e.isLayout()) continue;
            this.layoutEditor(e, fields, true);
        }
    }

    @Override
    protected String toVisualValue(String modelValue, IPropertyDescriptor d) {
        if (this.isPositionFixedAttr(d.getId())) {
            return "fixed".equals(modelValue) ? "true" : "false";
        }
        if ("data-direction".equals(d.getId())) {
            return "reverse".equals(modelValue) ? "true" : "false";
        }
        return modelValue;
    }

    @Override
    protected Object toModelValue(Object visualValue, IPropertyDescriptor d) {
        if (this.isPositionFixedAttr(d.getId())) {
            if (visualValue != null && "true".equals(visualValue.toString())) {
                return "fixed";
            }
            return null;
        }
        if ("data-direction".equals(d.getId())) {
            if (visualValue != null && "true".equals(visualValue.toString())) {
                return "reverse";
            }
            return null;
        }
        return visualValue;
    }

    private boolean isPositionFixedAttr(Object id) {
        return "data-position".equals(id) && !this.context.isPanel() || "data-position-fixed".equals(id);
    }

    @Override
    protected void initEditorProviders() {
        this.editorProviders.put("data-add-back-btn", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createAddBackButton();
            }
        });
        this.editorProviders.put("data-ajax", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createAjaxEditor();
            }
        });
        this.editorProviders.put("data-autodividers", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createAutodividersEditor();
            }
        });
        this.editorProviders.put("data-back-btn-text", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createBackButtonTextEditor();
            }
        });
        this.editorProviders.put("data-back-btn-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createBackButtonThemeEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-clear-btn", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createClearInputEditor();
            }
        });
        this.editorProviders.put("data-clear-btn-text", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createClearButtonTextEditor();
            }
        });
        this.editorProviders.put("data-close-btn", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createCloseButtonEditor();
            }
        });
        this.editorProviders.put("data-close-btn-text", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createCloseButtonTextEditor();
            }
        });
        this.editorProviders.put("data-collapsed", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createCollapsedEditor();
            }
        });
        this.editorProviders.put("data-collapsed-icon", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createCollapsedIconEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-column-btn-text", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createColumnButtonTextEditor();
            }
        });
        this.editorProviders.put("data-column-btn-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createColumnButtonThemeEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-column-popup-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createColumnPopupThemeEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-content-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createDataContentThemeEditor();
            }
        });
        this.editorProviders.put("data-corners", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createCornersEditor();
            }
        });
        this.editorProviders.put("data-count-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createThemeEditorForID("data-count-theme");
            }
        });
        this.editorProviders.put("data-direction", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createReverseEditor();
            }
        });
        this.editorProviders.put("data-dismissible", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDismissableEditor("");
            }
        });
        this.editorProviders.put("data-display", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createPanelDisplayEditor();
            }
        });
        this.editorProviders.put("data-divider-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createDividerThemeEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-dom-cache", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDomCacheEditor();
            }
        });
        this.editorProviders.put("data-enhance", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createEnhance();
            }
        });
        this.editorProviders.put("data-expanded-icon", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createExpandedIconEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-filter", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createSearchFilterEditor();
            }
        });
        this.editorProviders.put("data-filter-placeholder", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createFilterPlaceholderEditor();
            }
        });
        this.editorProviders.put("data-filter-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createThemeEditorForID("data-filter-theme");
            }
        });
        this.editorProviders.put("data-fullscreen", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = JQueryPropertySetViewer.this.context.isHeader() ? WizardDescriptions.headerFullScreen : WizardDescriptions.footerFullScreen;
                return JQueryFieldEditorFactory.createFullScreenEditor(description);
            }
        });
        this.editorProviders.put("data-header-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createThemeEditorForID("data-header-theme");
            }
        });
        this.editorProviders.put("data-highlight", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createHighlightEditor();
            }
        });
        this.editorProviders.put("data-icon", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createIconEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-iconpos", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createIconPositionEditor();
            }
        });
        this.editorProviders.put("data-iconshadow", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createIconShadowEditor();
            }
        });
        this.editorProviders.put("data-id", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDataIDEditor();
            }
        });
        this.editorProviders.put("data-inline", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createInlineEditor();
            }
        });
        this.editorProviders.put("data-inset", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = JQueryPropertySetViewer.this.context.isListview() ? WizardDescriptions.listviewInset : WizardDescriptions.collapsibleInset;
                return JQueryFieldEditorFactory.createInsetEditor(description);
            }
        });
        this.editorProviders.put("data-mini", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createMiniEditor();
            }
        });
        this.editorProviders.put("data-mode", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createTableModeEditor();
            }
        });
        this.editorProviders.put("data-native-menu", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createNativeMenuEditor();
            }
        });
        this.editorProviders.put("data-overlay-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createOverlayThemeEditor(JQueryPropertySetViewer.this.getVersion());
            }
        });
        this.editorProviders.put("data-placeholder", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDataPlaceholderEditor();
            }
        });
        this.editorProviders.put("data-position", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                if (JQueryPropertySetViewer.this.context.isPanel()) {
                    return JQueryFieldEditorFactory.createPanelPositionEditor();
                }
                String description = JQueryPropertySetViewer.this.context.isHeader() ? WizardDescriptions.headerFixedPosition : WizardDescriptions.footerFixedPosition;
                return JQueryPropertiesFieldEditorFactory.createFixedPositionEditor(description);
            }
        });
        this.editorProviders.put("data-position-fixed", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createFixedPositionEditor();
            }
        });
        this.editorProviders.put("data-position-to", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createPositionToEditor();
            }
        });
        this.editorProviders.put("data-prefetch", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createPrefetchEditor();
            }
        });
        this.editorProviders.put("data-priority", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createPriorityEditor();
            }
        });
        this.editorProviders.put("data-rel", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createActionEditor();
            }
        });
        this.editorProviders.put("data-role", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDataRoleEditor(JQueryPropertySetViewer.this.context.getElementName());
            }
        });
        this.editorProviders.put("data-shadow", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createShadowEditor();
            }
        });
        this.editorProviders.put("data-split-icon", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createIconEditor(JQueryPropertySetViewer.this.getVersion(), "data-split-icon");
            }
        });
        this.editorProviders.put("data-split-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createThemeEditorForID("data-split-theme");
            }
        });
        this.editorProviders.put("data-swipe-close", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createSwipeCloseEditor();
            }
        });
        this.editorProviders.put("data-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDataThemeEditor(JQueryPropertySetViewer.this.getVersion(), JQueryPropertySetViewer.this.context.getRoleName());
            }
        });
        this.editorProviders.put("data-title", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDataTitleEditor();
            }
        });
        this.editorProviders.put("data-tolerance", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createToleranceEditor();
            }
        });
        this.editorProviders.put("data-track-theme", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryFieldEditorFactory.createDataTrackThemeEditor(JQueryPropertySetViewer.this.getVersion(), WizardDescriptions.rangeSliderTrackTheme);
            }
        });
        this.editorProviders.put("data-transition", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                String description = JQueryPropertySetViewer.this.context.isPopup() ? WizardDescriptions.popupTransition : WizardDescriptions.transition;
                return JQueryPropertiesFieldEditorFactory.createTransitionEditor(description);
            }
        });
        this.editorProviders.put("data-type", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDataTypeEditor();
            }
        });
        this.editorProviders.put("data-url", new IFieldEditorProvider(){

            @Override
            public IFieldEditor createEditor() {
                return JQueryPropertiesFieldEditorFactory.createDataURLEditor();
            }
        });
    }
}

