/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.jboss.tools.jst.web.ui.internal.properties.FormPropertySheetViewer;
import org.jboss.tools.jst.web.ui.internal.properties.IEditedDescriptor;

public class EditedDescriptor
implements IEditedDescriptor {
    IPropertyDescriptor descriptor;
    FormPropertySheetViewer viewer;

    public EditedDescriptor(FormPropertySheetViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void setDescriptor(IPropertyDescriptor descriptor) {
        boolean changed = this.descriptor != descriptor;
        this.descriptor = descriptor;
        if (changed && this.viewer != null) {
            this.viewer.fireSelectedDescriptorChanged();
        }
    }

    @Override
    public IPropertyDescriptor getPropertyDescriptor() {
        return this.descriptor;
    }

    @Override
    public Object getValue() {
        if (this.descriptor != null) {
            return this.viewer.getModel().getPropertySource().getPropertyValue(this.descriptor.getId());
        }
        return null;
    }

    @Override
    public void applyValue(Object newValue) {
        boolean changed;
        Object oldValue = this.getValue();
        boolean bl = oldValue == null ? newValue != null : (changed = !oldValue.equals(newValue));
        if (changed) {
            this.viewer.getModel().valueChanged(this.descriptor, newValue);
            if (this.viewer != null) {
                this.viewer.fireSelectedDescriptorChanged();
            }
        }
    }

    @Override
    public void removeProperty() {
        IPropertySourceExtension se;
        if (this.descriptor == null) {
            return;
        }
        IPropertySource s = this.viewer.getModel().getPropertySource();
        if (s instanceof IPropertySourceExtension && (se = (IPropertySourceExtension)s).isPropertyRemovable(this.descriptor.getId())) {
            se.removeProperty(this.descriptor.getId());
            if (this.viewer != null) {
                this.viewer.fireSelectedDescriptorChanged();
            }
        }
    }
}

