/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.html.text.correction;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.Logger;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.internal.html.preferences.HTMLSyntaxValidationPreferencePage;
import org.jboss.tools.jst.web.ui.internal.html.text.HTMLCoreNewPreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Node;

public class IgnoreElementNameCompletionProposal
implements ICompletionProposal {
    private static final String IMG_DTOOL_DO_NOT_VALIDATE = "icons/donotvalidate.png";
    private static final String IMG_DTOOL_DO_NOT_VALIDATE_DISABLED = "icons/donotvalidate-disabled.png";
    private String fPattern;
    private Node fTarget;
    private String fDisplayString;
    private int fReplacementOffset;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private IPreferencesService fPreferenceService;
    private boolean fHasRequiredAPI;

    public IgnoreElementNameCompletionProposal(String pattern, int offset, String displayString, String additionalProposalInfo, Node target) {
        this.fReplacementOffset = offset;
        this.fPattern = pattern;
        this.fDisplayString = displayString;
        this.fAdditionalProposalInfo = additionalProposalInfo;
        this.fTarget = target;
        this.fPreferenceService = Platform.getPreferencesService();
        this.fHasRequiredAPI = HTMLCoreNewPreferences.hasRequiredAPI();
    }

    public void apply(IDocument document) {
        ProjectScope projectScope;
        Object adapter = this.fTarget instanceof IAdaptable ? ((IAdaptable)this.fTarget).getAdapter(IResource.class) : null;
        IProject project = adapter instanceof IResource ? ((IResource)adapter).getProject() : null;
        IScopeContext[] fLookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        boolean hasProjectSettings = false;
        if (project != null && (projectScope = new ProjectScope(project)).getNode(this.getPreferenceNodeQualifier()).getBoolean(this.getProjectSettingsKey(), false)) {
            hasProjectSettings = true;
            fLookupOrder = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        boolean originalEnableIgnore = this.fPreferenceService.getBoolean(this.getPreferenceNodeQualifier(), "ignoreElementNames", false, fLookupOrder);
        String originalElementNames = this.fPreferenceService.getString(this.getPreferenceNodeQualifier(), "elementNamesToIgnore", "", fLookupOrder);
        if (this.fHasRequiredAPI) {
            StringBuffer ignoreList = new StringBuffer(originalElementNames);
            if (!this.containsPattern(originalElementNames, this.fPattern)) {
                if (ignoreList.length() > 0) {
                    ignoreList.append(',');
                }
                ignoreList.append(this.fPattern);
            }
            fLookupOrder[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("ignoreElementNames", true);
            fLookupOrder[0].getNode(this.getPreferenceNodeQualifier()).put("elementNamesToIgnore", ignoreList.toString());
        }
        PreferenceDialog dialog = hasProjectSettings ? PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)"org.jboss.tools.jst.web.ui.internal.html.ui.propertyPage.project.syntax.validation", null, null) : PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.jboss.tools.jst.web.ui.internal.html.ui.preferences.syntax.validation", null, null);
        int result = 1;
        if (dialog != null) {
            Object page = dialog.getSelectedPage();
            if (page instanceof HTMLSyntaxValidationPreferencePage) {
                ((HTMLSyntaxValidationPreferencePage)((Object)page)).overrideIgnoredElementsOriginValues(originalEnableIgnore, originalElementNames);
            }
            result = dialog.open();
        }
        if (1 == result) {
            fLookupOrder[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("ignoreElementNames", originalEnableIgnore);
            fLookupOrder[0].getNode(this.getPreferenceNodeQualifier()).put("elementNamesToIgnore", originalElementNames);
            int i = 0;
            while (i < fLookupOrder.length) {
                try {
                    fLookupOrder[i].getNode(this.getPreferenceNodeQualifier()).flush();
                }
                catch (BackingStoreException e) {
                    Logger.logException((Throwable)e);
                }
                ++i;
            }
        }
    }

    private boolean containsPattern(String ignoreList, String pattern) {
        HashSet<String> result = new HashSet<String>();
        if (ignoreList.trim().length() > 0) {
            String[] names = ignoreList.split(",");
            int i = 0;
            while (names != null && i < names.length) {
                String name;
                String string = name = names[i] == null ? null : names[i].trim();
                if (name != null && name.length() > 0) {
                    result.add(name.toLowerCase());
                }
                ++i;
            }
        }
        return result.contains(pattern.toLowerCase());
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return "";
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public Image getImage() {
        return this.fHasRequiredAPI ? WebUiPlugin.getDefault().getImage(IMG_DTOOL_DO_NOT_VALIDATE) : WebUiPlugin.getDefault().getImage(IMG_DTOOL_DO_NOT_VALIDATE_DISABLED);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IgnoreElementNameCompletionProposal) {
            IgnoreElementNameCompletionProposal p = (IgnoreElementNameCompletionProposal)obj;
            return this.fPattern.equals(p.fPattern) && this.fTarget == p.fTarget && this.fReplacementOffset == p.fReplacementOffset;
        }
        return false;
    }

    private String getPreferenceNodeQualifier() {
        return HTMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    private String getProjectSettingsKey() {
        return "use-project-settings";
    }

    private Shell getShell() {
        IWorkbench workBench = HTMLUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow workBenchWindow = workBench == null ? null : workBench.getActiveWorkbenchWindow();
        return workBenchWindow == null ? null : workBenchWindow.getShell();
    }
}

