/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.outline;

import java.util.Properties;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.ui.internal.editor.drop.treeviewer.model.ModelElement;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ValueHelper;

class JSPTreeMenuInvoker
implements MouseListener {
    protected TreeViewer viewer;
    protected boolean onKeyRelease = false;
    Properties context;

    JSPTreeMenuInvoker() {
    }

    public void setContext(Properties context) {
        this.context = context;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void setOnKeyRelease(boolean b) {
        this.onKeyRelease = b;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.handleMouseUp(e);
    }

    protected void handleMouseUp(MouseEvent e) {
        if (e.button == 3) {
            String[] actions;
            ModelElement eo = this.getModelObjectAt(new Point(e.x, e.y));
            ModelElement o = this.getSelectedModelObject();
            if (o == null && eo == null) {
                return;
            }
            if (eo != null && o == null) {
                o = eo;
            }
            if ((actions = o.getActions()) == null || actions.length == 0) {
                return;
            }
            Menu menu = this.createMenu(this.viewer.getControl(), o);
            menu.setVisible(true);
        }
    }

    protected XActionList getActionList(XModelObject o) {
        return o.getModelEntity().getActionList();
    }

    public ModelElement getSelectedModelObject() {
        TreeItem[] ti = this.viewer.getTree().getSelection();
        return ti == null || ti.length == 0 ? null : this.getObjectByItem(ti[0]);
    }

    private ModelElement getObjectByItem(TreeItem i) {
        Object data = i.getData();
        if (data instanceof ModelElement) {
            return (ModelElement)data;
        }
        return null;
    }

    public ModelElement getModelObjectAt(Point p) {
        TreeItem i = this.viewer.getTree().getItem(p);
        return i == null ? null : this.getObjectByItem(i);
    }

    private Menu createMenu(Control parent, ModelElement o) {
        String[] actions = o.getActions();
        Menu menu = new Menu(parent);
        int i = 0;
        while (i < actions.length) {
            MenuItem item = new MenuItem(menu, 64);
            item.setText(actions[i]);
            item.setEnabled(true);
            item.addSelectionListener((SelectionListener)new AL(o, actions[i]));
            ++i;
        }
        return menu;
    }

    class AL
    implements SelectionListener {
        ModelElement o;
        String action;

        AL(ModelElement o, String action) {
            this.o = o;
            this.action = action;
        }

        public void widgetSelected(SelectionEvent e) {
            Properties p = new Properties();
            this.o.action(this.action, p);
            JSPTreeMenuInvoker.this.viewer.refresh((Object)this.o);
            Object c = p.get("select");
            if (c != null) {
                ValueHelper valueHelper;
                JSPTreeMenuInvoker.this.viewer.setSelection((ISelection)new StructuredSelection(c), true);
                if (JSPTreeMenuInvoker.this.context != null && (valueHelper = (ValueHelper)JSPTreeMenuInvoker.this.context.get("valueHelper")) != null && valueHelper.getController() != null) {
                    if (valueHelper.getTaglibManager() instanceof IVisualContext) {
                        ((IVisualContext)valueHelper.getTaglibManager()).refreshBundleValues();
                    }
                    valueHelper.getController().refreshExternalLinks();
                    valueHelper.getController().visualRefresh();
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

