/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.taglib.CustomTagLibManager;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.ui.internal.editor.outline.AngularCategoryFilter;
import org.jboss.tools.jst.web.ui.internal.editor.outline.CategoryDescriptor;
import org.jboss.tools.jst.web.ui.internal.editor.outline.ICategoryProvider;
import org.jboss.tools.jst.web.ui.internal.editor.outline.JQueryCategoryFilter;
import org.osgi.framework.Bundle;

public class CategoryProviderFactory {
    private static final CategoryProviderFactory instance = new CategoryProviderFactory();
    private List<CategoryDescriptor> knownDescriptors = new ArrayList<CategoryDescriptor>();

    public static CategoryProviderFactory getInstance() {
        return instance;
    }

    private CategoryProviderFactory() {
        Bundle b = Platform.getBundle((String)"org.jboss.tools.jst.web.ui");
        if (b != null) {
            Class c;
            try {
                c = b.loadClass("org.jboss.tools.jst.web.ui.internal.properties.angular.AngularJSPropertySetViewer");
                this.knownDescriptors.add(new CategoryDescriptor("AngularJS", "angularJS", AngularCategoryFilter.class, c));
            }
            catch (ClassNotFoundException classNotFoundException) {}
            try {
                c = b.loadClass("org.jboss.tools.jst.web.ui.internal.properties.jquery.JQueryPropertySetViewer");
                this.knownDescriptors.add(new CategoryDescriptor("jQuery", "jQueryMobile", JQueryCategoryFilter.class, c));
            }
            catch (ClassNotFoundException classNotFoundException) {}
            try {
                c = b.loadClass("org.jboss.tools.jst.web.ui.internal.properties.html.HTMLPropertySetViewer");
                this.knownDescriptors.add(new CategoryDescriptor("HTML", "htmlFile", c));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    public CategoryDescriptor[] getCategoryDescriptors(IPageContext context) {
        ArrayList<CategoryDescriptor> result = new ArrayList<CategoryDescriptor>();
        for (CategoryDescriptor d : this.knownDescriptors) {
            ICustomTagLibrary l = CategoryProviderFactory.findLibrary(d.getURI());
            if (l == null || l.getRecognizer() == null || !l.getRecognizer().shouldBeLoaded((ITagLibrary)l, (ELContext)context)) continue;
            result.add(d);
        }
        return result.toArray(new CategoryDescriptor[0]);
    }

    static ICustomTagLibrary findLibrary(String uri) {
        ICustomTagLibrary[] iCustomTagLibraryArray = CustomTagLibManager.getInstance().getLibraries();
        int n = iCustomTagLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICustomTagLibrary l = iCustomTagLibraryArray[n2];
            if (uri.equals(l.getURI())) {
                return l;
            }
            ++n2;
        }
        return null;
    }

    @Deprecated
    public ICategoryProvider[] getProviders(IDocument document, KbQuery kbQuery) {
        return new ICategoryProvider[0];
    }
}

