/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editors.dnd.DefaultDropCommand;
import org.jboss.tools.common.model.ui.editors.dnd.DropCommandFactory;
import org.jboss.tools.common.model.ui.editors.dnd.DropData;
import org.jboss.tools.common.model.ui.editors.dnd.ElementGeneratorFactory;
import org.jboss.tools.common.model.ui.editors.dnd.ExternalDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.TagProposal;

public class FileDropCommand
extends DefaultDropCommand {
    IElementGenerator generator;

    public void run(IProgressMonitor monitor) throws CoreException {
        String uri = ((TagProposal)this.getDefaultModel().getTagProposal()).getUri();
        this.generator = this.getDefaultModel().getElementGenerator();
        if (this.generator == null) {
            this.generator = ElementGeneratorFactory.getInstance().getElementGenerator(uri);
            this.generator.setDataModel((Object)this.getDefaultModel());
        }
        Properties properties = new Properties();
        properties.put("tag name", this.getDefaultModel().getTagProposal().getName());
        properties.put("start text", this.generateStartText());
        properties.put("end text", this.generateEndText());
        properties.put("automatically reformat tag body", this.getReformatBodyProperty());
        properties.put("library uri", uri);
        String version = ((TagProposal)this.getDefaultModel().getTagProposal()).getLibraryVersion();
        properties.put("library version", version);
        properties.put("default prefix", this.getDefaultModel().getTagProposal().getPrefix());
        properties.put("selectionProvider", this.getDefaultModel().getDropData().getSelectionProvider());
        properties.put("add taglib", "true");
        this.fillPropertiesForRun(properties);
        this.addCustomProperties(properties);
        JSPPaletteInsertHelper.getInstance().insertIntoEditor(this.getDefaultModel().getDropData().getSourceViewer(), properties);
    }

    protected void fillPropertiesForRun(Properties properties) {
    }

    protected void executeUnknownTag() {
        DropData data = this.getDefaultModel().getDropData();
        String type = data.getMimeType();
        String mime = data.getMimeData();
        if ("application/x-moz-file".equals(type) && mime != null) {
            File f;
            IFile file;
            if (mime.startsWith("file:")) {
                mime = mime.substring(5);
            }
            if ((file = EclipseResourceUtil.getFile((String)(f = new File(mime)).getAbsolutePath())) == null) {
                return;
            }
            XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)file);
            if (o == null) {
                return;
            }
            XActionInvoker.invoke((String)"CopyActions.Copy", (XModelObject)o, null);
            data.setMimeType("vpe/model");
            data.setMimeData("");
            DropCommandFactory.getInstance().getDropCommand("vpe/model", this.tagProposalFactory).execute(data);
        }
    }

    protected void addCustomProperties(Properties properties) {
    }

    protected String getReformatBodyProperty() {
        return "yes";
    }

    protected IDropWizardModel createSpecificModel() {
        return new ExternalDropWizardModel(this.tagProposalFactory);
    }

    protected String generateStartText() {
        return this.generator.generateStartTag();
    }

    protected String generateEndText() {
        return this.generator.generateEndTag();
    }
}

