/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jboss.tools.jst.web.ui.JSTWebUIImages;
import org.jboss.tools.jst.web.ui.internal.css.dialog.CSSClassDialog;
import org.jboss.tools.jst.web.ui.internal.css.messages.CSSUIMessages;
import org.jboss.tools.jst.web.ui.internal.css.wizard.WizardNewCssClassPage;

public class NewCSSClassWizard
extends Wizard
implements INewWizard {
    private CSSClassDescription classDescription = new CSSClassDescription();
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    private NewCSSClassWizardPage editFilePage;
    private WizardNewCssClassPage selectFilePage;

    public NewCSSClassWizard() {
        this.setWindowTitle(CSSUIMessages.WIZARD_WINDOW_TITLE);
        this.setDefaultPageImageDescriptor(JSTWebUIImages.getInstance().getOrCreateImageDescriptor(JSTWebUIImages.CSS_FILE_IMAGE));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        IResource selectedResource = (IResource)selection.getFirstElement();
        if (selectedResource != null) {
            if (selectedResource.getType() == 1 && !"css".equals(selectedResource.getFileExtension())) {
                selectedResource = selectedResource.getParent();
            }
            this.classDescription.setCssFile(selectedResource);
        }
    }

    public void addPages() {
        this.selectFilePage = new WizardNewCssClassPage(this.classDescription);
        this.editFilePage = new NewCSSClassWizardPage();
        this.addPage((IWizardPage)this.selectFilePage);
        this.addPage((IWizardPage)this.editFilePage);
    }

    public boolean performFinish() {
        if (this.editFilePage.dialog != null) {
            this.editFilePage.dialog.save();
            this.editFilePage.dialog.releaseResources();
        }
        return true;
    }

    public boolean canFinish() {
        return this.selectFilePage.canFlipToNextPage() && this.getContainer().getCurrentPage() == this.editFilePage && this.editFilePage.canFinish;
    }

    public boolean performCancel() {
        if (this.editFilePage.dialog != null) {
            this.editFilePage.dialog.releaseResources();
        }
        return true;
    }

    public class CSSClassDescription {
        private IResource cssFile;
        private String cssClassName;

        public IResource getCssFile() {
            return this.cssFile;
        }

        public void setCssFile(IResource cssFile) {
            this.cssFile = cssFile;
        }

        public String getCssClassName() {
            return this.cssClassName;
        }

        public void setCssClassName(String cssClassName) {
            this.cssClassName = cssClassName;
        }
    }

    private class NewCSSClassWizardPage
    extends WizardPage {
        private CSSClassDialog dialog;
        boolean canFinish;

        public NewCSSClassWizardPage() {
            super("newCSSClassWizard");
            this.canFinish = true;
            this.setTitle(CSSUIMessages.WIZARD_TITLE);
            this.setDescription(CSSUIMessages.WIZARD_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            final Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, true));
            GridData gridData = new GridData(4, 4, true, true);
            container.setLayoutData((Object)gridData);
            if (this.getWizard().getContainer() instanceof WizardDialog) {
                WizardDialog wd = (WizardDialog)this.getWizard().getContainer();
                wd.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent event) {
                        if (event.getSelectedPage() == NewCSSClassWizard.this.editFilePage) {
                            if (NewCSSClassWizardPage.this.dialog == null) {
                                NewCSSClassWizardPage.this.dialog = new CSSClassDialog(NewCSSClassWizardPage.this.getShell(), (IFile)NewCSSClassWizard.this.classDescription.getCssFile(), ((NewCSSClassWizardPage)NewCSSClassWizardPage.this).NewCSSClassWizard.this.selection){

                                    @Override
                                    protected void handleStatusChanged(IStatus newStatus) {
                                        if (newStatus.isOK() && !this.getStatus().isOK()) {
                                            NewCSSClassWizardPage.this.setErrorMessage(null);
                                            (this).NewCSSClassWizardPage.this.canFinish = true;
                                        } else if (newStatus.getSeverity() == 4) {
                                            NewCSSClassWizardPage.this.setErrorMessage(newStatus.getMessage());
                                            (this).NewCSSClassWizardPage.this.canFinish = false;
                                        }
                                        if (newStatus.getSeverity() != this.getStatus().getSeverity()) {
                                            if (!this.getApplyButton().isDisposed()) {
                                                this.getApplyButton().setEnabled(newStatus.isOK());
                                            }
                                            if (!this.getClassCombo().isDisposed()) {
                                                this.getClassCombo().setEnabled(newStatus.isOK());
                                            }
                                            if (!this.getAddNewClassButton().isDisposed()) {
                                                this.getAddNewClassButton().setEnabled(newStatus.isOK());
                                            }
                                        }
                                        if (NewCSSClassWizardPage.this.getContainer() != null) {
                                            NewCSSClassWizardPage.this.getContainer().updateButtons();
                                        }
                                        this.setStatus(newStatus);
                                    }
                                };
                                NewCSSClassWizardPage.this.dialog.createControlPane(container);
                                container.layout();
                            } else {
                                NewCSSClassWizardPage.this.dialog.setFile((IFile)NewCSSClassWizard.this.classDescription.getCssFile());
                            }
                            NewCSSClassWizardPage.this.dialog.reinit();
                            NewCSSClassWizardPage.this.dialog.addNewClass(NewCSSClassWizard.this.classDescription.cssClassName);
                        }
                    }
                });
            }
            this.setControl((Control)container);
        }
    }
}

