/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSRuleContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSSelectorUtils;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSStyleSheetContainer;
import org.jboss.tools.jst.web.ui.internal.css.dialog.selector.model.CSSTreeNode;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSSelectorTreeModel {
    private PageContextFactory.CSSStyleSheetDescriptor[] cssSheets;
    private CSSTreeNode invisibleRoot;

    public CSSSelectorTreeModel(PageContextFactory.CSSStyleSheetDescriptor[] cssSheets) {
        this.cssSheets = cssSheets;
        this.setInvisibleRoot(new CSSTreeNode(""));
        this.initModel(this.cssSheets);
    }

    private void initModel(PageContextFactory.CSSStyleSheetDescriptor[] cssStyleSheets) {
        int i = 0;
        while (i < cssStyleSheets.length) {
            CSSStyleSheet styleSheet = cssStyleSheets[i].getStylesheet();
            if (styleSheet != null) {
                CSSTreeNode parentSheet = new CSSTreeNode(cssStyleSheets[i].getSource());
                parentSheet.setStyleSheetSource(parentSheet.toString());
                this.invisibleRoot.addChild(parentSheet);
                parentSheet.setCSSContainer(new CSSStyleSheetContainer(styleSheet, cssStyleSheets[i].getSource()));
                CSSRuleList cssRuleList = styleSheet.getCssRules();
                int j = 0;
                while (j < cssRuleList.getLength()) {
                    CSSRule cssRule = cssRuleList.item(j);
                    if (cssRule.getType() == 1) {
                        String[] selectors = CSSSelectorUtils.parseSelectorName(((ICSSStyleRule)cssRule).getSelectorText());
                        int k = 0;
                        while (k < selectors.length) {
                            CSSTreeNode ruleNode = new CSSTreeNode(selectors[k]);
                            ruleNode.setCSSContainer(new CSSRuleContainer(selectors[k], cssRule, cssStyleSheets[i].getSource()));
                            ruleNode.setStyleSheetSource(cssStyleSheets[i].getSource());
                            parentSheet.addChild(ruleNode);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void setInvisibleRoot(CSSTreeNode invisibleRoot) {
        this.invisibleRoot = invisibleRoot;
    }

    public CSSTreeNode getInvisibleRoot() {
        return this.invisibleRoot;
    }

    public CSSTreeNode[] findCSSNodesByName(String name) {
        ArrayList<CSSTreeNode> treeNodes = new ArrayList<CSSTreeNode>(0);
        this.findCSSNodesRecursivly(this.invisibleRoot, name, treeNodes);
        return treeNodes.toArray(new CSSTreeNode[0]);
    }

    private void findCSSNodesRecursivly(CSSTreeNode parentNode, String name, List<CSSTreeNode> nodeCollection) {
        if (parentNode == null) {
            return;
        }
        List<CSSTreeNode> treeNodes = parentNode.getChildren();
        if (treeNodes == null) {
            return;
        }
        int i = 0;
        while (i < treeNodes.size()) {
            CSSTreeNode node = treeNodes.get(i);
            if (name.equals(node.toString())) {
                nodeCollection.add(node);
            }
            this.findCSSNodesRecursivly(node, name, nodeCollection);
            ++i;
        }
    }
}

