/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.editor.pref.template.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.jboss.tools.jst.web.ui.editor.pref.template.TemplateContextTypeIdsXHTML;
import org.jboss.tools.jst.web.ui.editor.pref.template.contentassist.XHTMLTemplateCompletionProcessor;
import org.w3c.dom.Node;

public class XHTMLTemplateContentAssistComputer
implements ICompletionProposalComputer {
    protected IPreferenceStore fPreferenceStore = null;
    protected boolean isXHTML = false;
    private XHTMLTemplateCompletionProcessor fTemplateProcessor = null;

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<String> fContextTypes = this.getContentTypes(context.getViewer(), context.getInvocationOffset());
        this.addTemplates(context.getViewer(), result, fContextTypes, context.getInvocationOffset());
        return result;
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return new ArrayList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }

    private List<String> getContentTypes(ITextViewer textViewer, int documentPosition) {
        ArrayList<String> fContextTypes = new ArrayList<String>();
        fContextTypes.add(TemplateContextTypeIdsXHTML.ALL);
        IDocument document = textViewer.getDocument();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            Node node = (Node)model.getIndexedRegion(documentPosition);
            if (node == null || node.getNodeType() == 9) {
                fContextTypes.add(TemplateContextTypeIdsXHTML.NEW);
            } else if (node.getNodeType() == 1 || node.getNodeType() == 3) {
                fContextTypes.add(TemplateContextTypeIdsXHTML.ATTRIBUTE);
                fContextTypes.add(TemplateContextTypeIdsXHTML.ATTRIBUTE_VALUE);
                fContextTypes.add(TemplateContextTypeIdsXHTML.TAG);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return fContextTypes;
    }

    private void addTemplates(ITextViewer fTextViewer, List<ICompletionProposal> contentAssistRequest, List<String> fTemplateContexts, int startOffset) {
        if (contentAssistRequest == null) {
            return;
        }
        if (this.getTemplateCompletionProcessor() != null) {
            for (String context : fTemplateContexts) {
                this.getTemplateCompletionProcessor().setContextType(context);
                ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(fTextViewer, startOffset);
                int i = 0;
                while (i < proposals.length) {
                    contentAssistRequest.add(proposals[i]);
                    ++i;
                }
            }
        }
    }

    private XHTMLTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new XHTMLTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }
}

