/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.ui.action;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.quickfix.IQuickFix;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.jst.web.ui.Messages;
import org.jboss.tools.jst.web.ui.WebUiPlugin;
import org.jboss.tools.jst.web.ui.action.JSPProblemMarkerResolutionGenerator;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.PaletteTaglibInserter;

public class AddTLDMarkerResolution
implements IQuickFix {
    private IFile file;
    private String resolutionName;
    private int start;
    private int end;
    private String uri;
    private String prefix;

    public AddTLDMarkerResolution(IFile file, String name, int start, int end, String uri, String prefix) {
        this.file = file;
        this.resolutionName = name;
        this.start = start;
        this.end = end;
        this.uri = uri;
        this.prefix = prefix;
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        properties.put("add taglib", "true");
        properties.put("start text", "");
        properties.put("library uri", this.uri);
        properties.put("default prefix", this.prefix);
        properties.put("force prefix", "true");
        properties.put("selectionProvider", new ISelectionProvider(){

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new TextSelection(AddTLDMarkerResolution.this.start, AddTLDMarkerResolution.this.end - AddTLDMarkerResolution.this.start);
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
        return properties;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.AddTLDMarkerResolution_Name, (Object)this.resolutionName);
    }

    public void run(IMarker marker) {
        if (!JSPProblemMarkerResolutionGenerator.validatePrefix(this.file, this.start, this.prefix)) {
            return;
        }
        if (!JSPProblemMarkerResolutionGenerator.validateURI(this.file, this.start, this.uri)) {
            return;
        }
        FileEditorInput input = new FileEditorInput(this.file);
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)input);
        try {
            provider.connect((Object)input);
            boolean dirty = provider.canSaveDocument((Object)input);
            IDocument document = provider.getDocument((Object)input);
            PaletteTaglibInserter inserter = new PaletteTaglibInserter();
            inserter.inserTaglib(document, this.getProperties());
            if (!dirty) {
                provider.aboutToChange((Object)input);
                provider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)input, document, true);
                provider.changed((Object)input);
            }
            provider.disconnect((Object)input);
        }
        catch (CoreException ex) {
            WebUiPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public String getDescription() {
        return this.getLabel();
    }

    public Image getImage() {
        return CommonUIPlugin.getImageDescriptorRegistry().get(ModelUIImages.getImageDescriptor((String)ModelUIImages.TAGLIB_FILE));
    }

    public void apply(IDocument document) {
        if (!JSPProblemMarkerResolutionGenerator.validatePrefix(this.file, this.start, this.prefix)) {
            return;
        }
        if (!JSPProblemMarkerResolutionGenerator.validateURI(this.file, this.start, this.uri)) {
            return;
        }
        Properties properties = this.getProperties();
        PaletteTaglibInserter.getPrefixes(document, properties);
        PaletteTaglibInserter inserter = new PaletteTaglibInserter();
        inserter.inserTaglib(document, properties);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.getDescription();
    }

    public String getDisplayString() {
        return this.getLabel();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 0;
    }
}

