/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.sourcelookup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputer;
import org.jboss.tools.maven.sourcelookup.SourceLookupActivator;

public class SourcelookupLaunchConfigurationListener
implements ILaunchConfigurationListener {
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        this.updateLaunchConfiguration(configuration);
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    private void updateLaunchConfiguration(ILaunchConfiguration configuration) {
        try {
            if (!SourceLookupActivator.getDefault().isAutoAddSourceContainer()) {
                return;
            }
            if (!SourceLookupActivator.isJBossAsLaunchConfiguration(configuration)) {
                return;
            }
            if (!SourceLookupActivator.m2eExists()) {
                return;
            }
            String sourcePathComputer = configuration.getAttribute(ISourcePathComputer.ATTR_SOURCE_PATH_COMPUTER_ID, null);
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            if (sourcePathComputer == null) {
                wc.setAttribute(ISourcePathComputer.ATTR_SOURCE_PATH_COMPUTER_ID, "org.jboss.tools.maven.sourcelookup.SourcePathComputer");
                wc.doSave();
            }
        }
        catch (CoreException e) {
            SourceLookupActivator.log(e);
        }
    }
}

