/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.commands.WSDL2JavaCommand;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

public class WSDL2JavaHelpOptionCommand
extends WSDL2JavaCommand {
    private String helpOptions;
    private Thread thread;

    public WSDL2JavaHelpOptionCommand(ServiceModel model) {
        super(model);
    }

    @Override
    protected void addCommandlineArgs(List<String> command) {
        command.add("-h");
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String runtimeLocation;
        IStatus status = Status.OK_STATUS;
        IProject project = this.model.getJavaProject().getProject();
        try {
            runtimeLocation = JBossWSCreationUtils.getJBossWSRuntimeLocation(project);
        }
        catch (CoreException e1) {
            return StatusUtils.errorStatus((Throwable)e1);
        }
        String commandLocation = String.valueOf(runtimeLocation) + '/' + "bin";
        Path path = new Path(commandLocation);
        ArrayList<String> command = new ArrayList<String>();
        String[] env = this.getEnvironmentVariables(this.model.getJavaProject());
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            command.add("cmd.exe");
            command.add("/c");
            command.add(this.getCommandLineFileName_win());
            path = path.append(this.getCommandLineFileName_win());
        } else {
            command.add("sh");
            command.add(this.getCommandLineFileName_linux());
            path = path.append(this.getCommandLineFileName_linux());
        }
        if (!path.toFile().getAbsoluteFile().exists()) {
            return StatusUtils.errorStatus((String)NLS.bind((String)JBossWSCreationCoreMessages.Error_Message_Command_File_Not_Found, (Object[])new String[]{path.toOSString()}));
        }
        this.addCommandlineArgs(command);
        Process proc = null;
        try {
            proc = DebugPlugin.exec((String[])command.toArray(new String[command.size()]), (File)new File(commandLocation), (String[])env);
        }
        catch (CoreException e) {
            return StatusUtils.errorStatus((Throwable)e);
        }
        this.convertInputStreamToString(proc.getInputStream());
        return status;
    }

    public void convertInputStreamToString(final InputStream input) {
        final StringBuffer result = new StringBuffer();
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    InputStreamReader ir = new InputStreamReader(input);
                    LineNumberReader reader = new LineNumberReader(ir);
                    String str = reader.readLine();
                    boolean boo = false;
                    while (str != null) {
                        if (!boo && !"options:".equals(str.toLowerCase().trim())) {
                            str = reader.readLine();
                            continue;
                        }
                        if (!boo) {
                            boo = true;
                        }
                        if (JBossWSCreationUtils.isOptions(str)) {
                            str = str.replaceAll(" +", "   ");
                            result.append(str).append("\n");
                        }
                        str = reader.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                WSDL2JavaHelpOptionCommand.this.helpOptions = result.toString();
            }
        };
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    public String getHelpOptions() {
        return this.helpOptions;
    }
}

