/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCorePlugin;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;

public class ValidateWSImplCommand
extends AbstractDataModelOperation {
    private ServiceModel model;

    public ValidateWSImplCommand(ServiceModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block5: {
            String implClass = this.model.getServiceClasses().get(0);
            try {
                IType type = this.model.getJavaProject().findType(implClass);
                if (type != null) {
                    if (!type.getPackageFragment().exists() || type.getPackageFragment().isDefaultPackage()) {
                        return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_No_Package);
                    }
                    if (!type.getAnnotation(JBossWSCreationCoreMessages.Webservice_Annotation).exists() && !type.getAnnotation(JBossWSCreationCoreMessages.Webservice_Annotation_Prefix).exists()) {
                        return StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_No_Annotation);
                    }
                    break block5;
                }
                return StatusUtils.errorStatus((String)NLS.bind((String)JBossWSCreationCoreMessages.Error_No_Class, (Object[])new String[]{implClass, this.model.getJavaProject().getProject().getName()}));
            }
            catch (JavaModelException e) {
                JBossWSCreationCorePlugin.getDefault().logError(e);
                return StatusUtils.errorStatus((String)NLS.bind((String)JBossWSCreationCoreMessages.Error_No_Class, (Object[])new String[]{implClass, this.model.getJavaProject().getProject().getName()}));
            }
        }
        return Status.OK_STATUS;
    }
}

