/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.creation.core.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.JBossWSCreationCorePlugin;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.messages.JBossWSCreationCoreMessages;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;

abstract class AbstractGenerateCodeCommand
extends AbstractDataModelOperation {
    protected ServiceModel model;
    private String cmdFileName_linux;
    private String cmdFileName_win;
    private static String JAVA_HOME = "JAVA_HOME";

    public AbstractGenerateCodeCommand(ServiceModel model) {
        this.model = model;
        this.cmdFileName_linux = this.getCommandLineFileName_linux();
        this.cmdFileName_win = this.getCommandLineFileName_win();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IStatus status;
            block23: {
                String[] env;
                ArrayList<String> command;
                String commandLocation;
                block22: {
                    monitor.beginTask("", 100);
                    monitor.subTask(JBossWSCreationCoreMessages.Progress_Message_Generating);
                    status = Status.OK_STATUS;
                    IProject project = this.model.getJavaProject().getProject();
                    JBossWSCreationCorePlugin.getDefault().setGenerateTime(System.currentTimeMillis());
                    String runtimeLocation = JBossWSCreationUtils.getJBossWSRuntimeLocation(project);
                    commandLocation = String.valueOf(runtimeLocation) + '/' + "bin";
                    Path path = new Path(commandLocation);
                    command = new ArrayList<String>();
                    env = this.getEnvironmentVariables(this.model.getJavaProject());
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                        command.add("cmd.exe");
                        command.add("/c");
                        command.add(this.cmdFileName_win);
                        path = path.append(this.cmdFileName_win);
                    } else {
                        command.add("sh");
                        command.add(this.cmdFileName_linux);
                        path = path.append(this.cmdFileName_linux);
                    }
                    if (path.toFile().getAbsoluteFile().exists()) break block22;
                    IStatus iStatus = StatusUtils.errorStatus((String)NLS.bind((String)JBossWSCreationCoreMessages.Error_Message_Command_File_Not_Found, (Object[])new String[]{path.toOSString()}));
                    return iStatus;
                }
                this.addCommandlineArgs(command);
                this.addCommonArgs(command, this.model.getJavaProject());
                Process proc = DebugPlugin.exec((String[])command.toArray(new String[command.size()]), (File)new File(commandLocation), (String[])env);
                StringBuffer errorResult = new StringBuffer();
                StringBuffer inputResult = new StringBuffer();
                this.convertInputStreamToString(errorResult, proc.getErrorStream());
                this.convertInputStreamToString(inputResult, proc.getInputStream());
                int exitValue = proc.waitFor();
                String resultInput = inputResult.toString();
                if (exitValue != 0) {
                    JBossWSCreationCorePlugin.getDefault().logError(errorResult.toString());
                    JBossWSCreationCorePlugin.getDefault().logError(inputResult.toString());
                    if (resultInput != null && resultInput.indexOf("javac -d") >= 0) {
                        IStatus iStatus = StatusUtils.warningStatus((String)errorResult.toString());
                        return iStatus;
                    }
                    IStatus iStatus = StatusUtils.errorStatus((String)errorResult.toString());
                    return iStatus;
                }
                if (resultInput == null) break block23;
                if (resultInput.indexOf("error:") >= 0 && resultInput.indexOf("compilation failed") < 0) {
                    JBossWSCreationCorePlugin.getDefault().logError(resultInput);
                    IStatus errorStatus = StatusUtils.errorStatus((String)resultInput);
                    IStatus iStatus = status = StatusUtils.errorStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_To_Generate_Code, (Throwable)new CoreException(errorStatus));
                    return iStatus;
                }
                try {
                    if (resultInput.indexOf("[ERROR]") >= 0) {
                        JBossWSCreationCorePlugin.getDefault().logWarning(resultInput);
                        IStatus errorStatus = StatusUtils.warningStatus((String)resultInput);
                        status = StatusUtils.warningStatus((String)JBossWSCreationCoreMessages.Error_Message_Failed_To_Generate_Code, (Throwable)new CoreException(errorStatus));
                    }
                }
                catch (InterruptedException e) {
                    JBossWSCreationCorePlugin.getDefault().logError(e);
                    IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
                    return iStatus;
                }
                catch (CoreException e) {
                    JBossWSCreationCorePlugin.getDefault().logError(e);
                    IStatus iStatus = e.getStatus();
                    return iStatus;
                }
                catch (Exception e) {
                    JBossWSCreationCorePlugin.getDefault().logError(e);
                    IStatus iStatus = StatusUtils.errorStatus((Throwable)e);
                    return iStatus;
                }
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            this.refreshProject(this.model.getJavaProject(), monitor);
            monitor.done();
        }
    }

    protected String[] getEnvironmentVariables(IJavaProject javaProject) {
        String[] env = null;
        String javaHome = System.getenv(JAVA_HOME);
        if (javaHome == null || !new File(javaHome).exists()) {
            if (javaProject == null || !javaProject.exists()) {
                return null;
            }
            try {
                if (!javaProject.isOpen()) {
                    javaProject.open(null);
                }
                IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
                String javaLocation = vm.getInstallLocation().toString();
                env = new String[]{String.valueOf(JAVA_HOME) + "=" + javaLocation};
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        return env;
    }

    protected void addCommonArgs(List<String> command, IJavaProject javaProject) throws Exception {
        String projectRoot = this.model.getJavaProject().getProject().getLocation().toOSString();
        command.add("-k");
        command.add("-s");
        command.add(JBossWSCreationUtils.getCustomSrcLocation(this.model.getJavaSourceFolder()));
        command.add("-o");
        StringBuffer opDir = new StringBuffer();
        opDir.append(projectRoot).append('/').append(javaProject.getOutputLocation().removeFirstSegments(1).toOSString());
        command.add(opDir.toString());
        if (this.model.getAddOptions() != null && !"".equals(this.model.getAddOptions())) {
            String str = this.model.getAddOptions().trim();
            String[] strArray = str.split(" +");
            int i = 0;
            while (i < strArray.length) {
                command.add(strArray[i]);
                ++i;
            }
        }
        if (this.model.getWsdlURI() != null) {
            command.add(this.model.getWsdlURI());
        }
    }

    protected void convertInputStreamToString(final StringBuffer result, final InputStream input) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    InputStreamReader ir = new InputStreamReader(input);
                    LineNumberReader reader = new LineNumberReader(ir);
                    String str = reader.readLine();
                    while (str != null) {
                        result.append(str).append("\t\r");
                        str = reader.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    protected void refreshProject(IJavaProject project, IProgressMonitor monitor) {
        try {
            project.getProject().refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            JBossWSCreationCorePlugin.getDefault().logError(e);
        }
    }

    protected abstract void addCommandlineArgs(List<String> var1) throws Exception;

    protected abstract String getCommandLineFileName_linux();

    protected abstract String getCommandLineFileName_win();
}

