/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.express.client;

import com.openshift.internal.client.utils.StringUtils;

public class ClientSystemProperties {
    public static void setReadTimeoutSeconds(int seconds) {
        ClientSystemProperties.setSystemProperty("com.openshift.httpclient.read.timeout", seconds * 1000);
    }

    public static int getReadTimeoutMillis() {
        return ClientSystemProperties.getSystemProperty("com.openshift.httpclient.read.timeout", 0);
    }

    public static int getReadTimeoutSeconds() {
        return ClientSystemProperties.getReadTimeoutMillis() / 1000;
    }

    private static int getSystemProperty(String name, int defaultValue) {
        return ClientSystemProperties.toInteger(System.getProperty(name), defaultValue);
    }

    private static void setSystemProperty(String name, int value) {
        System.setProperty(name, String.valueOf(value));
    }

    private static int toInteger(String value, int defaultValue) {
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

