/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.taglib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.HTMLTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ICustomTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibRecognizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CustomTagLibManager {
    public static final String FACELETS_UI_TAG_LIB_URI = "http://java.sun.com/jsf/facelets";
    public static final String FACELETS_22_UI_TAG_LIB_URI = "http://xmlns.jcp.org/jsf/facelets";
    public static final String FACELETS_HTML_TAG_LIB_URI = "http://www.w3.org/1999/xhtml/facelets";
    private static final CustomTagLibManager INSTANCE = new CustomTagLibManager();
    private ICustomTagLibrary[] libs = null;
    private CustomTagLibAttribute[] extensions = null;

    private CustomTagLibManager() {
    }

    public static CustomTagLibManager getInstance() {
        return INSTANCE;
    }

    public ICustomTagLibrary[] getLibraries() {
        if (this.libs == null) {
            this.init();
        }
        return this.libs;
    }

    public CustomTagLibAttribute[] getComponentExtensions() {
        if (this.extensions == null) {
            this.init();
        }
        return this.extensions;
    }

    private InputStream getInputStream(String location) {
        try {
            URL url = FileLocator.resolve((URL)new URL(location));
            return url.openConnection().getInputStream();
        }
        catch (IOException ex) {
            WebKbPlugin.getDefault().logError(ex);
            return null;
        }
    }

    private void init() {
        HashSet<ICustomTagLibrary> libSet = new HashSet<ICustomTagLibrary>();
        HashSet<CustomTagLibAttribute> extensionSet = new HashSet<CustomTagLibAttribute>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.jst.web.kb.tagLib");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String elementName = elements[j].getName();
                    String location = elements[j].getAttribute("location");
                    if ("tag-lib".equals(elementName)) {
                        String uri = elements[j].getAttribute("uri");
                        String version = elements[j].getAttribute("version");
                        String name = elements[j].getAttribute("name");
                        String recognizerClassName = elements[j].getAttribute("recognizer");
                        ITagLibRecognizer recognizer = null;
                        if (recognizerClassName != null) {
                            try {
                                Object rec = elements[j].createExecutableExtension("recognizer");
                                if (rec instanceof ITagLibRecognizer) {
                                    recognizer = (ITagLibRecognizer)rec;
                                } else {
                                    WebKbPlugin.getDefault().logError("Custom Tag Lib recognizer (class name: " + recognizerClassName + ", contributer: " + elements[j].getContributor().getName() + ") must implement " + ITagLibRecognizer.class.getName());
                                }
                            }
                            catch (CoreException e) {
                                WebKbPlugin.getDefault().logError(e);
                            }
                        }
                        ICustomTagLibrary lib = null;
                        if (location != null) {
                            InputStream schemaStream = this.getInputStream(location);
                            lib = FACELETS_HTML_TAG_LIB_URI.equals(uri) ? new HTMLTagLibrary(elements[j].getContributor().getName(), schemaStream, uri, version, name) : new CustomTagLibrary(elements[j].getContributor().getName(), schemaStream, uri, version, name);
                        } else {
                            try {
                                Object cls = elements[j].createExecutableExtension("class");
                                if (cls instanceof ICustomTagLibrary) {
                                    lib = (ICustomTagLibrary)cls;
                                } else {
                                    WebKbPlugin.getDefault().logError("Custom Tag Lib (class name: " + cls + " registred in plugin.xml, contributer: " + elements[j].getContributor().getName() + ") must implement " + ICustomTagLibrary.class.getName());
                                }
                            }
                            catch (CoreException e) {
                                WebKbPlugin.getDefault().logError(e);
                            }
                        }
                        if (recognizer != null) {
                            lib.setRecognizer(recognizer);
                        }
                        libSet.add(lib);
                    } else if ("component-extension".equals(elementName)) {
                        InputStream schemaStream = this.getInputStream(location);
                        Document document = null;
                        try {
                            DocumentBuilder builder = CustomTagLibrary.createDocumentBuilder(false);
                            document = builder.parse(schemaStream);
                        }
                        catch (SAXException e) {
                            WebKbPlugin.getDefault().logError(e);
                        }
                        catch (IOException e) {
                            WebKbPlugin.getDefault().logError(e);
                        }
                        catch (ParserConfigurationException e) {
                            WebKbPlugin.getDefault().logError(e);
                        }
                        Element root = document.getDocumentElement();
                        CustomTagLibAttribute[] attributes = CustomTagLibrary.getAttributes(root);
                        int k = 0;
                        while (k < attributes.length) {
                            extensionSet.add(attributes[k]);
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.libs = libSet.toArray(new ICustomTagLibrary[0]);
        this.extensions = extensionSet.toArray(new CustomTagLibAttribute[0]);
    }
}

