/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SearchUtil {
    public static final int JAVA_FILES = 2;
    public static final int XML_FILES = 4;
    public static final int PROPERTY_FILES = 8;
    public static final int EVERYWHERE = 14;
    private static final String JAVA_EXT = "java";
    private static final String XML_EXT = "xml";
    private static final String XHTML_EXT = "xhtml";
    private static final String JSP_EXT = "jsp";
    private static final String PROPERTIES_EXT = "properties";
    private int fileSet;
    private String nodeName = null;
    private String attributeName = null;
    private SearchResult result = null;
    private FileResult lastResult = null;
    private String searchString;

    public SearchUtil(int fileSet, String searchString) {
        this.fileSet = fileSet;
        this.searchString = searchString;
        this.result = new SearchResult();
    }

    private boolean isSearchInJavaFiles() {
        return (this.fileSet & 2) != 0;
    }

    private boolean isSearchInXMLFiles() {
        return (this.fileSet & 4) != 0;
    }

    private boolean isSearchInPropertyFiles() {
        return (this.fileSet & 8) != 0;
    }

    public SearchResult searchInNodeAttribute(IProject project, String nodeName, String attributeName) {
        this.nodeName = nodeName;
        this.attributeName = attributeName;
        return this.search(project);
    }

    public SearchResult search(IProject project) {
        IJavaProject javaProject;
        if (this.isSearchInJavaFiles() && (javaProject = EclipseResourceUtil.getJavaProject((IProject)project)) != null) {
            IResource[] iResourceArray = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    this.scanForJava((IContainer)((IFolder)resource));
                } else if (resource instanceof IFile) {
                    this.scanForJava((IFile)resource);
                }
                ++n2;
            }
        }
        if (this.isSearchInXMLFiles()) {
            if (this.getViewFolder(project) != null) {
                this.scan(this.getViewFolder(project));
            } else {
                this.scan((IContainer)project);
            }
        }
        return this.result;
    }

    protected IContainer getViewFolder(IProject project) {
        IPath path = ProjectHome.getFirstWebContentPath((IProject)project);
        if (path != null) {
            return path.segmentCount() > 1 ? project.getFolder(path.removeFirstSegments(1)) : project;
        }
        return null;
    }

    private boolean isFileCorrect(IFile file) {
        if (!file.isSynchronized(0)) {
            return false;
        }
        if (file.isPhantom()) {
            return false;
        }
        return !file.isReadOnly();
    }

    private void scan(IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    this.scan((IContainer)((IFolder)resource));
                } else if (resource instanceof IFile) {
                    this.scan((IFile)resource);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            ELCorePlugin.getDefault().logError((Throwable)ex);
        }
    }

    private void scanForJava(IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    this.scanForJava((IContainer)((IFolder)resource));
                } else if (resource instanceof IFile) {
                    this.scanForJava((IFile)resource);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            ELCorePlugin.getDefault().logError((Throwable)ex);
        }
    }

    private void scan(IFile file) {
        if (this.isFileCorrect(file)) {
            String fileContent = null;
            try {
                fileContent = FileUtil.readStream((IFile)file);
            }
            catch (CoreException e) {
                ELCorePlugin.getDefault().logError((Throwable)e);
            }
            String ext = file.getFileExtension();
            if (XHTML_EXT.equalsIgnoreCase(ext) || JSP_EXT.equalsIgnoreCase(ext)) {
                this.scanInDOM(file, fileContent);
            }
        }
    }

    private void scanForJava(IFile file) {
        if (this.isFileCorrect(file)) {
            String fileContent = null;
            try {
                fileContent = FileUtil.readStream((IFile)file);
            }
            catch (CoreException e) {
                ELCorePlugin.getDefault().logError((Throwable)e);
            }
            String ext = file.getFileExtension();
            if (JAVA_EXT.equalsIgnoreCase(ext)) {
                this.scanInJava(file, fileContent);
            }
        }
    }

    private boolean scanInDOM(IFile file, String content) {
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return false;
        }
        IStructuredModel model = null;
        try {
            model = manager.getModelForRead(file);
            if (model instanceof IDOMModel) {
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                boolean bl = this.scanChildNodes(file, (Node)document);
                return bl;
            }
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        catch (IOException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    private boolean scanChildNodes(IFile file, Node parent) {
        boolean status = false;
        if (parent == null) {
            return false;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node curentValidatedNode = children.item(i);
            if (1 == curentValidatedNode.getNodeType()) {
                if (this.nodeName == null || curentValidatedNode.getNodeName().endsWith(this.nodeName)) {
                    status = this.scanNodeContent(file, ((IDOMNode)curentValidatedNode).getFirstStructuredDocumentRegion(), "XML_TAG_ATTRIBUTE_VALUE");
                }
                if (status) {
                    return status;
                }
            }
            if (status = this.scanChildNodes(file, curentValidatedNode)) {
                return status;
            }
            ++i;
        }
        return false;
    }

    private boolean scanInJava(IFile file, String content) {
        try {
            FastJavaPartitionScanner scaner = new FastJavaPartitionScanner();
            Document document = new Document(content);
            scaner.setRange((IDocument)document, 0, document.getLength());
            IToken token = scaner.nextToken();
            while (token != null && token != Token.EOF) {
                if ("__java_string".equals(token.getData())) {
                    int length = scaner.getTokenLength();
                    int offset = scaner.getTokenOffset();
                    String value = document.get(offset, length);
                    if (this.searchString.equals(value)) {
                        if (this.lastResult == null || !this.lastResult.getFile().equals((Object)file)) {
                            this.lastResult = new FileResult(file);
                            this.result.getEntries().add(this.lastResult);
                        }
                        this.lastResult.addPosition(length);
                    }
                }
                token = scaner.nextToken();
            }
        }
        catch (BadLocationException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return false;
    }

    private boolean scanNodeContent(IFile file, IStructuredDocumentRegion node, String regionType) {
        if (node == null) {
            return false;
        }
        ITextRegionList regions = node.getRegions();
        int i = 0;
        while (i < regions.size()) {
            String tempSearchString = this.searchString;
            int delta = 0;
            ITextRegion region = regions.get(i);
            if (region.getType() == regionType) {
                String text = node.getFullText(region);
                if (text.startsWith("\"")) {
                    tempSearchString = "\"" + tempSearchString;
                    delta = 1;
                }
                if (text.startsWith(tempSearchString)) {
                    if (this.lastResult == null || !this.lastResult.getFile().equals((Object)file)) {
                        this.lastResult = new FileResult(file);
                        this.result.getEntries().add(this.lastResult);
                    }
                    this.lastResult.addPosition(node.getStartOffset() + region.getStart() + delta);
                }
            }
            ++i;
        }
        return false;
    }

    public class FileResult {
        private IFile file;
        private List<Integer> positions;

        public FileResult(IFile file) {
            this.file = file;
            this.positions = new ArrayList<Integer>();
        }

        public void addPosition(int position) {
            this.positions.add(new Integer(position));
        }

        public IFile getFile() {
            return this.file;
        }

        public int[] getPositions() {
            this.positions.toArray(new Integer[this.positions.size()]);
            int[] intArray = new int[this.positions.size()];
            int index = 0;
            for (Integer position : this.positions) {
                intArray[index++] = position;
            }
            return intArray;
        }
    }

    public class SearchResult {
        private List<FileResult> entries = new ArrayList<FileResult>();

        public List<FileResult> getEntries() {
            return this.entries;
        }
    }
}

