/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.jboss.tools.common.validation.ValidationSeverityPreferences;

public class ELSeverityPreferences
extends ValidationSeverityPreferences {
    public static final Set<String> SEVERITY_OPTION_NAMES = new HashSet<String>();
    private static ELSeverityPreferences INSTANCE = new ELSeverityPreferences();
    public static final String WARNING_GROUP_ID = "el";
    public static final String UNKNOWN_EL_VARIABLE_NAME = INSTANCE.createSeverityOption("unknownElVariableName", new String[]{"unresolved"});
    public static final String CHECK_VARS = INSTANCE.createSeverityOption("checkVars");
    public static final String RE_VALIDATE_UNRESOLVED_EL = INSTANCE.createSeverityOption("revalidateUnresolvedEl");
    public static final String UNKNOWN_EL_VARIABLE_PROPERTY_NAME = INSTANCE.createSeverityOption("unknownElVariablePropertyName", new String[]{"unresolved"});
    public static final String UNPAIRED_GETTER_OR_SETTER = INSTANCE.createSeverityOption("unpairedGetterOrSetter", new String[]{"unresolved"});
    public static final String EL_SYNTAX_ERROR = INSTANCE.createSeverityOption("elSyntaxError", new String[]{"syntax"});
    public static final String NON_EXTERNALIZED_STRINGS = INSTANCE.createSeverityOption("nonExternalizedString");

    public static ELSeverityPreferences getInstance() {
        return INSTANCE;
    }

    private ELSeverityPreferences() {
    }

    public String getWarningGroupID() {
        return WARNING_GROUP_ID;
    }

    protected String createSeverityOption(String shortName) {
        String name = String.valueOf(this.getPluginId()) + ".validator.problem." + shortName;
        SEVERITY_OPTION_NAMES.add(name);
        return name;
    }

    protected String getPluginId() {
        return "org.jboss.tools.jst.web.kb";
    }

    protected Set<String> getSeverityOptionNames() {
        return SEVERITY_OPTION_NAMES;
    }

    public static boolean isValidationEnabled(IProject project) {
        return INSTANCE.isEnabled(project);
    }

    public static int getMaxNumberOfProblemMarkersPerFile(IProject project) {
        return INSTANCE.getMaxNumberOfProblemMarkersPerResource(project);
    }

    public static boolean shouldValidateEL(IProject project) {
        return !"ignore".equals(INSTANCE.getProjectPreference(project, UNKNOWN_EL_VARIABLE_NAME)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNKNOWN_EL_VARIABLE_PROPERTY_NAME)) || !"ignore".equals(INSTANCE.getProjectPreference(project, EL_SYNTAX_ERROR)) || !"ignore".equals(INSTANCE.getProjectPreference(project, UNPAIRED_GETTER_OR_SETTER));
    }
}

