/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibrary;
import org.jboss.tools.jst.web.kb.internal.taglib.HTMLTag;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HTMLTagLibrary
extends CustomTagLibrary {
    private static final List<String> EMPTY_PREFIXES = new ArrayList<String>();

    public HTMLTagLibrary(String contributerName, InputStream inputStream, String uri, String version, String name) {
        super(contributerName, inputStream, uri, version, name);
    }

    @Override
    protected IComponent[] getComponents(KbQuery query, String prefix, IPageContext context) {
        String[] parentTags = query.getParentTags();
        String parentHtmlTagName = null;
        if (parentTags != null && parentTags.length > 0) {
            int i = parentTags.length - 1;
            while (i >= 0) {
                if (parentTags[i].indexOf(58) < 0) {
                    parentHtmlTagName = parentTags[i];
                    break;
                }
                --i;
            }
        }
        IComponent[] components = super.getComponents(query, prefix, context);
        if (parentHtmlTagName == null) {
            return components;
        }
        IComponent parentComponent = this.getComponent(parentHtmlTagName.toLowerCase());
        if (parentComponent == null) {
            return components;
        }
        ArrayList<IComponent> result = new ArrayList<IComponent>();
        HTMLTag parentHtmlTag = (HTMLTag)parentComponent;
        Set<String> allowedChildTags = parentHtmlTag.getChildTags();
        IComponent[] iComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponent component = iComponentArray[n2];
            if (allowedChildTags.contains(component.getName())) {
                result.add(component);
            }
            ++n2;
        }
        return result.toArray(new IComponent[0]);
    }

    @Override
    protected List<String> getPrefixes(KbQuery query, IPageContext context) {
        List<INameSpace> nameSpace;
        Map<String, List<INameSpace>> nameSpaces = context.getNameSpaces(query.getOffset());
        if (nameSpaces != null && (nameSpace = nameSpaces.get(this.getURI())) != null) {
            for (INameSpace n : nameSpace) {
                String sPrefix = n.getPrefix();
                if (!"".equals(sPrefix)) continue;
                return null;
            }
        }
        return EMPTY_PREFIXES;
    }

    @Override
    protected CustomTagLibComponent parseComponent(Element component) {
        HTMLTag tag = (HTMLTag)super.parseComponent(component);
        NodeList components = component.getElementsByTagName("component");
        int i = 0;
        while (i < components.getLength()) {
            Element child = (Element)components.item(i);
            String name = child.getAttribute("name");
            tag.addChildTagName(name.toLowerCase());
            ++i;
        }
        return tag;
    }

    @Override
    protected CustomTagLibComponent createComponent() {
        return new HTMLTag();
    }
}

