/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.internal.taglib.AbstractComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomComponentExtension;
import org.jboss.tools.jst.web.kb.internal.taglib.FaceletTag;
import org.jboss.tools.jst.web.kb.internal.taglib.FacesConfigComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.TLDTag;
import org.jboss.tools.jst.web.kb.internal.taglib.composite.CompositeComponent;
import org.jboss.tools.jst.web.kb.internal.taglib.myfaces.MyFacesComponent;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.w3c.dom.Element;

public abstract class AbstractTagLib
extends KbObject
implements ITagLibrary {
    public static String URI = "uri";
    protected INameSpace nameSpace;
    protected String uri;
    protected String version;
    protected boolean hasExtendedComponents = false;
    private Map<String, IComponent> components = new HashMap<String, IComponent>();
    private IComponent[] componentsArray;
    protected Set<CustomComponentExtension> componentExtensions;
    protected boolean ignoreCase;
    private static final IComponent[] EMPTY_ARRAY = new IComponent[0];

    @Override
    public IComponent[] getComponents() {
        return this.getDeclaredComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IComponent[] getDeclaredComponents() {
        if (this.componentsArray == null) {
            Map<String, IComponent> map = this.components;
            synchronized (map) {
                this.componentsArray = this.components.values().toArray(new IComponent[this.components.size()]);
            }
        }
        return this.componentsArray;
    }

    @Override
    public IComponent getComponent(String name) {
        if (this.ignoreCase) {
            name = name.toLowerCase();
        }
        return this.components.get(name);
    }

    @Override
    public IComponent getComponentByType(String type) {
        IComponent[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (type.equals(comps[i].getComponentType())) {
                return comps[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public IComponent[] getComponents(String nameTemplate) {
        return this.getComponents(nameTemplate, null);
    }

    public IComponent[] getComponents(String nameTemplate, IPageContext context) {
        ArrayList<IComponent> list = new ArrayList<IComponent>();
        IComponent[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i].getName() != null) {
                if (this.ignoreCase) {
                    if (!(comps[i] instanceof CustomComponentExtension) && comps[i].getName().toLowerCase().startsWith(nameTemplate.toLowerCase()) && (context == null || this.checkExtended(comps[i], context))) {
                        list.add(comps[i]);
                    }
                } else if (!(comps[i] instanceof CustomComponentExtension) && comps[i].getName().startsWith(nameTemplate) && (context == null || this.checkExtended(comps[i], context))) {
                    list.add(comps[i]);
                }
            }
            ++i;
        }
        return list.toArray(new IComponent[list.size()]);
    }

    @Override
    public IComponent[] getComponents(KbQuery query, IPageContext context) {
        List<String> prefixes = this.getPrefixes(query, context);
        return this.getComponentsByPrefixes(query, prefixes, context);
    }

    protected List<String> getPrefixes(KbQuery query, IPageContext context) {
        List<INameSpace> nameSpace;
        ArrayList<String> prefixes = new ArrayList<String>();
        Map<String, List<INameSpace>> nameSpaces = context.getNameSpaces(query.getOffset());
        if (nameSpaces != null && (nameSpace = nameSpaces.get(this.getURI())) != null) {
            for (INameSpace n : nameSpace) {
                String sPrefix = n.getPrefix();
                if (sPrefix == null) continue;
                String fullTagName = null;
                boolean mask = false;
                if (query.getType() == KbQuery.Type.TAG_NAME || query.getType() == KbQuery.Type.TEXT) {
                    fullTagName = query.getValue();
                    mask = query.isMask();
                } else {
                    fullTagName = query.getLastParentTag();
                }
                if (fullTagName == null) {
                    prefixes.add(sPrefix);
                    continue;
                }
                String tagName = fullTagName;
                int prefixIndex = fullTagName.indexOf(58);
                String queryPrefix = null;
                if (prefixIndex > -1) {
                    queryPrefix = fullTagName.substring(0, prefixIndex);
                    tagName = prefixIndex < fullTagName.length() - 1 ? fullTagName.substring(prefixIndex + 1) : null;
                }
                if (mask && prefixIndex < 0) {
                    if (this.ignoreCase) {
                        if (!fullTagName.toLowerCase().startsWith(tagName.toLowerCase())) continue;
                        prefixes.add(sPrefix);
                        continue;
                    }
                    if (!fullTagName.startsWith(tagName)) continue;
                    prefixes.add(sPrefix);
                    continue;
                }
                if (!sPrefix.equals(queryPrefix)) continue;
                prefixes.add(sPrefix);
            }
        }
        return prefixes;
    }

    protected IComponent[] getComponentsByPrefixes(KbQuery query, List<String> prefixes, IPageContext context) {
        if (prefixes == null || prefixes.isEmpty()) {
            return this.getComponents(query, null, context);
        }
        if (prefixes.size() == 1) {
            return this.getComponents(query, prefixes.get(0), context);
        }
        ArrayList<IComponent> components = new ArrayList<IComponent>();
        for (String prefix : prefixes) {
            IComponent[] cps;
            IComponent[] iComponentArray = cps = this.getComponents(query, prefix, context);
            int n = cps.length;
            int n2 = 0;
            while (n2 < n) {
                IComponent c = iComponentArray[n2];
                components.add(c);
                ++n2;
            }
        }
        return components.toArray(new IComponent[0]);
    }

    protected IComponent[] getComponents(KbQuery query, String prefix, IPageContext context) {
        String fullTagName = null;
        boolean mask = false;
        if (query.getType() == KbQuery.Type.TAG_NAME || query.getType() == KbQuery.Type.TEXT) {
            fullTagName = query.getValue();
            mask = query.isMask();
        } else {
            fullTagName = query.getLastParentTag();
        }
        if (fullTagName == null) {
            return EMPTY_ARRAY;
        }
        if (mask) {
            if (fullTagName.length() == 0) {
                return this.getExtendedComponents(context);
            }
            if (prefix == null || prefix.length() == 0) {
                return this.getComponents(fullTagName, context);
            }
        }
        String tagName = fullTagName;
        int prefixIndex = fullTagName.indexOf(58);
        String queryPrefix = null;
        if (prefix != null && prefixIndex > -1) {
            queryPrefix = fullTagName.substring(0, prefixIndex);
            tagName = prefixIndex < fullTagName.length() - 1 ? fullTagName.substring(prefixIndex + 1) : null;
        }
        if (mask) {
            if (prefixIndex < 0) {
                if (this.ignoreCase ? prefix.toLowerCase().startsWith(tagName.toLowerCase()) : prefix.startsWith(tagName)) {
                    return this.getExtendedComponents(context);
                }
                return EMPTY_ARRAY;
            }
            if (prefix.equals(queryPrefix)) {
                if (tagName == null) {
                    return this.getExtendedComponents(context);
                }
                return this.getComponents(tagName, context);
            }
            return EMPTY_ARRAY;
        }
        IComponent comp = this.getComponent(tagName);
        ArrayList<IComponent> result = new ArrayList<IComponent>();
        if (comp != null && this.checkExtended(comp, context)) {
            result.add(comp);
        }
        if (this.componentExtensions != null) {
            result.addAll(this.componentExtensions);
        }
        return result.isEmpty() ? EMPTY_ARRAY : result.toArray(new IComponent[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IComponent[] getExtendedComponents(IPageContext context) {
        if (this.hasExtendedComponents) {
            HashSet<IComponent> comps = new HashSet<IComponent>();
            Map<String, IComponent> map = this.components;
            synchronized (map) {
                for (IComponent component : this.components.values()) {
                    if (!this.checkExtended(component, context)) continue;
                    comps.add(component);
                }
            }
            return comps.toArray(new IComponent[0]);
        }
        return this.getComponents();
    }

    protected boolean checkExtended(IComponent component, IPageContext context) {
        if (!component.isExtended() || component instanceof CustomComponentExtension) {
            return true;
        }
        ITagLibrary[] libs = context.getLibraries();
        int i = 0;
        while (i < libs.length) {
            IComponent ac;
            if (libs[i] != this && libs[i].getURI().equals(this.uri) && (ac = libs[i].getComponent(component.getName())) != null && !ac.isExtended()) {
                String d = ac.getDescription();
                if (d != null && component instanceof AbstractComponent) {
                    ((AbstractComponent)component).setDescription(d);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addComponent(IComponent component) {
        this.adopt((KbObject)((Object)component));
        this.components.put(component.getName(), component);
        this.componentsArray = null;
        if (component.isExtended()) {
            this.hasExtendedComponents = true;
        }
    }

    protected void setComponents(Map<String, IComponent> components) {
        this.components = components;
        for (IComponent component : components.values()) {
            if (!component.isExtended()) continue;
            this.hasExtendedComponents = true;
            break;
        }
        this.componentsArray = null;
    }

    @Override
    public IPath getSourcePath() {
        return this.source;
    }

    @Override
    public void setSourcePath(IPath source) {
        this.source = source;
    }

    @Override
    public IResource getResource() {
        if (this.resource != null) {
            return this.resource;
        }
        if (this.source != null) {
            this.resource = ResourcesPlugin.getWorkspace().getRoot().getFile(this.source);
        }
        return this.resource;
    }

    public void setResource(IFile resource) {
        this.resource = resource;
    }

    @Override
    public INameSpace getDefaultNameSpace() {
        return this.nameSpace;
    }

    public void setDefaultNameSpace(INameSpace nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setURI(IValueInfo s) {
        this.uri = s == null ? null : s.getValue();
        this.attributesInfo.put(URI, s);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public TextProposal[] getProposals(KbQuery query, IPageContext context) {
        List<String> prefixes = this.getPrefixes(query, context);
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        IComponent[] components = this.getComponentsByPrefixes(query, prefixes, context);
        if (query.getType() == KbQuery.Type.TAG_NAME || query.getType() == KbQuery.Type.TEXT) {
            int i = 0;
            while (i < components.length) {
                if (!(components[i] instanceof CustomComponentExtension)) {
                    if (prefixes == null) {
                        proposals.add(this.getProposal(null, components[i]));
                    } else {
                        for (String prefix : prefixes) {
                            proposals.add(this.getProposal(prefix, components[i]));
                        }
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < components.length) {
                TextProposal[] componentProposals = components[i].getProposals(query, context);
                int j = 0;
                while (j < componentProposals.length) {
                    proposals.add(componentProposals[j]);
                    ++j;
                }
                ++i;
            }
        }
        return proposals.toArray(new TextProposal[proposals.size()]);
    }

    protected TextProposal getProposal(String prefix, IComponent component) {
        TextProposal proposal = new TextProposal();
        proposal.setContextInfo(component.getDescription());
        proposal.setSource((Object)component);
        StringBuffer label = new StringBuffer("<");
        if (prefix != null && prefix.length() > 0) {
            label.append(String.valueOf(prefix) + ":");
        }
        label.append(component.getName());
        proposal.setLabel(label.toString());
        IAttribute[] attributes = component.getPreferableAttributes();
        StringBuffer attributeSB = new StringBuffer();
        int j = 0;
        while (j < attributes.length) {
            attributeSB.append(" ").append(attributes[j].getName()).append("=\"\"");
            ++j;
        }
        label.append(attributeSB);
        if (!component.canHaveBody()) {
            label.append(" /");
        }
        label.append(">");
        proposal.setReplacementString(label.toString());
        int position = proposal.getReplacementString().indexOf(34);
        position = position != -1 ? ++position : proposal.getReplacementString().length();
        proposal.setPosition(position);
        return proposal;
    }

    @Override
    public AbstractTagLib clone() throws CloneNotSupportedException {
        AbstractTagLib t = (AbstractTagLib)super.clone();
        t.components = new HashMap<String, IComponent>();
        for (IComponent c : this.components.values()) {
            if (c.isExtended()) {
                t.hasExtendedComponents = true;
            }
            t.addComponent(((AbstractComponent)c).clone());
        }
        return t;
    }

    @Override
    public List<Change> merge(KbObject s) {
        List changes = super.merge(s);
        AbstractTagLib t = (AbstractTagLib)s;
        Change children = new Change((Object)this, null, null, null);
        if (!this.stringsEqual(this.uri, t.uri)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, URI, (Object)this.uri, (Object)t.uri));
            this.uri = t.uri;
        }
        if (!this.stringsEqual(this.version, t.version)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "version", (Object)this.version, (Object)t.version));
            this.version = t.version;
        }
        this.mergeComponents(t, children);
        changes = Change.addChange((List)changes, (Change)children);
        return changes;
    }

    public void mergeComponents(AbstractTagLib c, Change children) {
        IComponent a2;
        HashMap<Object, AbstractComponent> componentMap = new HashMap<Object, AbstractComponent>();
        IComponent[] iComponentArray = this.getDeclaredComponents();
        int n = iComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            a2 = iComponentArray[n2];
            componentMap.put(((KbObject)((Object)a2)).getId(), (AbstractComponent)a2);
            ++n2;
        }
        iComponentArray = c.getDeclaredComponents();
        n = iComponentArray.length;
        n2 = 0;
        while (n2 < n) {
            a2 = iComponentArray[n2];
            AbstractComponent loaded = (AbstractComponent)a2;
            AbstractComponent current = (AbstractComponent)componentMap.remove(loaded.getId());
            if (current == null) {
                this.addComponent(loaded);
                Change change = new Change((Object)this, null, null, (Object)loaded);
                children.addChildren(Change.addChange(null, (Change)change));
            } else {
                List<Change> rc;
                if (this.components.get(current.getName()) == current) {
                    this.components.remove(current.getName());
                }
                if ((rc = current.merge(loaded)) != null) {
                    children.addChildren(rc);
                }
                this.components.put(current.getName(), current);
            }
            ++n2;
        }
        for (IComponent a2 : componentMap.values()) {
            AbstractComponent removed = (AbstractComponent)a2;
            if (this.components.get(removed.getName()) != removed) continue;
            this.components.remove(removed.getName());
            Change change = new Change((Object)this, null, (Object)removed, null);
            children.addChildren(Change.addChange(null, (Change)change));
            this.clearComponentArrays();
        }
    }

    private void clearComponentArrays() {
        this.componentsArray = null;
    }

    @Override
    public String getXMLName() {
        return "library";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        XModelObject old = this.pushModelObject(context);
        this.saveAttributeValues(element);
        for (IComponent c : this.components.values()) {
            ((KbObject)((Object)c)).toXML(element, context);
        }
        this.popModelObject(context, old);
        return element;
    }

    protected void saveAttributeValues(Element element) {
    }

    @Override
    public void loadXML(Element element, Properties context) {
        Element[] cs;
        super.loadXML(element, context);
        XModelObject old = this.pushModelObject(context);
        this.loadAttributeValues(element);
        Element[] elementArray = cs = XMLUtilities.getChildren((Element)element, (String)"component");
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            Element e = elementArray[n2];
            String cls = e.getAttribute("class");
            AbstractComponent c = null;
            if ("tld".equals(cls)) {
                c = new TLDTag();
            } else if ("facelet".equals(cls)) {
                c = new FaceletTag();
            } else if ("faces-config".equals(cls)) {
                c = new FacesConfigComponent();
            } else if ("composite".equals(cls)) {
                c = new CompositeComponent();
            } else if ("myfaces".equals(cls)) {
                c = new MyFacesComponent();
            }
            if (c != null) {
                c.loadXML(e, context);
                this.addComponent(c);
            }
            ++n2;
        }
        this.popModelObject(context, old);
    }

    protected void loadAttributeValues(Element element) {
        this.setURI((IValueInfo)this.attributesInfo.get(URI));
    }
}

