/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.proposal;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.jboss.tools.jst.web.kb.taglib.Facet;
import org.jboss.tools.jst.web.kb.taglib.IComponent;
import org.jboss.tools.jst.web.kb.taglib.IFacesConfigTagLibrary;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;

public class FacetNameProposalType
extends CustomProposalType {
    private static final String IMAGE_NAME = "EnumerationProposal.gif";
    private static ImageDescriptor ICON;
    private IPageContext context;

    @Override
    public TextProposal[] getProposals(KbQuery query) {
        String[] parentTags = query.getParentTags();
        HashSet<String> facetNames = new HashSet<String>();
        if (parentTags.length > 1) {
            String parentTag = parentTags[parentTags.length - 2];
            KbQuery newQuery = new KbQuery();
            newQuery.setMask(false);
            newQuery.setType(KbQuery.Type.TAG_NAME);
            newQuery.setValue(parentTag);
            newQuery.setOffset(query.getOffset());
            IComponent[] components = PageProcessor.getInstance().getComponents(newQuery, this.context);
            HashSet<String> types = new HashSet<String>();
            int i = 0;
            while (i < components.length) {
                String type = components[i].getComponentType();
                if (type != null) {
                    types.add(type.trim());
                }
                ++i;
            }
            if (!types.isEmpty()) {
                ITagLibrary[] libs;
                ITagLibrary[] iTagLibraryArray = libs = TagLibraryManager.getLibraries(this.context.getResource().getProject());
                int n = libs.length;
                int n2 = 0;
                while (n2 < n) {
                    ITagLibrary lib = iTagLibraryArray[n2];
                    if (lib instanceof IFacesConfigTagLibrary) {
                        for (String type : types) {
                            Facet[] facets;
                            IComponent comp = lib.getComponentByType(type);
                            if (comp == null || (facets = comp.getFacets()) == null) continue;
                            int i2 = 0;
                            while (i2 < facets.length) {
                                facetNames.add(facets[i2].getName());
                                ++i2;
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
        for (String facetName : facetNames) {
            if (!facetName.startsWith(query.getValue())) continue;
            TextProposal proposal = new TextProposal();
            proposal.setLabel(facetName);
            proposal.setReplacementString(facetName);
            proposal.setPosition(facetName.length());
            if (ICON == null) {
                ICON = ImageDescriptor.createFromFile(WebKbPlugin.class, (String)IMAGE_NAME);
            }
            proposal.setImageDescriptor(ICON);
            proposals.add(proposal);
        }
        return proposals.toArray(new TextProposal[0]);
    }

    @Override
    protected void init(IPageContext context) {
        this.context = context;
    }
}

