/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.internal.scanner.IFileScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.JSF2ResourcesScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.LoadedDeclarations;
import org.jboss.tools.jst.web.kb.internal.scanner.MyFacesScanner;
import org.jboss.tools.jst.web.kb.internal.scanner.ScannerException;
import org.jboss.tools.jst.web.kb.internal.scanner.XMLScanner;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;

public class KbResourceVisitor
implements IResourceVisitor {
    static IFileScanner[] FILE_SCANNERS = new IFileScanner[]{new MyFacesScanner(), new XMLScanner()};
    JSF2ResourcesScanner jsf2scanner = new JSF2ResourcesScanner();
    KbProject p;
    IPath[] outs = new IPath[0];
    IPath[] srcs = new IPath[0];
    IPath[] webinfs = new IPath[0];
    IPath[] jsf2resources = new IPath[0];
    Set<IPath> jsf2resourcesProcessed = new HashSet<IPath>();

    public KbResourceVisitor(KbProject p) {
        this.p = p;
        if (p.getProject() != null && p.getProject().isOpen()) {
            int n;
            this.getJavaSourceRoots(p.getProject());
            ArrayList<IPath> jsf2rs = new ArrayList<IPath>();
            XModel model = InnerModelHelper.createXModel((IProject)p.getProject());
            if (model != null) {
                IPath[] webContents;
                this.webinfs = WebUtils.getWebInfPaths((IProject)p.getProject());
                IPath[] iPathArray = webContents = WebUtils.getWebContentPaths((IProject)p.getProject());
                int n2 = webContents.length;
                n = 0;
                while (n < n2) {
                    IPath webcontent = iPathArray[n];
                    IPath jsf2r = webcontent.append("resources");
                    IFolder rf = ResourcesPlugin.getWorkspace().getRoot().getFolder(jsf2r);
                    if (rf.exists() && !jsf2rs.contains(jsf2r)) {
                        jsf2rs.add(jsf2r);
                    }
                    ++n;
                }
            }
            IPath[] iPathArray = this.srcs;
            n = this.srcs.length;
            int n3 = 0;
            while (n3 < n) {
                IPath s = iPathArray[n3];
                IPath jsf2r = s.append("META-INF/resources");
                IFolder rf = ResourcesPlugin.getWorkspace().getRoot().getFolder(jsf2r);
                if (rf.exists() && !jsf2rs.contains(jsf2r)) {
                    jsf2rs.add(jsf2r);
                }
                ++n3;
            }
            this.jsf2resources = jsf2rs.toArray(new IPath[0]);
        }
    }

    public IResourceVisitor getVisitor() {
        return this;
    }

    public void init() {
        this.jsf2resourcesProcessed.clear();
    }

    public boolean visit(IResource resource) {
        int n;
        int n2;
        IPath[] iPathArray;
        if (resource instanceof IFile) {
            IFile f = (IFile)resource;
            int i = 0;
            while (i < this.outs.length) {
                if (this.outs[i].isPrefixOf(resource.getFullPath())) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < FILE_SCANNERS.length) {
                IFileScanner scanner = FILE_SCANNERS[i];
                if (scanner.isRelevant(f)) {
                    if (!scanner.isLikelyComponentSource(f)) {
                        this.p.pathRemoved(f.getFullPath());
                        return false;
                    }
                    LoadedDeclarations c = null;
                    try {
                        c = scanner.parse(f, this.p);
                    }
                    catch (ScannerException e) {
                        WebKbPlugin.getDefault().logError(e);
                    }
                    if (c == null) break;
                    this.componentsLoaded(c, (IResource)f);
                    break;
                }
                ++i;
            }
            iPathArray = this.jsf2resources;
            n2 = this.jsf2resources.length;
            n = 0;
            while (n < n2) {
                IPath jsf2resource = iPathArray[n];
                if (jsf2resource.isPrefixOf(f.getFullPath()) && this.jsf2scanner.isLikelyComponentSource(f)) {
                    this.processJSF2Resources(jsf2resource);
                    break;
                }
                ++n;
            }
        }
        if (resource instanceof IFolder) {
            IPath path = resource.getFullPath();
            int i = 0;
            while (i < this.outs.length) {
                if (this.outs[i].isPrefixOf(path)) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < this.srcs.length) {
                if (this.srcs[i].isPrefixOf(path) || path.isPrefixOf(this.srcs[i])) {
                    return true;
                }
                ++i;
            }
            iPathArray = this.jsf2resources;
            n2 = this.jsf2resources.length;
            n = 0;
            while (n < n2) {
                IPath jsf2resource = iPathArray[n];
                if (jsf2resource.isPrefixOf(path)) {
                    this.processJSF2Resources(jsf2resource);
                    return false;
                }
                if (path.isPrefixOf(jsf2resource)) {
                    return true;
                }
                ++n;
            }
            iPathArray = this.webinfs;
            n2 = this.webinfs.length;
            n = 0;
            while (n < n2) {
                IPath webinf = iPathArray[n];
                if (webinf.isPrefixOf(path) || path.isPrefixOf(webinf) || webinf.removeLastSegments(1).isPrefixOf(path)) {
                    return true;
                }
                ++n;
            }
            return resource == resource.getProject();
        }
        return true;
    }

    void processJSF2Resources(IPath jsf2resource) {
        if (this.jsf2resourcesProcessed.contains(jsf2resource)) {
            return;
        }
        this.jsf2resourcesProcessed.add(jsf2resource);
        IFolder jsf2resourcesFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(jsf2resource);
        if (!jsf2resourcesFolder.exists()) {
            return;
        }
        JSF2ResourcesScanner scanner = new JSF2ResourcesScanner();
        Map<IPath, LoadedDeclarations> result = null;
        try {
            result = scanner.parse(jsf2resourcesFolder, (IKbProject)this.p);
        }
        catch (ScannerException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        if (result != null) {
            for (IPath path : result.keySet()) {
                LoadedDeclarations c = result.get(path);
                this.p.registerComponents(c, path);
            }
            this.p.updateChildPaths(jsf2resourcesFolder.getFullPath(), result.keySet());
        }
    }

    void componentsLoaded(LoadedDeclarations c, IResource resource) {
        if (c == null || c.getLibraries().size() == 0) {
            return;
        }
        this.p.registerComponents(c, resource.getFullPath());
    }

    void getJavaSourceRoots(IProject project) {
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject == null) {
            return;
        }
        ArrayList<IPath> ps = new ArrayList<IPath>();
        ArrayList<IPath> os = new ArrayList<IPath>();
        try {
            IPath output = javaProject.getOutputLocation();
            if (output != null) {
                os.add(output);
            }
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                if (es[i].getEntryKind() == 3) {
                    IPath out;
                    IResource findMember = ModelPlugin.getWorkspace().getRoot().findMember(es[i].getPath());
                    if (findMember != null && findMember.exists()) {
                        ps.add(findMember.getFullPath());
                    }
                    if ((out = es[i].getOutputLocation()) != null && !os.contains(out)) {
                        os.add(out);
                    }
                }
                ++i;
            }
            this.srcs = ps.toArray(new IPath[0]);
            this.outs = os.toArray(new IPath[0]);
        }
        catch (CoreException ce) {
            ModelPlugin.getPluginLog().logError("Error while locating java source roots for " + project, (Throwable)ce);
        }
    }
}

