/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import org.eclipse.core.resources.IFile;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.jst.web.kb.internal.JSRecognizer;
import org.jboss.tools.jst.web.kb.internal.taglib.html.jq.JQueryMobileVersion;

public class JQueryMobileRecognizer
extends JSRecognizer {
    private static final String JQUERY_MOBILE_JS_LIB_NAME = "jquery.mobile-";
    private static final String JQUERY_MOBILE_JS_PATTERN_START = ".*(jquery.mobile-";
    private static final String JQUERY_MOBILE_JS_PATTERN_END = ").*(.js).*";

    @Override
    protected String getJSPattern() {
        return JQUERY_MOBILE_JS_PATTERN_START + (this.lib.getVersion() != null ? this.lib.getVersion() : "") + JQUERY_MOBILE_JS_PATTERN_END;
    }

    @Override
    public String getVersion(ELContext context) {
        String version = JQueryMobileRecognizer.getJSReferenceVersion(context.getResource(), this.getJSLibName());
        if (version == null) {
            return null;
        }
        if (version.equals(JQueryMobileVersion.JQM_1_3.toString())) {
            return JQueryMobileVersion.JQM_1_3.toString();
        }
        return JQueryMobileVersion.JQM_1_4.toString();
    }

    public static String getVersion(IFile file) {
        String version = JQueryMobileRecognizer.getJSReferenceVersion(file, JQUERY_MOBILE_JS_LIB_NAME);
        if (version == null) {
            return null;
        }
        if (version.equals(JQueryMobileVersion.JQM_1_3.toString())) {
            return JQueryMobileVersion.JQM_1_3.toString();
        }
        return JQueryMobileVersion.JQM_1_4.toString();
    }

    @Override
    protected String getJSLibName() {
        return JQUERY_MOBILE_JS_LIB_NAME;
    }
}

