/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.HTMLRecognizer;
import org.jboss.tools.jst.web.kb.internal.JSRecognizer;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.w3c.dom.NodeList;

public class AngularJSRecognizer
extends HTMLRecognizer {
    private static final String ANGULAR_JS_LIB_NAME = "angular";
    private static final String ANGULAR_JS_PATTERN = ".*(angular).*(.js).*";
    private static final String ANGULAR_NG_ATTRIBUTE_PATTERN = "//*/@*[starts-with(name(), 'ng-')]|//*/@*[starts-with(name(), 'data-ng-')]";

    @Override
    protected boolean recalculateResult(ITagLibrary lib, ELContext context, IFile file) {
        if (super.recalculateResult(lib, context, file)) {
            final Boolean[] result = new Boolean[]{JSRecognizer.getJSReferenceVersion(file, ANGULAR_JS_LIB_NAME) != null};
            if (!result[0].booleanValue()) {
                StructuredModelWrapper.execute((IFile)file, (StructuredModelWrapper.ICommand)new StructuredModelWrapper.ICommand(){

                    public void execute(IDOMDocument xmlDocument) {
                        try {
                            NodeList list = (NodeList)XPathFactory.newInstance().newXPath().compile(AngularJSRecognizer.ANGULAR_NG_ATTRIBUTE_PATTERN).evaluate(xmlDocument, XPathConstants.NODESET);
                            int i = 0;
                            while (i < list.getLength()) {
                                IDOMAttr cfr_ignored_0 = (IDOMAttr)list.item(i);
                                ++i;
                            }
                            result[0] = list.getLength() > 0;
                        }
                        catch (XPathExpressionException e) {
                            WebKbPlugin.getDefault().logError(e);
                        }
                    }
                });
            }
            return result[0];
        }
        return false;
    }
}

