/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.internal.KbProject;

public class CDIProjectTree
implements IValidatingProjectTree {
    private Map<IProject, IValidatingProjectSet> brunches = new HashMap<IProject, IValidatingProjectSet>();
    private Set<IProject> validatingProjects = new HashSet<IProject>();
    private Set<IProject> allProjects = new HashSet<IProject>();

    public CDIProjectTree(IProject project) {
        this.addProject(project);
    }

    public void addProject(IProject project) {
        if (project != null) {
            this.allProjects.add(project);
            if (!this.validatingProjects.contains(project)) {
                this.validatingProjects.add(project);
                CDICoreNature currentNature = CDICorePlugin.getCDI(project, true);
                if (currentNature != null) {
                    Set<CDICoreNature> roots = this.getRootProjects(currentNature);
                    for (CDICoreNature root : roots) {
                        IProjectValidationContext rootContext;
                        IProject rootProject = root.getProject();
                        if (rootProject == null || !rootProject.isAccessible()) continue;
                        Set<IProject> requiredProjects = this.collectRequiredProjects(root);
                        IKbProject kbProject = KbProjectFactory.getKbProject((IProject)rootProject, (boolean)false);
                        if (kbProject != null) {
                            rootContext = kbProject.getValidationContext();
                        } else {
                            KbProject.checkKBBuilderInstalled((IResource)rootProject);
                            rootContext = root.getValidationContext();
                        }
                        requiredProjects.add(root.getProject());
                        for (IProject p : requiredProjects) {
                            CDICorePlugin.getCDI(p, true);
                        }
                        ValidatingProjectSet brunch = new ValidatingProjectSet(root.getProject(), requiredProjects, rootContext);
                        this.brunches.put(rootProject, (IValidatingProjectSet)brunch);
                        this.allProjects.addAll(brunch.getAllProjects());
                    }
                }
            }
        }
    }

    public Map<IProject, IValidatingProjectSet> getBrunches() {
        return this.brunches;
    }

    public Set<IProject> getValidatingProjects() {
        return this.validatingProjects;
    }

    public Set<IProject> getAllProjects() {
        return this.allProjects;
    }

    private Set<CDICoreNature> getRootProjects(CDICoreNature project) {
        HashSet<CDICoreNature> result = new HashSet<CDICoreNature>();
        CDICoreNature[] dependentProjects = project.getAllDependentProjects(true);
        if (dependentProjects.length == 0) {
            result.add(project);
        } else {
            CDICoreNature[] cDICoreNatureArray = dependentProjects;
            int n = dependentProjects.length;
            int n2 = 0;
            while (n2 < n) {
                CDICoreNature nature = cDICoreNatureArray[n2];
                if (nature.getProject().isAccessible() && nature.getDependentProjects().isEmpty()) {
                    result.add(nature);
                }
                ++n2;
            }
        }
        return result;
    }

    private Set<IProject> collectRequiredProjects(CDICoreNature project) {
        return this.collectRequiredProjects(new HashSet<IProject>(), project);
    }

    private Set<IProject> collectRequiredProjects(Set<IProject> dependsOn, CDICoreNature project) {
        Set<CDICoreNature> cdiProjects = project.getCDIProjects();
        for (CDICoreNature cdiCoreNature : cdiProjects) {
            IProject includedProject = cdiCoreNature.getProject();
            if (dependsOn.contains(includedProject)) continue;
            dependsOn.add(includedProject);
            this.collectRequiredProjects(dependsOn, cdiCoreNature);
        }
        return dependsOn;
    }
}

