/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.scanner.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.extension.CDIExtensionFactory;
import org.jboss.tools.cdi.internal.core.scanner.lib.BeanArchiveDetector;
import org.jboss.tools.cdi.internal.core.scanner.lib.JarSet;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.project.ext.AbstractClassPathMonitor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class ClassPathMonitor
extends AbstractClassPathMonitor<CDICoreNature> {
    private static final String RECOGNIZED_RUNTIMES_PATH = "_recognized_";
    IPath[] srcs = new IPath[0];
    Map<FileAnyImpl, Long> servicesInSrc = new HashMap<FileAnyImpl, Long>();
    Set<IPath> removedPaths = new HashSet<IPath>();
    private static String SERVICE_PATH = "META-INF/services/javax.enterprise.inject.spi.Extension";
    private static Set<String> EMPTY_RUNTIMES = new HashSet<String>();

    public ClassPathMonitor(CDICoreNature project) {
        this.project = project;
    }

    public void init() {
        this.model = EclipseResourceUtil.createObjectForResource((IResource)this.getProjectResource()).getModel();
        super.init();
    }

    public synchronized boolean update() {
        Libs libs = FileSystemsHelper.getLibs((XModel)this.model);
        if (libs == null) {
            return false;
        }
        boolean r1 = this.updateServicesInSrcs();
        boolean r2 = super.update();
        return r1 || r2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarSet process() {
        Object object;
        JarSet newJars = new JarSet();
        for (String p : this.syncProcessedPaths()) {
            object = this.removedPaths;
            synchronized (object) {
                this.removedPaths.add((IPath)new Path(p));
            }
            ((CDICoreNature)this.project).getExtensionManager().pathRemoved(p);
        }
        boolean newRuntimeDetected = false;
        HashSet processed = new HashSet();
        object = this;
        synchronized (object) {
            processed.addAll(this.processedPaths);
        }
        int i = 0;
        while (i < this.paths.size()) {
            String p = (String)this.paths.get(i);
            if (this.requestForLoad(p)) {
                XModelObject o;
                this.removedPaths.add((IPath)new Path(p));
                String fileName = new File(p).getName();
                if (!EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName) && (o = FileSystemsHelper.getLibs((XModel)this.model).getLibrary(p)) != null) {
                    boolean nrd = ((CDICoreNature)this.project).getExtensionManager().setRuntimes(p, this.readRuntimes(o));
                    if (nrd) {
                        newRuntimeDetected = true;
                    }
                    this.detectBeanModule(p, o, newJars);
                }
            }
            ++i;
        }
        for (FileAnyImpl s : this.servicesInSrc.keySet()) {
            boolean nrd;
            IResource r = (IResource)s.getAdapter(IResource.class);
            if (r == null || !r.exists() || !(nrd = ((CDICoreNature)this.project).getExtensionManager().setRuntimes(r.getFullPath().toString(), this.readRuntimesInService(s)))) continue;
            newRuntimeDetected = true;
        }
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)((CDICoreNature)this.project).getProject());
        Set<String> recognizedRuntimes = CDIExtensionFactory.getInstance().getRecognizedRuntimes(javaProject);
        boolean nrd = ((CDICoreNature)this.project).getExtensionManager().setRuntimes(RECOGNIZED_RUNTIMES_PATH, recognizedRuntimes);
        if (nrd) {
            newRuntimeDetected = true;
        }
        if (newRuntimeDetected) {
            for (String p : processed) {
                XModelObject o;
                String fileName = new File(p).getName();
                if (EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName) || (o = FileSystemsHelper.getLibs((XModel)this.model).getLibrary(p)) == null) continue;
                this.detectBeanModule(p, o, newJars);
            }
        }
        this.validateProjectDependencies();
        return newJars;
    }

    private void detectBeanModule(String path, XModelObject fs, JarSet newJars) {
        newJars.getFileSystems().put(path, fs);
        XModelObject b = fs.getChildByPath("META-INF/beans.xml");
        if (b != null) {
            newJars.getBeanModules().put(path, b);
        } else if (((CDICoreNature)this.project).getVersion() != CDIVersion.CDI_1_0) {
            int archiveType = BeanArchiveDetector.getInstance().getBeanArchive(path);
            if (archiveType == -1) {
                if (!this.readRuntimes(fs).isEmpty()) {
                    BeanArchiveDetector.getInstance().setBeanArchive(path, 0);
                    archiveType = 0;
                } else {
                    try {
                        archiveType = BeanArchiveDetector.getInstance().resolve(path, (CDICoreNature)this.project);
                    }
                    catch (JavaModelException e) {
                        CDICorePlugin.getDefault().logError(e);
                        return;
                    }
                }
            }
            if (archiveType != 0) {
                newJars.getBeanModules().put(path, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRemovedPaths() {
        Set<IPath> set = this.removedPaths;
        synchronized (set) {
            for (IPath p : this.removedPaths) {
                ((CDICoreNature)this.project).pathRemoved(p);
            }
            this.removedPaths.clear();
        }
    }

    public IProject getProjectResource() {
        return ((CDICoreNature)this.project).getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSrcs(IPath[] newSrcs) {
        IPath s;
        HashSet<IPath> ss = new HashSet<IPath>();
        IPath[] iPathArray = newSrcs;
        int n = newSrcs.length;
        int n2 = 0;
        while (n2 < n) {
            s = iPathArray[n2];
            ss.add(s);
            ++n2;
        }
        iPathArray = this.srcs;
        n = this.srcs.length;
        n2 = 0;
        while (n2 < n) {
            s = iPathArray[n2];
            if (!ss.contains(s)) {
                Set<IPath> set = this.removedPaths;
                synchronized (set) {
                    this.removedPaths.add(s);
                }
            }
            ++n2;
        }
        this.srcs = newSrcs;
    }

    public void validateProjectDependencies() {
        List<CDICoreNature> ps = null;
        try {
            ps = ClassPathMonitor.getProjects(((CDICoreNature)this.project).getProject());
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        if (ps != null) {
            Set<CDICoreNature> set = ((CDICoreNature)this.project).getCDIProjects();
            HashSet<CDICoreNature> removable = new HashSet<CDICoreNature>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            for (CDICoreNature p : ps) {
                ((CDICoreNature)this.project).addCDIProject(p);
            }
            for (CDICoreNature p : removable) {
                ((CDICoreNature)this.project).removeCDIProject(p);
            }
        }
    }

    public boolean hasToUpdateProjectDependencies() {
        List<CDICoreNature> ps = null;
        try {
            ps = ClassPathMonitor.getProjects(((CDICoreNature)this.project).getProject());
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        if (ps != null) {
            Set<CDICoreNature> set = ((CDICoreNature)this.project).getCDIProjects();
            HashSet<CDICoreNature> removable = new HashSet<CDICoreNature>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            Iterator<CDICoreNature> iterator = ps.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
            iterator = removable.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
        }
        return false;
    }

    public static List<CDICoreNature> getProjects(IProject project) throws CoreException {
        ArrayList<CDICoreNature> list = new ArrayList<CDICoreNature>();
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject != null) {
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                CDICoreNature sp;
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible() && (sp = CDICorePlugin.getCDI(p, false)) != null) {
                    list.add(sp);
                }
                ++i;
            }
        }
        return list;
    }

    private boolean updateServicesInSrcs() {
        Set fs = EclipseResourceUtil.getAllVisibleSourceFolders((IProject)((CDICoreNature)this.project).getProject());
        HashMap<FileAnyImpl, Long> newServices = new HashMap<FileAnyImpl, Long>();
        boolean result = false;
        for (IFolder folder : fs) {
            XModelObject o;
            IFile f = folder.getFile(SERVICE_PATH);
            if (!f.exists() || !((o = EclipseResourceUtil.createObjectForResource((IResource)f)) instanceof FileAnyImpl)) continue;
            FileAnyImpl s = (FileAnyImpl)o;
            newServices.put(s, s.getTimeStamp());
            Long old = this.servicesInSrc.get(s);
            if (old != null && old.longValue() == s.getTimeStamp()) continue;
            result = true;
        }
        if (this.servicesInSrc.size() != newServices.size()) {
            result = true;
        }
        this.servicesInSrc = newServices;
        return result;
    }

    private Set<String> readRuntimes(XModelObject jar) {
        XModelObject o = jar.getChildByPath(SERVICE_PATH);
        return o instanceof FileAnyImpl ? this.readRuntimesInService((FileAnyImpl)o) : EMPTY_RUNTIMES;
    }

    private Set<String> readRuntimesInService(FileAnyImpl o) {
        HashSet<String> result = new HashSet<String>();
        String text = o.getAsText();
        if (text == null || text.length() == 0) {
            return EMPTY_RUNTIMES;
        }
        StringTokenizer st = new StringTokenizer(text, "\r\n\t");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (t.length() == 0 || t.startsWith("#") || t.length() <= 0) continue;
            result.add(t);
        }
        return result;
    }

    public synchronized void libraryChanged(String path) {
        super.libraryChanged(path);
        this.removedPaths.add((IPath)new Path(path));
        ((CDICoreNature)this.project).getExtensionManager().pathRemoved(path);
    }
}

