/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.scanner.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;

public class BeanArchiveDetector {
    public static final int UNRESOLVED = -1;
    public static final int NOT_ARCHIVE = 0;
    public static final int NONE = 1;
    public static final int ANNOTATED = 2;
    public static final int ALL = 3;
    public static BeanArchiveDetector instance = new BeanArchiveDetector();
    boolean isLoaded = false;
    boolean isDirty = false;
    Map<String, Result> paths = new HashMap<String, Result>();

    public static BeanArchiveDetector getInstance() {
        return instance;
    }

    private BeanArchiveDetector() {
    }

    public synchronized int getBeanArchive(String path) {
        this.load();
        if (!this.paths.containsKey(path)) {
            return -1;
        }
        int size = this.getSize(path);
        if (size != this.paths.get((Object)path).size) {
            this.paths.remove(path);
            this.isDirty = true;
            return -1;
        }
        return this.paths.get((Object)path).archive;
    }

    public synchronized void setBeanArchive(String path, int archive) {
        this.load();
        int size = this.getSize(path);
        if (size > 0) {
            this.paths.put(path, new Result(size, archive));
            this.isDirty = true;
        }
    }

    private int getSize(String path) {
        return this.getSize(new File(path));
    }

    private int getSize(File f) {
        if (f.isFile()) {
            return (int)f.length();
        }
        if (f.isDirectory()) {
            int result = 0;
            File[] fs = f.listFiles();
            if (fs != null) {
                File[] fileArray = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File c = fileArray[n2];
                    result += this.getSize(c);
                    ++n2;
                }
            }
            return result;
        }
        return 0;
    }

    private synchronized void load() {
        if (this.isLoaded) {
            return;
        }
        try {
            File f = this.getStorageFile();
            if (f.isFile()) {
                String content = FileUtil.readFile((File)f);
                StringTokenizer st = new StringTokenizer(content, "\n");
                String path = null;
                int size = 0;
                int archive = -1;
                int c = 0;
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (c == 0 && t.startsWith("path=")) {
                        path = t.substring(5);
                        ++c;
                        continue;
                    }
                    if (c == 1 && t.startsWith("size=")) {
                        try {
                            size = Integer.parseInt(t.substring(5));
                            ++c;
                        }
                        catch (NumberFormatException e) {
                            CDICorePlugin.getDefault().logError(e);
                        }
                        continue;
                    }
                    if (c != 2 || !t.startsWith("archive=")) continue;
                    try {
                        archive = Integer.parseInt(t.substring(8));
                        if (this.getSize(path) == size) {
                            this.paths.put(path, new Result(size, archive));
                        }
                        c = 0;
                    }
                    catch (NumberFormatException e) {
                        CDICorePlugin.getDefault().logError(e);
                    }
                }
            }
        }
        finally {
            this.isLoaded = true;
        }
    }

    public synchronized void save() {
        if (this.isLoaded && this.isDirty) {
            this.isDirty = false;
            File f = this.getStorageFile();
            StringBuilder sb = new StringBuilder();
            for (String path : this.paths.keySet()) {
                Result r = this.paths.get(path);
                sb.append("path=").append(path).append("\n").append("size=").append(r.size).append("\n").append("archive=").append(r.archive).append("\n");
            }
            FileUtil.writeFile((File)f, (String)sb.toString());
        }
    }

    private File getStorageFile() {
        CDICorePlugin plugin = CDICorePlugin.getDefault();
        if (plugin != null) {
            IPath path = plugin.getStateLocation();
            File file = new File(path.toFile(), "bean-archives.txt");
            return file;
        }
        return null;
    }

    public int resolve(String jar, CDICoreNature project) throws JavaModelException {
        IPackageFragmentRoot root = BeanArchiveDetector.findPackageFragmentRoot(jar, project);
        if (root != null && root.exists()) {
            if (BeanArchiveDetector.hasAnnotatedBeans(root, project)) {
                this.setBeanArchive(jar, 2);
            } else {
                this.setBeanArchive(jar, 0);
            }
        }
        return -1;
    }

    public static boolean hasAnnotatedBeans(IPackageFragmentRoot root, CDICoreNature project) throws JavaModelException {
        IJavaElement[] es;
        IJavaElement[] iJavaElementArray = es = root.getChildren();
        int n = es.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement e = iJavaElementArray[n2];
            if (e instanceof IPackageFragment) {
                IClassFile[] cs;
                IPackageFragment pf = (IPackageFragment)e;
                IClassFile[] iClassFileArray = cs = pf.getClassFiles();
                int n3 = cs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClassFile c = iClassFileArray[n4];
                    if (BeanArchiveDetector.isAnnotatedBean(c.getType(), project)) {
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAnnotatedBean(IType type, CDICoreNature project) throws JavaModelException {
        IAnnotation[] as;
        IAnnotation[] iAnnotationArray = as = type.getAnnotations();
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation a = iAnnotationArray[n2];
            String typeName = EclipseJavaUtil.resolveType((IType)type, (String)a.getElementName());
            if ("javax.ejb.Stateless".equals(typeName) || "javax.ejb.Singleton".equals(typeName)) {
                return true;
            }
            IType at = project.getType(typeName);
            if (at != null && project.getDefinitions().getAnnotationKind(at) == 32) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IType findPackageInfo(IClassFile[] cs) {
        IClassFile[] iClassFileArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            IClassFile cf = iClassFileArray[n2];
            IType c = cf.getType();
            if ("package-info".equals(c.getElementName())) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isVetoed(IType type) throws JavaModelException {
        IAnnotation[] as;
        IAnnotation[] iAnnotationArray = as = type.getAnnotations();
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation a = iAnnotationArray[n2];
            String typeName = EclipseJavaUtil.resolveType((IType)type, (String)a.getElementName());
            if ("javax.enterprise.inject.Vetoed".equals(typeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IType[] getAnnotatedTypes(IType[] ts, CDICoreNature project) throws CoreException {
        if (ts.length == 1 && BeanArchiveDetector.isAnnotatedBean(ts[0], project)) {
            return ts;
        }
        ArrayList<IType> result = new ArrayList<IType>();
        IType[] iTypeArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (BeanArchiveDetector.isAnnotatedBean(t, project)) {
                result.add(t);
            }
            ++n2;
        }
        return result.toArray(new IType[0]);
    }

    public static IPackageFragmentRoot findPackageFragmentRoot(String jar, CDICoreNature project) {
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)project.getProject());
        return jp == null ? null : BeanArchiveDetector.findPackageFragmentRoot(jar, jp);
    }

    public static IPackageFragmentRoot findPackageFragmentRoot(String jar, IJavaProject jp) {
        IPackageFragmentRoot root = jp.getPackageFragmentRoot(jar);
        if (root != null && !root.exists()) {
            IFile f = EclipseResourceUtil.getFile((String)jar);
            if (f != null && f.exists()) {
                root = jp.getPackageFragmentRoot((IResource)f);
            } else {
                IContainer c = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(new Path(String.valueOf(jar) + "/META-INF").makeAbsolute());
                if (c != null && c.exists()) {
                    root = jp.getPackageFragmentRoot((IResource)c.getParent());
                }
            }
        }
        return root;
    }

    static class Result {
        int size;
        int archive = -1;

        Result(int size, int archive) {
            this.size = size;
            this.archive = archive;
        }
    }
}

